/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.opentrace;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.OpenTraceDialog;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class SaveFilesTable
extends DATableComposite {
    private boolean isValidVersion = true;
    private static final int TRACE_NAME_INDEX = 0;
    private static final int DATE_INDEX = 1;
    public static final int VALIDATE_INDEX = 2;
    private static final int COLUMN_COUNT = 3;
    public static final String VALIDATE_Y = "Y";
    public static final String VALIDATE_N = "N";

    public SaveFilesTable(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<String> saveFileList = AnalyzerUtil.getDirs(PathManager.DA_SAVE_PATH);
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        if (saveFileList != null) {
            int size = saveFileList.size();
            int i = 0;
            while (i < size) {
                ArrayList<String> text = new ArrayList<String>();
                String path = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + saveFileList.get(i);
                String inputText1 = saveFileList.get(i);
                String inputText2 = this.getCreateTime(path);
                if (!inputText1.isEmpty() && inputText2 != null && !inputText2.isEmpty()) {
                    text.add(inputText1);
                    text.add(inputText2);
                    if (this.isValidVersion) {
                        text.add(VALIDATE_Y);
                    } else {
                        text.add(VALIDATE_N);
                    }
                    TableInput tableInput = new TableInput();
                    tableInput.setText(text);
                    input.add(tableInput);
                }
                ++i;
            }
        }
        return input;
    }

    @Override
    public void updateTable() {
        this.table.removeAll();
        List<TableInput> input = this.makeTableInput();
        if (input == null) {
            return;
        }
        if (this.comparator != null) {
            Collections.sort(input, this.comparator);
        }
        int size = input.size();
        int i = 0;
        while (i < size) {
            List<String> text = input.get(i).getText();
            if (text.size() >= 3 && !text.get(0).isEmpty() && text.get(1) != null && !text.get(1).isEmpty()) {
                GridItem gridItem = new GridItem(this.table, 0);
                gridItem.setData((Object)OpenTraceDialog.SAVE_FOLDER);
                gridItem.setData(OpenTraceDialog.CURRENT_KEY, (Object)OpenTraceDialog.OTHERS);
                int index = 0;
                while (index < 3) {
                    String inputText = text.get(index);
                    gridItem.setText(index, inputText);
                    ++index;
                }
                if (text.get(2).equals(VALIDATE_N)) {
                    gridItem.setForeground(ColorResources.ORANGE);
                    gridItem.setData(OpenTraceDialog.VERSION_KEY, (Object)OpenTraceDialog.VERSION_INVALID);
                    gridItem.setData(OpenTraceDialog.CURRENT_KEY, (Object)OpenTraceDialog.OTHERS);
                    gridItem.setToolTipText(0, AnalyzerLabels.OPEN_TRACE_DLG_OLD_VERSION);
                    gridItem.setToolTipText(1, AnalyzerLabels.OPEN_TRACE_DLG_OLD_VERSION);
                } else {
                    String projectPath;
                    gridItem.setData(OpenTraceDialog.VERSION_KEY, (Object)OpenTraceDialog.VERSION_VALID);
                    String path = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + text.get(0);
                    Project project = Global.getProject();
                    if (project != null && path.equals(projectPath = project.getSavePath())) {
                        gridItem.setForeground(ColorResources.BLUE);
                        gridItem.setData(OpenTraceDialog.CURRENT_KEY, (Object)OpenTraceDialog.CURRENT);
                        gridItem.setToolTipText(0, AnalyzerLabels.OPEN_TRACE_DLG_CURRENT_TRACE);
                        gridItem.setToolTipText(1, AnalyzerLabels.OPEN_TRACE_DLG_CURRENT_TRACE);
                    }
                }
            }
            ++i;
        }
        this.table.update();
    }

    private String getCreateTime(String path) {
        Project project = Project.getProjectFromFile(path);
        if (project != null) {
            this.isValidVersion = true;
            return project.getCreateTime();
        }
        return null;
    }
}

