/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.tizen.dynamicanalyzer.database.IPreparedStatement;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class SqlConnectionManager {
    private static final int CONNECTION_COUNT_UPDATE = 8;
    private static final int CONNECTION_COUNT_QUERY = 8;
    private static BlockingQueue<Connection> updateConnections = null;
    private static BlockingQueue<Connection> queryConnections = null;
    private static Object updateConnectionLock = new Object();
    private static Object queryConnectionLock = new Object();
    private static State state = State.NOT_CONNECTED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean establishConnection(String dbFilePath) {
        boolean result = true;
        Connection conn = null;
        try {
            try {
                Class<SqlConnectionManager> clazz = SqlConnectionManager.class;
                synchronized (SqlConnectionManager.class) {
                    if (updateConnections == null && queryConnections == null) {
                        SQLWarning warning;
                        updateConnections = new LinkedBlockingQueue<Connection>();
                        queryConnections = new LinkedBlockingQueue<Connection>();
                        Class.forName("org.hsqldb.jdbcDriver");
                        String dbUrl = "jdbc:hsqldb:" + dbFilePath + ";shutdown=false;hsqldb.default_table_type=cached" + ";hsqldb.tx=mvcc;hsqldb.large_data=true;hdqldb.log_data=false";
                        int i = 0;
                        while (i < 8) {
                            conn = DriverManager.getConnection(dbUrl, "SA", "");
                            updateConnections.offer(conn);
                            warning = conn.getWarnings();
                            while (warning != null) {
                                Logger.debug((Object)("[DB][" + i + "] Message: " + warning.getMessage()));
                                Logger.debug((Object)("[DB][" + i + "] SQL state: " + warning.getSQLState()));
                                Logger.debug((Object)("[DB][" + i + "] Vendor code: " + warning.getErrorCode()));
                                warning = warning.getNextWarning();
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < 8) {
                            conn = DriverManager.getConnection(dbUrl, "SA", "");
                            queryConnections.offer(conn);
                            warning = conn.getWarnings();
                            while (warning != null) {
                                Logger.debug((Object)("[DB][" + i + "] Message: " + warning.getMessage()));
                                Logger.debug((Object)("[DB][" + i + "] SQL state: " + warning.getSQLState()));
                                Logger.debug((Object)("[DB][" + i + "] Vendor code: " + warning.getErrorCode()));
                                warning = warning.getNextWarning();
                            }
                            ++i;
                        }
                        state = State.CONNECTED;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (ClassNotFoundException e) {
                Logger.exception((Throwable)e);
                result = updateConnections != null && queryConnections != null;
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                result = updateConnections != null && queryConnections != null;
            }
        }
        finally {
            result = updateConnections != null && queryConnections != null;
        }
        {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeConnection() {
        var0 = SqlConnectionManager.class;
        synchronized (SqlConnectionManager.class) {
            block31: {
                block27: {
                    SqlConnectionManager.state = State.TO_BE_CLOSED;
                    if (SqlConnectionManager.updateConnections == null) break block27;
                    var1_1 = SqlConnectionManager.updateConnectionLock;
                    synchronized (var1_1) {
                        while (true) {
                            block30: {
                                if (SqlConnectionManager.updateConnections.size() != 8) break block30;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 21, 9, 10] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                                if (true) ** GOTO lbl32
                            }
                            try {
                                SqlConnectionManager.updateConnectionLock.wait();
                            }
                            catch (InterruptedException e) {
                                Logger.debug((Object)("Interrupted while closing update connection: " + e.getLocalizedMessage()));
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    do {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            Logger.exception((Throwable)e);
                        }
lbl32:
                        // 3 sources

                    } while ((conn = (Connection)SqlConnectionManager.updateConnections.poll()) != null);
                }
                if (SqlConnectionManager.queryConnections == null) break block31;
                conn = SqlConnectionManager.queryConnectionLock;
                synchronized (conn) {
                    while (true) {
                        block32: {
                            if (SqlConnectionManager.queryConnections.size() != 8) break block32;
                            // MONITOREXIT @DISABLED, blocks:[4, 23, 9, 11] lbl39 : MonitorExitStatement: MONITOREXIT : conn
                            if (true) ** GOTO lbl77
                        }
                        try {
                            SqlConnectionManager.queryConnectionLock.wait();
                        }
                        catch (InterruptedException e) {
                            Logger.debug((Object)("Interrupted while closing query connection: " + e.getLocalizedMessage()));
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                do {
                    block29: {
                        if (SqlConnectionManager.queryConnections.size() == 0) {
                            st = null;
                            try {
                                try {
                                    st = conn.createStatement();
                                    st.execute("SHUTDOWN");
                                }
                                catch (SQLException se) {
                                    if (!se.getSQLState().equals("XJ015")) {
                                        Logger.debug((Object)"DB did not shutdown normally");
                                    }
                                    CommonUtil.tryClose((Object[])new Object[]{st});
                                    break block29;
                                }
                            }
                            catch (Throwable var4_8) {
                                CommonUtil.tryClose((Object[])new Object[]{st});
                                throw var4_8;
                            }
                            CommonUtil.tryClose((Object[])new Object[]{st});
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                    }
lbl77:
                    // 3 sources

                } while ((conn = (Connection)SqlConnectionManager.queryConnections.poll()) != null);
            }
            SqlConnectionManager.updateConnections = null;
            SqlConnectionManager.queryConnections = null;
            SqlConnectionManager.state = State.NOT_CONNECTED;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Connection getUpdateConnection() {
        Connection retConn = null;
        if (state == State.CONNECTED) {
            try {
                retConn = updateConnections.take();
            }
            catch (InterruptedException e) {
                Logger.debug((Object)("Interrupted while getting update connection: " + e.getLocalizedMessage()));
                Thread.currentThread().interrupt();
            }
        }
        return retConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putUpdateConnection(Connection conn) {
        if (conn != null) {
            Object object = updateConnectionLock;
            synchronized (object) {
                updateConnections.offer(conn);
                updateConnectionLock.notifyAll();
            }
        }
    }

    private static Connection getQueryConnection() {
        Connection retConn = null;
        if (state == State.CONNECTED) {
            try {
                retConn = queryConnections.take();
            }
            catch (InterruptedException e) {
                Logger.debug((Object)("Interrupted while getting query connection: " + e.getLocalizedMessage()));
                Thread.currentThread().interrupt();
            }
        }
        return retConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putQueryConnection(Connection conn) {
        if (conn != null) {
            Object object = queryConnectionLock;
            synchronized (object) {
                queryConnections.offer(conn);
                queryConnectionLock.notifyAll();
            }
        }
    }

    public static boolean executeUpdate(String statement) {
        boolean bret;
        block9: {
            bret = false;
            Connection conn = null;
            Statement sm = null;
            try {
                try {
                    conn = SqlConnectionManager.getUpdateConnection();
                    if (conn != null) {
                        sm = conn.createStatement();
                        sm.executeUpdate(statement);
                        bret = true;
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{sm});
                    if (conn != null) {
                        SqlConnectionManager.putUpdateConnection(conn);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{sm});
                if (conn != null) {
                    SqlConnectionManager.putUpdateConnection(conn);
                }
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{sm});
            if (conn != null) {
                SqlConnectionManager.putUpdateConnection(conn);
            }
        }
        return bret;
    }

    public static void executePreparedWithInterface(String query, List<List<Object>> data, IPreparedStatement ip) {
        block19: {
            Connection conn = null;
            PreparedStatement prep = null;
            if (data.size() == 0) {
                return;
            }
            try {
                try {
                    conn = SqlConnectionManager.getUpdateConnection();
                    if (conn != null) {
                        int batchCount = 0;
                        prep = conn.prepareStatement(query);
                        int questionCount = 0;
                        int querylen = query.length();
                        int i = 0;
                        while (i < querylen) {
                            if (query.charAt(i) == '?') {
                                ++questionCount;
                            }
                            ++i;
                        }
                        int datasize = data.size();
                        conn.setAutoCommit(false);
                        int k = 0;
                        while (k < datasize) {
                            List<Object> row = data.get(k);
                            int datacolsize = row.size();
                            if (datacolsize == questionCount) {
                                try {
                                    if (ip.prepare(prep, row)) {
                                        prep.addBatch();
                                        ++batchCount;
                                    }
                                    prep.clearParameters();
                                }
                                catch (SQLException e) {
                                    Logger.exception((Throwable)e);
                                }
                            } else {
                                Logger.error((Object)"column count is not equal !!");
                            }
                            ++k;
                        }
                        if (batchCount > 0) {
                            prep.executeBatch();
                        }
                        conn.commit();
                        conn.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{prep});
                    if (conn != null) {
                        SqlConnectionManager.putUpdateConnection(conn);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{prep});
                if (conn != null) {
                    SqlConnectionManager.putUpdateConnection(conn);
                }
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{prep});
            if (conn != null) {
                SqlConnectionManager.putUpdateConnection(conn);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultSet executeQueryRS(String query) {
        Connection conn = null;
        Statement sm = null;
        ResultSet rs = null;
        try {
            conn = SqlConnectionManager.getQueryConnection();
            if (conn != null) {
                sm = conn.createStatement();
                rs = sm.executeQuery(query);
            }
        }
        catch (SQLSyntaxErrorException e) {
            String message = e.getMessage();
            String state = e.getSQLState();
            Logger.warning((Object)(String.valueOf(message) + " : state(" + state + ")"));
            if (rs != null) return rs;
            CommonUtil.tryClose((Object[])new Object[]{sm});
            if (conn == null) return rs;
            SqlConnectionManager.putQueryConnection(conn);
            return rs;
        }
        catch (SQLException e) {
            try {
                Logger.exception((Throwable)e);
                if (rs != null) return rs;
            }
            catch (Throwable throwable) {
                if (rs != null) throw throwable;
                CommonUtil.tryClose((Object[])new Object[]{sm});
                if (conn == null) throw throwable;
                SqlConnectionManager.putQueryConnection(conn);
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{sm});
            if (conn == null) return rs;
            SqlConnectionManager.putQueryConnection(conn);
            return rs;
        }
        if (rs != null) return rs;
        CommonUtil.tryClose((Object[])new Object[]{sm});
        if (conn == null) return rs;
        SqlConnectionManager.putQueryConnection(conn);
        return rs;
    }

    public static void releaseResultSet(ResultSet rs) {
        block10: {
            Connection conn = null;
            Statement sm = null;
            if (rs != null) {
                try {
                    try {
                        sm = rs.getStatement();
                        if (sm != null) {
                            conn = sm.getConnection();
                        }
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                        CommonUtil.tryClose((Object[])new Object[]{rs, sm});
                        if (conn != null) {
                            SqlConnectionManager.putQueryConnection(conn);
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{rs, sm});
                    if (conn != null) {
                        SqlConnectionManager.putQueryConnection(conn);
                    }
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{rs, sm});
                if (conn != null) {
                    SqlConnectionManager.putQueryConnection(conn);
                }
            }
        }
    }

    public static List<List<Object>> executeQuery(String query) {
        ResultSet rs = null;
        List<List<Object>> result = null;
        rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            result = SqlConnectionManager.convertResultSet(rs);
            SqlConnectionManager.releaseResultSet(rs);
        }
        return result;
    }

    private static <T> List<Object> addArray(int index, ResultSet rs, T type) {
        ArrayList<Object> returnData = new ArrayList<Object>();
        try {
            if (rs.getArray(index) == null) {
                returnData.add(null);
            } else {
                Object[] objectArray = (Object[])rs.getArray(index).getArray();
                int j = 0;
                while (j < objectArray.length) {
                    returnData.add(objectArray[j]);
                    ++j;
                }
            }
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnData;
    }

    private static List<List<Object>> convertResultSet(ResultSet rs) {
        ArrayList result = null;
        if (rs != null) {
            try {
                result = new ArrayList();
                ResultSetMetaData rsMetaData = rs.getMetaData();
                int columnCount = rsMetaData.getColumnCount();
                while (rs.next()) {
                    try {
                        ArrayList<Object> rowData = new ArrayList<Object>();
                        int i = 1;
                        while (i < columnCount + 1) {
                            if (rsMetaData.getColumnTypeName(i).contains("BOOLEAN ARRAY")) {
                                rowData.add(SqlConnectionManager.addArray(i, rs, new Boolean(true)));
                            } else if (rsMetaData.getColumnTypeName(i).contains("INTEGER ARRAY")) {
                                rowData.add(SqlConnectionManager.addArray(i, rs, new Integer(0)));
                            } else if (rsMetaData.getColumnTypeName(i).contains("BIGINT ARRAY")) {
                                rowData.add(SqlConnectionManager.addArray(i, rs, new Long(0L)));
                            } else if (rsMetaData.getColumnTypeName(i).contains("DOUBLE ARRAY")) {
                                rowData.add(SqlConnectionManager.addArray(i, rs, new Float(0.0f)));
                            } else if (rsMetaData.getColumnTypeName(i).contains("VARCHAR ARRAY")) {
                                rowData.add(SqlConnectionManager.addArray(i, rs, new String()));
                            } else if (rsMetaData.getColumnTypeName(i).contains("INTEGER")) {
                                rowData.add(rs.getInt(i));
                            } else if (rsMetaData.getColumnTypeName(i).contains("BIGINT")) {
                                rowData.add(rs.getLong(i));
                            } else if (rsMetaData.getColumnTypeName(i).contains("VARCHAR")) {
                                rowData.add(rs.getString(i));
                            } else if (rsMetaData.getColumnTypeName(i).contains("FLOAT")) {
                                rowData.add(Float.valueOf(rs.getFloat(i)));
                            } else if (rsMetaData.getColumnTypeName(i).contains("BOOLEAN")) {
                                rowData.add(rs.getBoolean(i));
                            } else if (rsMetaData.getColumnTypeName(i).contains("TINYINT")) {
                                rowData.add(rs.getByte(i));
                            } else if (rsMetaData.getColumnTypeName(i).contains("VARBINARY")) {
                                rowData.add(rs.getBytes(i));
                            } else {
                                Logger.error((Object)("undefined type : " + rsMetaData.getColumnTypeName(i)));
                            }
                            ++i;
                        }
                        result.add(rowData);
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
            }
        }
        return result;
    }

    private static enum State {
        NOT_CONNECTED,
        CONNECTED,
        TO_BE_CLOSED;

    }
}

