/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.errorparsers;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ErrorPattern {
    private final Pattern pattern;
    private final int groupFileName;
    private final int groupLineNum;
    private final int groupDesc;
    private final int groupVarName;
    private final int severity;
    private static boolean isCygwin = true;

    public ErrorPattern(String pattern, int groupFileName, int groupLineNum, int groupDesc, int groupVarName, int severity) {
        this.pattern = Pattern.compile(pattern);
        this.groupFileName = groupFileName;
        this.groupLineNum = groupLineNum;
        this.groupDesc = groupDesc;
        this.groupVarName = groupVarName;
        this.severity = severity;
    }

    public ErrorPattern(String pattern, int groupDesc, int severity) {
        this(pattern, 0, 0, groupDesc, 0, severity);
    }

    public ErrorPattern(String pattern) {
        this(pattern, 0, 0, 0, 0, -1);
    }

    public Matcher getMatcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    public String getFileName(Matcher matcher) {
        return this.groupFileName != 0 ? matcher.group(this.groupFileName) : null;
    }

    public int getLineNum(Matcher matcher) {
        try {
            return this.groupLineNum != 0 ? Integer.valueOf(matcher.group(this.groupLineNum)) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getDesc(Matcher matcher) {
        return this.groupDesc != 0 ? matcher.group(this.groupDesc) : null;
    }

    public String getVarName(Matcher matcher) {
        return this.groupVarName != 0 ? matcher.group(this.groupVarName) : null;
    }

    public int getSeverity(Matcher matcher) {
        return this.severity;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        Matcher matcher = this.getMatcher(line);
        if (!matcher.find()) {
            return false;
        }
        return this.recordError(matcher, eoParser);
    }

    protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
        int severity = this.getSeverity(matcher);
        if (severity == -1) {
            return true;
        }
        String fileName = this.getFileName(matcher);
        int lineNum = this.getLineNum(matcher);
        String desc = this.getDesc(matcher);
        String varName = this.getVarName(matcher);
        IPath externalPath = null;
        IFile file = null;
        if (fileName != null && (file = eoParser.findFileName(fileName)) == null) {
            file = eoParser.getProject();
            externalPath = this.getLocation(fileName);
        }
        eoParser.generateExternalMarker((IResource)file, lineNum, desc, severity, varName, externalPath);
        return true;
    }

    protected IPath getLocation(String filename) {
        Path path = new Path(filename);
        File file = path.toFile();
        if (!file.exists() && isCygwin && path.isAbsolute()) {
            CygPath cygpath = null;
            try {
                try {
                    cygpath = new CygPath("cygpath");
                    String cygfilename = cygpath.getFileName(filename);
                    Path convertedPath = new Path(cygfilename);
                    file = convertedPath.toFile();
                    if (file.exists()) {
                        path = convertedPath;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    isCygwin = false;
                    if (cygpath != null) {
                        cygpath.dispose();
                    }
                }
                catch (IOException iOException) {
                    if (cygpath != null) {
                        cygpath.dispose();
                    }
                }
            }
            finally {
                if (cygpath != null) {
                    cygpath.dispose();
                }
            }
        }
        return path;
    }
}

