/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.GetValue;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.core.runtime.CoreException;

public abstract class UnaryLogicalOperator
extends CompoundInstruction {
    public UnaryLogicalOperator(int start) {
        super(start);
    }

    public UnaryLogicalOperator(int resultId, boolean isAssignmentOperator, int start) {
        super(start);
    }

    @Override
    public void execute() throws CoreException {
        OperandValue operand = this.popValue();
        operand = this.convertForPromotion(operand);
        int resultType = this.getJavaBinaryPromotionType(operand, operand);
        IType type = this.fInterpreter.getTypeEngine().getBooleanType(1);
        switch (resultType) {
            case 11: {
                this.pushNewValue(type, this.getStringResult(GetValue.getStringValue(operand)));
                break;
            }
            case 8: {
                this.pushNewValue(type, this.getDoubleResult(GetValue.getDoubleValue(operand)));
                break;
            }
            case 9: {
                this.pushNewValue(type, this.getFloatResult(GetValue.getFloatValue(operand)));
                break;
            }
            case 7: {
                this.pushNewValue(type, this.getLongResult(GetValue.getLongValue(operand)));
                break;
            }
            case 10: {
                this.pushNewValue(type, this.getIntResult(GetValue.getIntValue(operand)));
                break;
            }
            case 5: {
                this.pushNewValue(type, this.getBooleanResult(GetValue.getBooleanValue(operand)));
                break;
            }
            case 13: {
                this.pushNewValue(type, this.getBigIntegerResult(GetValue.getBigIntegerValue(operand)));
                break;
            }
            default: {
                throw EDCDebugger.newCoreException(String.valueOf(ASTEvalMessages.UnhandledTypeCode) + resultType);
            }
        }
    }

    protected abstract boolean getIntResult(int var1) throws CoreException;

    protected abstract boolean getLongResult(long var1) throws CoreException;

    protected abstract boolean getBigIntegerResult(BigInteger var1) throws CoreException;

    protected abstract boolean getFloatResult(float var1);

    protected abstract boolean getDoubleResult(double var1);

    protected abstract boolean getBooleanResult(boolean var1);

    protected abstract boolean getStringResult(String var1) throws CoreException;
}

