/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.file;

import org.tizen.common.FactoryWithArgument;
import org.tizen.common.core.command.AbstractCommand;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.Assert;

public class FileHandlingCommand<T>
extends AbstractCommand<T> {
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected String path;

    public void setFilterFactory(FactoryWithArgument<Filter, String> factory) {
        this.filterFactory = factory;
        this.logger.debug("Configured filter factory :{}", factory);
    }

    public void setFilter(SimpleFileFilter filter) {
        Assert.notNull(filter);
        this.filter = filter;
        this.logger.debug("Configured filter :{}", (Object)filter);
    }

    public void setIncludes(String[] includes) {
        this.filter.clearIncludes();
        if (includes != null) {
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String include = stringArray[n2];
                this.filter.addIncludes(this.filterFactory.create(include));
                ++n2;
            }
        }
    }

    public void setExcludes(String[] excludes) {
        this.filter.clearExcludes();
        if (excludes != null) {
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                this.filter.addExcludes(this.filterFactory.create(exclude));
                ++n2;
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        throw new UnsupportedOperationException();
    }
}

