/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.launch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.ITizenPackageConfiguration;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.IOUtil;

public class TizenPackageInstaller {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<ITizenPackageConfiguration> configList = null;
    private String profileName;
    private IDevice device;
    private IProject project;

    public TizenPackageInstaller(IProject project, IDevice device, String profileName) {
        this.project = project;
        this.device = device;
        this.profileName = profileName;
    }

    private void initConfigList() {
        if (this.configList == null) {
            IConfigurationElement[] ces;
            this.configList = new ArrayList<ITizenPackageConfiguration>();
            IExtensionRegistry x = RegistryFactory.getRegistry();
            IConfigurationElement[] iConfigurationElementArray = ces = x.getConfigurationElementsFor("org.tizen.common.package.install");
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                String className;
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if ("configuration".equals(ce.getName()) && (className = ce.getAttribute("class")) != null) {
                    try {
                        Object obj = ce.createExecutableExtension("class");
                        if (obj instanceof ITizenPackageConfiguration) {
                            this.configList.add((ITizenPackageConfiguration)obj);
                        }
                    }
                    catch (CoreException e) {
                        this.logger.error("Failed to add " + ce + " to configList", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    public boolean installDeviceProfile() throws CoreException {
        boolean isRet = true;
        this.initConfigList();
        SyncService sync = null;
        try {
            sync = this.device.getSyncService();
        }
        catch (IOException e1) {
            this.logger.error("Failed to get a syncService: " + this.device, (Throwable)e1);
            return false;
        }
        try {
            for (ITizenPackageConfiguration config : this.configList) {
                File profileFile = config.getDeviceProfileFile(this.profileName, this.device, this.project);
                File destFile = config.getDeviceProfileDest(this.device, this.project);
                if (profileFile == null || destFile == null) continue;
                try {
                    SyncResult result = sync.push(profileFile.getCanonicalPath(), this.device.getFileEntry(destFile.toString()));
                    if (result.isOk()) continue;
                    this.logger.error("Failed to copy " + profileFile + " to " + destFile);
                }
                catch (IOException e) {
                    this.logger.error("Failed to copy " + profileFile, (Throwable)e);
                }
            }
        }
        finally {
            IOUtil.tryClose((Closeable)sync);
        }
        return isRet;
    }
}

