/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui.page.preference;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.page.preference.Messages;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.FileAppender;
import org.tizen.common.util.log.Level;

public class LoggingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private boolean applyOk = true;
    public static final String OPTION_ID_LEVEL = "org.tizen.common.logger.level";
    public static final String OPTION_ID_LOCATION = "org.tizen.common.logger.location2";
    public static final String OPTION_ID_CP = "org.tizen.common.logger.cp";
    private static final int DEFAULT_LEVEL = 1;
    private static final Level[] LEVELS = new Level[]{Level.OFF, Level.ERROR, Level.INFO, Level.DEBUG, Level.ALL};
    private Text loggerCP;
    private Text loggerLocText;
    private Scale levelScale;
    private Label levelDesLabel;
    private static final IPreferenceStore prefStore = CommonPlugin.getDefault() == null ? null : CommonPlugin.getDefault().getPreferenceStore();

    public LoggingPreferencePage() {
        this.setPreferenceStore(CommonPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.LOGGING_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        SWTUtil.createSpacer(composite, 1);
        this.createLoggerPreferences(composite);
    }

    private void createLoggerPreferences(Composite parent) {
        Group comp = SWTUtil.createGroup(parent, Messages.LOGGING_GROUP, 1);
        SWTUtil.setGridLayout((Composite)comp, 2, false, -1, -1, -1, -1, 768);
        this.createLoggerLocationButton((Composite)comp);
        this.createLoggerConversionPatterhn((Composite)comp);
        this.createLoggerLevelButtons((Composite)comp);
    }

    private void createLoggerConversionPatterhn(Composite parent) {
        Label loggerLocationLabel = new Label(parent, 0);
        loggerLocationLabel.setText(Messages.LOGGING_CP);
        this.loggerCP = new Text(parent, 2048);
        SWTUtil.setGridLayoutData((Control)this.loggerCP, -1, -1, -1, -1, 768);
        this.loggerCP.setText(LoggingPreferencePage.getLogConversionPattern());
    }

    private void createLoggerLocationButton(Composite parent) {
        Label loggerLocationLabel = new Label(parent, 0);
        loggerLocationLabel.setText(Messages.LOGGING_LOCATION);
        this.loggerLocText = new Text(parent, 2048);
        SWTUtil.setGridLayoutData((Control)this.loggerLocText, -1, -1, -1, -1, 768);
        this.loggerLocText.setText(LoggingPreferencePage.getLogLocation());
    }

    public static String getLogConversionPattern() {
        String loggerCP = prefStore.getString(OPTION_ID_CP);
        if (StringUtil.isEmpty(loggerCP)) {
            loggerCP = "[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n";
        }
        return loggerCP;
    }

    public static String getLogLocation() {
        String loggerPath = prefStore.getString(OPTION_ID_LOCATION);
        if (StringUtil.isEmpty(loggerPath)) {
            loggerPath = "%X{userdata_log}/ide-%d{yyyyMMdd}_%d{HHmmss}.log";
        }
        return loggerPath;
    }

    private void createLoggerLevelButtons(Composite parent) {
        String selectedLevel = prefStore.getString(OPTION_ID_LEVEL);
        if (StringUtil.isEmpty(selectedLevel)) {
            selectedLevel = LEVELS[1].toString();
        }
        this.levelScale = new Scale(parent, 256);
        SWTUtil.setGridLayoutData((Control)this.levelScale, -1, -1, 2, -1, 768);
        this.levelScale.setMinimum(0);
        this.levelScale.setMaximum(LEVELS.length - 1);
        this.levelScale.setIncrement(1);
        this.levelScale.setPageIncrement(1);
        boolean levelDefined = false;
        int i = 0;
        while (i < LEVELS.length) {
            Level level = LEVELS[i];
            if (level.toString().equals(selectedLevel)) {
                levelDefined = true;
                this.levelScale.setSelection(i);
                break;
            }
            ++i;
        }
        if (!levelDefined) {
            this.levelScale.setSelection(1);
        }
        this.levelDesLabel = new Label(parent, 0);
        SWTUtil.setGridLayoutData((Control)this.levelDesLabel, -1, -1, 2, -1, 768);
        this.levelDesLabel.setText(LEVELS[this.levelScale.getSelection()].toString());
        this.levelScale.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                int selectedLevel = LoggingPreferencePage.this.levelScale.getSelection();
                LoggingPreferencePage.this.levelScale.setSelection(selectedLevel);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.levelScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencePage.this.levelDesLabel.setText(LEVELS[LoggingPreferencePage.this.levelScale.getSelection()].toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void performDefaults() {
        this.levelScale.setSelection(1);
        this.levelDesLabel.setText(LEVELS[1].toString());
        this.loggerLocText.setText("%X{userdata_log}/ide-%d{yyyyMMdd}_%d{HHmmss}.log");
        this.loggerCP.setText("[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n");
        super.performDefaults();
    }

    protected void performApply() {
        Level loggerLevel = LEVELS[this.levelScale.getSelection()];
        String loggerLoc = this.loggerLocText.getText();
        MDC.put((String)"workspace", (Object)ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        MDC.put((String)"tizensdk", (Object)InstallPathConfig.getSDKPath());
        MDC.put((String)"userdata_log", (Object)InstallPathConfig.getIdeUserDataLogPath());
        Logger rootLogger = Logger.getRootLogger();
        FileAppender fileAppender = (FileAppender)rootLogger.getAppender("TIZEN_FILE_APPENDER");
        try {
            String result;
            if (fileAppender != null && !StringUtil.isEmpty(result = fileAppender.setFilePath(loggerLoc))) {
                this.setErrorMessage(result);
                this.applyOk = false;
                return;
            }
        }
        finally {
            MDC.remove((String)"tizensdk");
            MDC.remove((String)"workspace");
            MDC.remove((String)"userdata_log");
        }
        prefStore.setValue(OPTION_ID_LOCATION, this.loggerLocText.getText());
        prefStore.setValue(OPTION_ID_LEVEL, loggerLevel.toString());
        prefStore.setValue(OPTION_ID_CP, this.loggerCP.getText());
        this.setErrorMessage(null);
        this.applyOk = true;
    }

    public boolean performOk() {
        this.performApply();
        if (!this.applyOk) {
            return false;
        }
        return super.performOk();
    }

    public static Level getLoggerLevel() {
        return LoggingPreferencePage.getLoggerLevel(null);
    }

    public static Level getLoggerLevel(String levelString) {
        if (StringUtil.isEmpty(levelString)) {
            levelString = prefStore.getString(OPTION_ID_LEVEL);
        }
        if (!StringUtil.isEmpty(levelString)) {
            Level[] levelArray = LEVELS;
            int n = LEVELS.length;
            int n2 = 0;
            while (n2 < n) {
                Level level = levelArray[n2];
                if (level.toString().equals(levelString)) {
                    return level;
                }
                ++n2;
            }
        }
        return LEVELS[1];
    }
}

