/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.AbstractRenderer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BranchRenderer
extends AbstractRenderer {
    private static final int[] LINE_STYLE = new int[]{1, 1};
    public static final int H_FULL = 1;
    public static final int H_RIGHT = 2;
    public static final int H_CENTRE_TOGGLE = 4;
    public static final int H_LEFT_TOGGLE = 8;
    public static final int V_FULL = 16;
    public static final int V_TOP = 32;
    public static final int DESCENDER = 64;
    public static final int ASCENDER = 128;
    public static final int NONE = 0;
    public static final int T = 18;
    public static final int L = 34;
    public static final int I = 16;
    public static final int NODE = 64;
    public static final int LEAF = 8;
    public static final int ROOT = 192;
    public static final int LAST_ROOT = 128;
    public static final int SMALL_T = 20;
    public static final int SMALL_L = 36;
    private int indent;
    private int[] branches;
    private Rectangle toggleBounds;

    public Point computeSize(GC gc, int hint, int hint2, Object value) {
        return new Point(this.getBounds().width, this.getBounds().height);
    }

    public void paint(GC gc, Object value) {
        Rectangle bounds = this.getBounds();
        boolean isCarbon = SWT.getPlatform().equals("carbon");
        int xLeft = bounds.x;
        int yTop = bounds.y - 1;
        int yBottom = yTop + bounds.height;
        int yMiddle = this.toggleBounds.y + this.toggleBounds.height / 2;
        int yToggleBottom = this.toggleBounds.y + this.toggleBounds.height - 1;
        int yToggleTop = this.toggleBounds.y;
        int oldStyle = gc.getLineStyle();
        Color oldForeground = gc.getForeground();
        int[] oldLineDash = gc.getLineDash();
        gc.setForeground(this.getDisplay().getSystemColor(this.isSelected() ? 27 : 18));
        int dy = bounds.y % 2;
        if (!isCarbon) {
            gc.setLineDash(LINE_STYLE);
            --yToggleTop;
            ++yTop;
            ++yToggleBottom;
            if (bounds.height % 2 == 0) {
                --yBottom;
            } else {
                yTop += dy;
                yBottom -= dy;
            }
            yToggleBottom += dy;
            if ((yToggleTop - yTop + 1) % 2 == 0) {
                --yToggleTop;
            }
            if ((yToggleBottom - yBottom + 1) % 2 == 0) {
                yToggleBottom += dy == 1 ? -1 : 1;
            }
        }
        int i = 0;
        while (i < this.branches.length) {
            int xMiddle;
            int xRight = xLeft + this.indent;
            int xMiddleBranch = xMiddle = xLeft + this.toggleBounds.width / 2;
            int xToggleRight = xLeft + this.toggleBounds.width;
            int dx = 0;
            if (!isCarbon) {
                --xRight;
                xMiddleBranch += 2;
                --xToggleRight;
                if (this.indent % 2 == 0) {
                    --xRight;
                } else {
                    dx = xLeft % 2;
                    xLeft += dx;
                    xRight -= dx;
                }
            }
            if ((this.branches[i] & 1) == 1) {
                gc.drawLine(xLeft, yMiddle, xRight, yMiddle);
            }
            if ((this.branches[i] & 2) == 2) {
                gc.drawLine(xMiddleBranch, yMiddle, xRight, yMiddle);
            }
            if ((this.branches[i] & 4) == 4) {
                gc.drawLine(xMiddleBranch, yMiddle, xToggleRight, yMiddle);
            }
            if ((this.branches[i] & 8) == 8) {
                gc.drawLine(xLeft, yMiddle, xToggleRight, yMiddle);
            }
            if ((this.branches[i] & 0x10) == 16) {
                gc.drawLine(xMiddle, yTop, xMiddle, yBottom);
            }
            if ((this.branches[i] & 0x20) == 32) {
                gc.drawLine(xMiddle, yTop, xMiddle, yMiddle);
            }
            if ((this.branches[i] & 0x80) == 128) {
                gc.drawLine(xMiddle, yTop, xMiddle, yToggleTop);
            }
            if ((this.branches[i] & 0x40) == 64) {
                gc.drawLine(xMiddle, yToggleBottom, xMiddle, yBottom);
            }
            xLeft += this.indent - dx;
            ++i;
        }
        gc.setLineDash(oldLineDash);
        gc.setLineStyle(oldStyle);
        gc.setForeground(oldForeground);
    }

    public void setBranches(int[] branches) {
        this.branches = branches;
    }

    public void setIndent(int toggleIndent) {
        this.indent = toggleIndent;
    }

    public void setToggleBounds(Rectangle toggleBounds) {
        this.toggleBounds = toggleBounds;
    }
}

