/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GridToolTip
extends Widget {
    private Shell shell;
    private String text;
    private int ymargin = 2;
    private int xmargin = 3;

    public GridToolTip(Control parent) {
        super((Widget)parent, 0);
        this.shell = new Shell(parent.getShell(), 540684);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(29));
        this.shell.setForeground(this.shell.getDisplay().getSystemColor(28));
        parent.addListener(12, new Listener(){

            public void handleEvent(Event arg0) {
                GridToolTip.this.shell.dispose();
                GridToolTip.this.dispose();
            }
        });
        this.shell.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                GridToolTip.this.onPaint(e.gc);
            }
        });
    }

    private void onPaint(GC gc) {
        gc.drawRectangle(0, 0, this.shell.getSize().x - 1, this.shell.getSize().y - 1);
        gc.drawString(this.text, this.xmargin, this.ymargin, true);
    }

    public void setLocation(Point location) {
        this.shell.setLocation(location.x - this.xmargin, location.y - this.ymargin);
    }

    public void setVisible(boolean visible) {
        if (visible && this.shell.getVisible()) {
            this.shell.redraw();
        } else {
            this.shell.setVisible(visible);
        }
    }

    public void setFont(Font font) {
        this.shell.setFont(font);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        GC gc = new GC((Drawable)this.shell);
        Point size = gc.stringExtent(text);
        gc.dispose();
        size.x += this.xmargin + this.xmargin;
        size.y += this.ymargin + this.ymargin;
        this.shell.setSize(size);
    }

    protected void checkSubclass() {
    }
}

