/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class LogData
extends ProtocolParser
implements Cloneable {
    public static final LogData END_OF_QUEUE = new LogData();
    protected Protocol protocolVersion = Protocol.VERSION_UNKNOWN;
    protected int msgID = -1;
    protected long seq = -1L;
    protected int sec = 0;
    protected int nano = 0;
    protected long time = 0L;
    private int payloadSize = 0;

    public LogData clone() throws CloneNotSupportedException {
        LogData log = (LogData)super.clone();
        log.msgID = this.msgID;
        log.seq = this.seq;
        log.sec = this.sec;
        log.nano = this.nano;
        log.time = this.time;
        return log;
    }

    public final void init(byte[] header) {
        this.msgID = ByteUtil.toInt((byte[])header, (int)0);
        this.seq = ByteUtil.toUIntByLong((byte[])header, (int)4);
        this.sec = ByteUtil.toInt((byte[])header, (int)8);
        this.nano = ByteUtil.toInt((byte[])header, (int)12);
        this.payloadSize = ByteUtil.toInt((byte[])header, (int)16);
        if (this.payloadSize > 0) {
            this.body = new byte[this.payloadSize];
        }
    }

    private void adjustTime(DATime startTime) {
        long resultSec = this.sec - startTime.getSec();
        long resultNano = this.nano - startTime.getNano();
        this.time = resultSec * 1000000L + resultNano / 1000L;
        if (this.time < 0L) {
            Logger.warning((Object)("id : " + AnalyzerUtil.toHexdecimal(this.msgID) + " time : " + this.time));
            Logger.warning((Object)("profile start time : " + startTime.toString() + "  time : " + this.sec + "," + this.nano));
        }
    }

    protected boolean parse(DATime startTime) {
        if (DebugLog.isEnabled()) {
            DebugLog.printData0("%s seq(%d) sec(%d) nano(%d) size(%d)\n", Protocol.getDataMessageName(this.getMsgID()), this.getSeq(), this.getSec(), this.getNano(), this.getPayloadSize());
        }
        return true;
    }

    public final boolean parsePublic(DATime startTime) {
        this.adjustTime(startTime);
        boolean result = this.parse(startTime);
        this.body = null;
        return result;
    }

    public int getKey() {
        return (int)(this.seq ^ this.seq >>> 32);
    }

    public void setProtocolVersion(Protocol version) {
        this.protocolVersion = version;
    }

    public final int getMsgID() {
        return this.msgID;
    }

    public final void setMsgID(int id) {
        this.msgID = id;
    }

    public final long getSeq() {
        return this.seq;
    }

    public final void setSeq(long seq) {
        this.seq = seq;
    }

    public final void adjustSeq(int seqRot) {
        this.seq = (long)seqRot << 32 | this.seq;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long time) {
        this.time = time;
    }

    public int getPid() {
        return 0;
    }

    public int getSec() {
        return this.sec;
    }

    public int getNano() {
        return this.nano;
    }

    public final int getPayloadSize() {
        return this.payloadSize;
    }

    public final byte[] getPayload() {
        return this.body;
    }
}

