/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UIHierarchyPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialog;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class HierarchyTreeExporter {
    private static String latestExportDir = null;
    private static ProgressHolder progress;

    public static void exportTreeImage(IFigure treeView) {
        if (treeView.getChildren().isEmpty()) {
            Logger.info((Object)"Tree view is empty.");
            return;
        }
        FileDialog fd = new FileDialog(WorkbenchUtil.getWorkbenchWindow().getShell(), 8192);
        fd.setText(UIHierarchyPageLabels.UIHIERARCHY_EXPORT_DIALOG_TITLE);
        if (latestExportDir == null) {
            fd.setFilterPath(Global.getProject().getSavePath());
        } else {
            fd.setFilterPath(latestExportDir);
        }
        String[] filterExt = new String[]{"*.png"};
        fd.setFilterExtensions(filterExt);
        String appName = Global.getProject().getAppID();
        fd.setFileName(appName);
        String exportPath = fd.open();
        if (exportPath == null) {
            return;
        }
        new ExportImageThread(treeView, fd.getFilterPath(), exportPath).start();
    }

    private static Image makeImageFile(IFigure treeView) {
        Rectangle rect = treeView.getBounds();
        Image image = new Image((Device)Display.getDefault(), rect.width, rect.height);
        ScaledGraphics gc = new ScaledGraphics((Graphics)new SWTGraphics(new GC((Drawable)image, 0)));
        gc.translate(rect.getLocation().negate());
        gc.setBackgroundColor(ColorResources.TREEVIEW_BG);
        gc.setFont(treeView.getFont());
        gc.fillRectangle(rect.getCopy());
        treeView.paint((Graphics)gc);
        gc.dispose();
        return image;
    }

    private static void showErrorDialog() {
        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
        DADialog dialog = new DADialog(shell, DADialog.DIALOGTYPE.ERROR, 0);
        dialog.setTitleText(UIHierarchyPageLabels.UIHIERARCHY_EXPORT_DIALOG_TITLE);
        dialog.setMessage(UIHierarchyPageLabels.UIHIERARCHY_EXPORT_DIALOG_ERROR_MESSAGE);
        dialog.setIcon(ImageResources.DIALOG_ERROR_ICON);
        dialog.setDialog();
        dialog.open();
    }

    private static class ExportImageThread
    extends Thread {
        private String currentExportDir;
        private IFigure treeView;
        private String exportPath;

        private ExportImageThread(IFigure treeView, String currentExportDir, String exportPath) {
            super(ExportImageThread.class.getSimpleName());
            this.treeView = treeView;
            this.currentExportDir = currentExportDir;
            this.exportPath = exportPath;
        }

        @Override
        public void run() {
            boolean result;
            block16: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        progress = ProgressManager.INSTANCE.createProgress(false, 0, UIHierarchyPageLabels.UIHIERARCHY_EXPORT_PROGRESS_MESSAGE, AnalyzerLabels.DLG_PLEASE_WAIT, null);
                    }
                });
                Image image = HierarchyTreeExporter.makeImageFile(this.treeView);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        progress.setValue(30);
                        progress.setValue(70);
                    }
                });
                result = true;
                FileOutputStream os = null;
                try {
                    try {
                        os = new FileOutputStream(this.exportPath);
                        ImageLoader loader = new ImageLoader();
                        loader.data = new ImageData[]{image.getImageData()};
                        loader.save((OutputStream)os, 5);
                        latestExportDir = this.currentExportDir;
                    }
                    catch (FileNotFoundException e) {
                        Logger.error((Object)e);
                        result = false;
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e2) {
                            result = false;
                            Logger.exception((Throwable)e2);
                        }
                        image.dispose();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        result = false;
                        Logger.exception((Throwable)e);
                    }
                    image.dispose();
                    throw throwable;
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    result = false;
                    Logger.exception((Throwable)e);
                }
                image.dispose();
            }
            if (result) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        progress.setValue(100);
                        ProgressManager.INSTANCE.stopProgress(progress);
                    }
                });
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressManager.INSTANCE.stopProgress(progress);
                        HierarchyTreeExporter.showErrorDialog();
                    }
                });
            }
        }
    }
}

