/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data.util;

import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemFreeDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemLSanTable;
import org.tizen.dynamicanalyzer.ui.memory.data.util.Query;
import org.tizen.dynamicanalyzer.ui.memory.data.util.QuerySerializer;

public class PersistentAllocationsQuerySerializer
implements QuerySerializer {
    private static String getIntervalJoinQuery(Query q, String columns) {
        StringBuilder queryFormat = new StringBuilder();
        queryFormat.append(String.format("SELECT %s FROM ", columns));
        queryFormat.append(String.format("(SELECT * FROM %s ", "MEM_ALLOC_DB"));
        queryFormat.append(String.format(" WHERE %s BETWEEN %s AND %s) as allocT ", MemAllocDBTable.COLUMN.ALLOCATED_TIME.name, q.startTime, q.endTime));
        queryFormat.append("LEFT JOIN ");
        queryFormat.append(String.format("(SELECT * FROM %s ", "MEM_FREE_DB"));
        queryFormat.append(String.format(" WHERE %s BETWEEN %s AND %s) as freeT ", MemFreeDBTable.COLUMN.FREE_TIME.name, q.startTime, q.endTime));
        return queryFormat.toString();
    }

    private static String getFullJoinQuery(String columns) {
        return String.format("SELECT %s FROM %s allocT LEFT JOIN %s freeT ", columns, "MEM_ALLOC_DB", "MEM_FREE_DB");
    }

    @Override
    public String toSqlString(Query q) {
        String basicColumns = String.join((CharSequence)", ", MemAllocDBTable.getBasicColumns());
        StringBuilder queryFormat = new StringBuilder();
        if (q.startTime != 0L || q.endTime != 0L) {
            queryFormat.append(PersistentAllocationsQuerySerializer.getIntervalJoinQuery(q, basicColumns));
        } else {
            queryFormat.append(PersistentAllocationsQuerySerializer.getFullJoinQuery(basicColumns));
        }
        queryFormat.append(String.format("ON allocT.%s = freeT.%s AND allocT.%s <= freeT.%s AND allocT.%s = freeT.%s ", MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.name, MemFreeDBTable.COLUMN.ALLOCATED_ADDRESS.name, MemAllocDBTable.COLUMN.ALLOCATED_TIME.name, MemFreeDBTable.COLUMN.FREE_TIME.name, MemAllocDBTable.COLUMN.PID.name, MemFreeDBTable.COLUMN.PID.name));
        if (q.onlyLeaks) {
            queryFormat.append(String.format("INNER JOIN %s lsanT ON allocT.%s = lsanT.%s ", "MEM_LSAN_DB", MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.name, MemLSanTable.COLUMN.ALLOCATED_ADDRESS.name));
        }
        queryFormat.append(String.format("WHERE freeT.%s IS NULL ", MemFreeDBTable.COLUMN.FREE_TIME.name));
        queryFormat.append(String.format("AND allocT.%s IN %s ", MemAllocDBTable.COLUMN.PID.name, q.pidString));
        return queryFormat.toString();
    }
}

