/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionEntryDBTable
extends DBTable {
    public static final String TABLENAME = "FUNCTION_ENTRY";
    public static final int FUNCTION_RETURN_VALUE_LENGTH = 1024;
    private static final String SELECT_ENTRY_COLUMN = String.valueOf(COLUMN.SEQUENCE_NUMBER.name) + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.FUNCTION_ID.name + "," + COLUMN.BINARY_ID.name + "," + COLUMN.START_TIME.name + "," + COLUMN.CALLER_PC_ADDRESS.name + "," + COLUMN.START_PC_ADDRESS.name;
    private static final String SELECT_EXIT_COLUMN = String.valueOf(COLUMN.SEQUENCE_NUMBER.name) + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.END_TIME.name + "," + COLUMN.CALLER_PC_ADDRESS.name + "," + COLUMN.START_PC_ADDRESS.name;
    public static final String SELECT_ENTRY_QUERY = " select " + SELECT_ENTRY_COLUMN + " from " + "FUNCTION_ENTRY" + " where " + COLUMN.IS_ENTRY.name + " and " + COLUMN.START_TIME.name + " between %s and %s";
    public static final String SELECT_EXIT_QUERY = " select " + SELECT_EXIT_COLUMN + " from " + "FUNCTION_ENTRY" + "  where not " + COLUMN.IS_ENTRY.name + " and " + COLUMN.END_TIME.name + " between %s and %s";
    public static final String USERCALLSTACK_QUERY = " select " + COLUMN.SEQUENCE_NUMBER.name + " from " + "FUNCTION_ENTRY" + " where " + COLUMN.START_TIME.name + " = (select max( " + COLUMN.START_TIME.name + ") from " + "FUNCTION_ENTRY" + " where " + COLUMN.START_TIME.name + " <= %s )";
    public static final String FIND_ENTRY_TIME_QUERY = "select MAX(" + COLUMN.START_TIME.name + ") from " + "FUNCTION_ENTRY" + " where " + COLUMN.FUNCTION_ID.name + " = %s and " + COLUMN.SEQUENCE_NUMBER.name + " < %s";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FunctionEntryDBTable() {
        this.addColumn(new DBColumn(COLUMN.IS_ENTRY.name, "NOT NULL", "BOOLEAN"));
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_ID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.BINARY_ID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_PC_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.START_PC_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ARGUMENT.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.RETURN_VALUE.name, "", "VARCHAR", 1024));
        this.addIndex(COLUMN.START_TIME.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setBoolean(COLUMN.IS_ENTRY.index + 1, (Boolean)rowData.get(COLUMN.IS_ENTRY.index));
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setInt(COLUMN.FUNCTION_ID.index + 1, (Integer)rowData.get(COLUMN.FUNCTION_ID.index));
                prep.setInt(COLUMN.BINARY_ID.index + 1, (Integer)rowData.get(COLUMN.BINARY_ID.index));
                prep.setLong(COLUMN.START_TIME.index + 1, (Long)rowData.get(COLUMN.START_TIME.index));
                prep.setLong(COLUMN.END_TIME.index + 1, (Long)rowData.get(COLUMN.END_TIME.index));
                prep.setLong(COLUMN.CALLER_PC_ADDRESS.index + 1, (Long)rowData.get(COLUMN.CALLER_PC_ADDRESS.index));
                prep.setLong(COLUMN.START_PC_ADDRESS.index + 1, (Long)rowData.get(COLUMN.START_PC_ADDRESS.index));
                String argumentStr = this.clipString((String)rowData.get(COLUMN.ARGUMENT.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.ARGUMENT.index + 1, argumentStr);
                String retStr = this.clipString((String)rowData.get(COLUMN.RETURN_VALUE.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.RETURN_VALUE.index + 1, retStr);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getBoolean(1));
            row.add(rs.getLong(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getInt(5));
            row.add(rs.getInt(6));
            row.add(rs.getLong(7));
            row.add(rs.getLong(8));
            row.add(rs.getLong(9));
            row.add(rs.getLong(10));
            row.add(rs.getString(11));
            row.add(rs.getString(12));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        IS_ENTRY(0, "IS_ENTRY"),
        SEQUENCE_NUMBER(1, "SEQUENCE_NUMBER"),
        PID(2, "PID"),
        TID(3, "TID"),
        FUNCTION_ID(4, "FUNCTION_ID"),
        BINARY_ID(5, "BINARY_ID"),
        START_TIME(6, "START_TIME"),
        END_TIME(7, "END_TIME"),
        CALLER_PC_ADDRESS(8, "CALLER_PC_ADDRESS"),
        START_PC_ADDRESS(9, "START_PC_ADDRESS"),
        ARGUMENT(10, "ARGUMENT"),
        RETURN_VALUE(11, "RETURN_VALUE");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

