/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.framework.Bundle;

public class WelcomeItem {
    private String text;
    private int[][] boldRanges;
    private int[][] helpRanges;
    private String[] helpIds;
    private String[] helpHrefs;
    private int[][] actionRanges;
    private String[] actionPluginIds;
    private String[] actionClasses;

    public WelcomeItem(String text, int[][] boldRanges, int[][] actionRanges, String[] actionPluginIds, String[] actionClasses, int[][] helpRanges, String[] helpIds, String[] helpHrefs) {
        this.text = text;
        this.boldRanges = boldRanges;
        this.actionRanges = actionRanges;
        this.actionPluginIds = actionPluginIds;
        this.actionClasses = actionClasses;
        this.helpRanges = helpRanges;
        this.helpIds = helpIds;
        this.helpHrefs = helpHrefs;
    }

    public int[][] getActionRanges() {
        return this.actionRanges;
    }

    public int[][] getBoldRanges() {
        return this.boldRanges;
    }

    public int[][] getHelpRanges() {
        return this.helpRanges;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLinkAt(int offset) {
        int[][] nArray = this.helpRanges;
        int n = this.helpRanges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] helpRange = nArray[n2];
            if (offset >= helpRange[0] && offset < helpRange[0] + helpRange[1]) {
                return true;
            }
            ++n2;
        }
        nArray = this.actionRanges;
        n = this.actionRanges.length;
        n2 = 0;
        while (n2 < n) {
            int[] actionRange = nArray[n2];
            if (offset >= actionRange[0] && offset < actionRange[0] + actionRange[1]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void logActionLinkError(String actionPluginId, String actionClass) {
        IDEWorkbenchPlugin.log(String.valueOf(IDEWorkbenchMessages.WelcomeItem_unableToLoadClass) + actionPluginId + " " + actionClass);
    }

    private void openHelpTopic(String topic, String href) {
        if (href != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(topic);
        }
    }

    private void runAction(String pluginId, String className) {
        IAction action;
        Class actionClass;
        Bundle pluginBundle = Platform.getBundle((String)pluginId);
        if (pluginBundle == null) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        try {
            actionClass = pluginBundle.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        try {
            action = (IAction)actionClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        catch (ClassCastException classCastException) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        action.run();
    }

    public void triggerLinkAt(int offset) {
        int i = 0;
        while (i < this.helpRanges.length) {
            if (offset >= this.helpRanges[i][0] && offset < this.helpRanges[i][0] + this.helpRanges[i][1]) {
                this.openHelpTopic(this.helpIds[i], this.helpHrefs[i]);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.actionRanges.length) {
            if (offset >= this.actionRanges[i][0] && offset < this.actionRanges[i][0] + this.actionRanges[i][1]) {
                this.runAction(this.actionPluginIds[i], this.actionClasses[i]);
                return;
            }
            ++i;
        }
    }
}

