/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.properties;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.UIHierarchyPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyViewCommunication;
import org.tizen.dynamicanalyzer.ui.hierarchy.properties.HierarchyPropertiesTable;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class HierarchyPropertiesView
extends DAViewComposite {
    public static final String ID = HierarchyPropertiesView.class.getName();
    private HierarchyPropertiesTable propertiesTable = null;
    protected String[] columnNames = new String[]{UIHierarchyPageLabels.UIHIERARCHY_PROPERTIES_TABLE_PROPERTY, UIHierarchyPageLabels.UIHIERARCHY_PROPERTIES_TABLE_VALUE};
    protected int[] columnSizes = new int[]{110, 110};
    private int[] columnAlignment = new int[]{16384, 16384};
    protected boolean[] columnVisibility = new boolean[]{true, true};

    public HierarchyPropertiesView(Composite parent, int style) {
        super(parent, style, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(UIHierarchyPageLabels.UIHIERARCHY_PROPERTIES_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.propertiesTable = new HierarchyPropertiesTable(contents, 0, 2816);
        this.propertiesTable.setTree(true);
        this.propertiesTable.setColumnAlignment(this.columnAlignment);
        this.propertiesTable.setColumns(this.columnNames);
        this.propertiesTable.setColumnSize(this.columnSizes);
        this.propertiesTable.setColumnVisibility(this.columnVisibility);
        this.propertiesTable.setTableToolTipEnable(false);
        this.propertiesTable.setTableName(UIHierarchyPageLabels.UIHIERARCHY_PROPERTIES_VIEW_TITLE);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData && data.getData() instanceof HierarchyViewCommunication) {
            HierarchyViewCommunication param = (HierarchyViewCommunication)data.getData();
            switch (param.getAction()) {
                case NODE_SELECT: 
                case NODE_UNSELECT: 
                case TREE_RESTRUCT: {
                    this.propertiesTable.setUIObject(param.getUIObj());
                    this.propertiesTable.updateTable();
                    break;
                }
            }
        }
    }

    public void clear() {
        this.propertiesTable.clear();
    }
}

