/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileNativesManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;
import org.tizen.common.Surrogate;
import org.tizen.common.core.application.Messages;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.ViewUtil;

public class EFSUtil {
    public static final int OWNER_READ_FLAG = 256;
    public static final int OWNER_WRITE_FLAG = 128;
    public static final int OWNER_EXECUTE_FLAG = 64;
    public static final int GROUP_READ_FLAG = 32;
    public static final int GROUP_WRITE_FLAG = 16;
    public static final int GROUP_EXECUTE_FLAG = 8;
    public static final int OTHERS_READ_FLAG = 4;
    public static final int OTHERS_WRITE_FLAG = 2;
    public static final int OTHERS_EXECUTE_FLAG = 1;
    private static Surrogate<IFileSystem> fileSystemSurrogate = new Surrogate<IFileSystem>(){

        @Override
        public IFileSystem getAdapter() {
            return EFS.getLocalFileSystem();
        }
    };
    private static final String defaultTask = "";
    private static final int defaultTicks = 100;
    private static final IFileStoreFilter defaultFilter = new IFileStoreFilter(){

        public boolean accept(IFileStore store) {
            return true;
        }
    };

    private EFSUtil() {
    }

    public static void setFileSystemSurrogate(Surrogate<IFileSystem> surrogate) {
        fileSystemSurrogate = surrogate;
    }

    protected static IFileSystem getFileSystem() {
        return fileSystemSurrogate.getAdapter();
    }

    public static int getPermissions(String path) {
        FileInfo info = LocalFileNativesManager.fetchFileInfo((String)path);
        int permissions = 0;
        if (info.exists()) {
            permissions |= info.getAttribute(0x400000) ? 256 : 0;
            permissions |= info.getAttribute(0x800000) ? 128 : 0;
            permissions |= info.getAttribute(0x1000000) ? 64 : 0;
            permissions |= info.getAttribute(0x2000000) ? 32 : 0;
            permissions |= info.getAttribute(0x4000000) ? 16 : 0;
            permissions |= info.getAttribute(0x8000000) ? 8 : 0;
            permissions |= info.getAttribute(0x10000000) ? 4 : 0;
            permissions |= info.getAttribute(0x20000000) ? 2 : 0;
            permissions |= info.getAttribute(0x40000000) ? 1 : 0;
        }
        return permissions;
    }

    public static IFileStoreFilter getDefaultFileStoreFilter() {
        return defaultFilter;
    }

    public static boolean isExistResource(URI fileURI) {
        IFileStore fileStore = EFSUtil.getFileSystem().getStore(fileURI);
        return EFSUtil.isExistResource(fileStore);
    }

    public static boolean isExistResource(IFileStore fileStore) {
        return fileStore != null ? fileStore.fetchInfo().exists() : false;
    }

    public static DialogChoicer isExistResourceWithDialog(Shell parentShell, String title, String msg, DialogChoicer previousChoice, IFileStore fileStore) {
        Assert.notNull(parentShell);
        Assert.notNull(msg);
        Assert.notNull((Object)previousChoice);
        Assert.notNull(fileStore);
        switch (previousChoice) {
            case Yes: 
            case No: {
                break;
            }
            default: {
                return previousChoice;
            }
        }
        if (EFSUtil.isExistResource(fileStore)) {
            MessageDialog msgDialog = new MessageDialog(parentShell, title, null, msg, 0, DialogChoicer.toStringArray(), DialogChoicer.Cancel.ordinal());
            int msgResult = msgDialog.open();
            return DialogChoicer.valueFromOrdinal(msgResult);
        }
        return DialogChoicer.Yes;
    }

    public static void copy(URI source, URI destination, int options, IProgressMonitor monitor) throws CoreException {
        Assert.notNull(source);
        Assert.notNull(destination);
        monitor = ObjectUtil.nvl(monitor, new NullProgressMonitor());
        try {
            monitor.beginTask(defaultTask, 100);
            EFSUtil.getFileSystem().getStore(source).copy(EFSUtil.getFileSystem().getStore(destination), options, monitor);
        }
        finally {
            monitor.done();
        }
    }

    public static DialogChoicer copyWithFilter(URI source, URI destination, IFileStoreFilter fileFilter, IProgressMonitor monitor) throws CoreException {
        return EFSUtil.copyWithFilter(source, destination, fileFilter, DialogChoicer.Yes, monitor);
    }

    public static DialogChoicer copyWithFilter(URI source, URI destination, IFileStoreFilter fileFilter, DialogChoicer previousChoice, IProgressMonitor monitor) throws CoreException {
        Assert.notNull(source);
        Assert.notNull(destination);
        monitor = ObjectUtil.nvl(monitor, new NullProgressMonitor());
        try {
            monitor.beginTask(defaultTask, 100);
            if (fileFilter == null) {
                fileFilter = EFSUtil.getDefaultFileStoreFilter();
            }
            DialogChoicer dialogChoicer = EFSUtil.internalCopyWithFilter(EFSUtil.getFileSystem().getStore(source), EFSUtil.getFileSystem().getStore(destination), fileFilter, previousChoice, monitor);
            return dialogChoicer;
        }
        finally {
            monitor.done();
        }
    }

    private static DialogChoicer internalCopyWithFilter(IFileStore source, IFileStore destination, IFileStoreFilter fileFilter, DialogChoicer previousChoice, IProgressMonitor monitor) throws CoreException {
        Assert.notNull(source);
        Assert.notNull(destination);
        IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
        if (window == null) {
            throw new OperationCanceledException("Could not find a window");
        }
        previousChoice = EFSUtil.isExistResourceWithDialog(window.getShell(), Messages.FileExistDialogTitle, Messages.bind((String)Messages.FileExistMsg, (Object)destination.getName()), previousChoice, destination);
        switch (previousChoice) {
            case YesToAll: 
            case Yes: {
                source.copy(destination, 6, monitor);
                break;
            }
            case Cancel: {
                throw new OperationCanceledException();
            }
            case NoToAll: 
            case No: {
                break;
            }
        }
        monitor.worked(1);
        if (source.fetchInfo().isDirectory()) {
            IFileStore[] childStores;
            IFileStore[] iFileStoreArray = childStores = IDEResourceInfoUtils.listFileStores((IFileStore)source, (IFileStoreFilter)fileFilter, null);
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore childStore = iFileStoreArray[n2];
                previousChoice = EFSUtil.internalCopyWithFilter(childStore, destination.getChild(childStore.getName()), fileFilter, previousChoice, monitor);
                ++n2;
            }
        }
        return previousChoice;
    }

    public static enum DialogChoicer {
        YesToAll,
        NoToAll,
        Yes,
        No,
        Cancel;


        public static String[] toStringArray() {
            DialogChoicer[] choicers = DialogChoicer.values();
            String[] values = new String[choicers.length];
            DialogChoicer[] dialogChoicerArray = choicers;
            int n = choicers.length;
            int n2 = 0;
            while (n2 < n) {
                DialogChoicer choicer = dialogChoicerArray[n2];
                values[choicer.ordinal()] = choicer.name();
                ++n2;
            }
            return values;
        }

        public static DialogChoicer valueFromOrdinal(int ordinal) {
            DialogChoicer[] dialogChoicerArray = DialogChoicer.values();
            int n = dialogChoicerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DialogChoicer choicer = dialogChoicerArray[n2];
                if (choicer.ordinal() == ordinal) {
                    return choicer;
                }
                ++n2;
            }
            return Cancel;
        }
    }
}

