/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class WebAppStartupDBTable
extends DBTable {
    public static final String TABLE_NAME = "WEB_APP_STARTUP";
    private static final String SELECT_QUERY = " where pid = %s";

    public WebAppStartupDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.STAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.RESOURCE_ID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.RESOURCE_PATH.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.TIME.name, "NOT NULL", "BIGINT"));
        this.addIndex(COLUMN.TIME.index);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.STAGE_ID.index + 1, (Integer)rowData.get(COLUMN.STAGE_ID.index));
                prep.setInt(COLUMN.RESOURCE_ID.index + 1, (Integer)rowData.get(COLUMN.RESOURCE_ID.index));
                String resourceStr = this.clipString((String)rowData.get(COLUMN.RESOURCE_PATH.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.RESOURCE_PATH.index + 1, resourceStr);
                prep.setLong(COLUMN.TIME.index + 1, (Long)rowData.get(COLUMN.TIME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getString(5));
            row.add(rs.getLong(6));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public List<List<Object>> getWebAppStartupFromDB() {
        return this.selectAllColumnData(null);
    }

    public List<List<Object>> getObjectDataFromDB(int selectedPid) {
        ArrayList<String> selectColumn = new ArrayList<String>();
        selectColumn.add(COLUMN.SEQUENCE_NUMBER.name);
        selectColumn.add(COLUMN.PID.name);
        selectColumn.add(COLUMN.STAGE_ID.name);
        selectColumn.add(COLUMN.RESOURCE_ID.name);
        selectColumn.add(COLUMN.RESOURCE_PATH.name);
        selectColumn.add(COLUMN.TIME.name);
        String where = null;
        if (selectedPid != 0) {
            where = String.format(SELECT_QUERY, selectedPid);
        }
        return this.selectData(selectColumn, where, this);
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        STAGE_ID(2, "STAGE_ID"),
        RESOURCE_ID(3, "RESOURCE_ID"),
        RESOURCE_PATH(4, "RESOURCE_PATH"),
        TIME(5, "TIME");

        private final int index;
        private final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum STAGE {
        LOADING(1, "loading"),
        PROCESSING(3, "processing"),
        DRAWING(5, "drawing");

        private final int id;
        private final String name;

        private STAGE(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static String getName(int id) {
            if (LOADING.getID() == id) {
                return LOADING.getName();
            }
            if (PROCESSING.getID() == id) {
                return PROCESSING.getName();
            }
            if (DRAWING.getID() == id) {
                return DRAWING.getName();
            }
            return "";
        }
    }
}

