/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class ImageViewer
extends Composite {
    private final int MOUSE_EXIT = 0;
    private final int MOUSE_HOVER = 1;
    private final int MOUSE_LEFT = 2;
    private final int MOUSE_RIGHT = 3;
    private final int MOUSE_DOWN_LEFT = 4;
    private final int MOUSE_DOWN_RIGHT = 5;
    private Image image;
    private Canvas canvas;
    private Canvas popup;
    private Shell childShell;
    private Shell imageShell;
    private Composite parent;
    int childShellWidth = 0;
    int childShellHeight = 0;
    private int state = 0;
    private int imageState = 0;
    private boolean mouseDown = false;
    private ImageInfo currentImageInfo = null;
    private boolean leftEnable = false;
    private boolean rightEnable = false;
    private static final int defaultShellMaxWidth = 242;
    private static final int defaultShellMaxHeight = 402;
    private static final int defaultChildWidth = 69;
    private static final int defaultChildHeight = 108;
    private int shellMaxWidth = 0;
    private int shellMaxHeight = 0;
    private int childWidth = 0;
    private int childHeight = 0;
    private Timer timer = null;
    private boolean popupOpened;
    private Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6) {
                Cursor startCursor = new Cursor((Device)ImageViewer.this.imageShell.getDisplay(), 21);
                ImageViewer.this.imageShell.setCursor(startCursor);
            } else if (event.type == 7) {
                Cursor arrowCursor = new Cursor((Device)ImageViewer.this.imageShell.getDisplay(), 0);
                ImageViewer.this.imageShell.setCursor(arrowCursor);
                if (ImageViewer.this.childShell != null) {
                    ImageViewer.this.popupOpened = false;
                    if (ImageViewer.this.timer != null) {
                        ImageViewer.this.timer.cancel();
                        ImageViewer.this.timer = null;
                    }
                    ImageViewer.this.childShell.close();
                    ImageViewer.this.childShell = null;
                }
                ImageViewer.this.state = 0;
                ImageViewer.this.canvas.redraw();
            } else if (event.type == 3) {
                if (!ImageViewer.this.popupOpened) {
                    ImageViewer.this.popupOpened = true;
                    if (ImageViewer.this.childShell == null) {
                        ImageViewer.this.openChildShell(true);
                    }
                } else {
                    ImageViewer.this.popupOpened = false;
                    if (ImageViewer.this.childShell != null) {
                        if (ImageViewer.this.timer != null) {
                            ImageViewer.this.timer.cancel();
                            ImageViewer.this.timer = null;
                        }
                        ImageViewer.this.childShell.close();
                        ImageViewer.this.childShell = null;
                    }
                    ImageViewer.this.canvas.redraw();
                }
            }
        }
    };

    public ImageViewer(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas((Composite)this, 0);
        this.imageShell = parent.getShell();
        this.setImage(ImageResources.NO_IMAGE);
        this.popupOpened = false;
        this.canvas.addListener(6, this.mouseListener);
        this.canvas.addListener(7, this.mouseListener);
        this.canvas.addListener(3, this.mouseListener);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageViewer.this.image == null || e.gc == null) {
                    return;
                }
                Canvas canvas = (Canvas)e.widget;
                Rectangle rect = canvas.getBounds();
                e.gc.setBackground(ColorResources.SNAPSHOT_VIEWER_BG_COLOR);
                e.gc.fillRectangle(rect);
                try {
                    Rectangle bounds = ImageViewer.this.image.getBounds();
                    int iw = bounds.width;
                    int ih = bounds.height;
                    int imageType = iw > ih ? 1 : 0;
                    ImageData imageData = new ImageData(imageType);
                    imageData.gc = e.gc;
                    imageData.imgWidth = iw;
                    imageData.imgHeight = ih;
                    ImageViewer.this.drawThumbnail(imageData);
                    imageData.gc.dispose();
                }
                catch (SWTException se) {
                    Logger.exception((Throwable)se);
                }
            }
        });
    }

    public void setEnable(boolean enabled) {
        this.canvas.setEnabled(enabled);
    }

    private void setImage(Image input) {
        if (input == null) {
            this.image = null;
            return;
        }
        if (this.image != null && !this.image.isDisposed() && !this.image.equals((Object)ImageResources.NO_IMAGE)) {
            this.image.dispose();
        }
        this.image = input;
    }

    public void clear() {
        this.setImage(ImageResources.NO_IMAGE);
        this.canvas.redraw();
        this.currentImageInfo = null;
    }

    private void drawThumbnail(ImageData imgData) {
        Rectangle bounds = this.canvas.getClientArea();
        Image buffer = new Image((Device)Display.getDefault(), bounds);
        GC gc = new GC((Drawable)buffer);
        int ix = 1;
        int iy = 1;
        int width = 130;
        int height = 216;
        if (imgData.imgHeight > imgData.imgWidth) {
            ix = (bounds.width - width) / 2;
        } else {
            width = 216;
            height = 130;
            iy = (bounds.height - height) / 2;
        }
        gc.drawImage(this.image, 0, 0, imgData.imgWidth, imgData.imgHeight, ix, iy, width, height);
        if (this.state == 2 && this.leftEnable) {
            gc.drawImage(ImageResources.SNAPSHOT_LEFT_HOVER, 0, 0);
        } else if (this.state == 3 && this.rightEnable) {
            Rectangle rect = ImageResources.SNAPSHOT_RIGHT_HOVER.getBounds();
            gc.drawImage(ImageResources.SNAPSHOT_RIGHT_HOVER, bounds.width - rect.width, 0);
        } else if (this.state == 4 && this.leftEnable) {
            gc.drawImage(ImageResources.SNAPSHOT_LEFT_PUSH, 0, 0);
        } else if (this.state == 5 && this.rightEnable) {
            Rectangle rect = ImageResources.SNAPSHOT_RIGHT_HOVER.getBounds();
            gc.drawImage(ImageResources.SNAPSHOT_RIGHT_PUSH, bounds.width - rect.width, 0);
        } else if (this.state == 1) {
            if (this.rightEnable) {
                Rectangle rect = ImageResources.SNAPSHOT_RIGHT_HOVER.getBounds();
                gc.drawImage(ImageResources.SNAPSHOT_RIGHT_HOVER, bounds.width - rect.width, 0);
            }
            if (this.leftEnable) {
                gc.drawImage(ImageResources.SNAPSHOT_LEFT_HOVER, 0, 0);
            }
        }
        imgData.gc.drawImage(buffer, 0, 0);
        buffer.dispose();
        gc.dispose();
    }

    public void drawSnapshot(long time) {
        this.currentImageInfo = Global.getGreatestImageInfoByTime(time);
        this.drawCurrentSnapshot();
    }

    private void drawCurrentSnapshot() {
        String path = null;
        path = this.currentImageInfo == null ? "noImage.jpg" : String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + this.currentImageInfo.getFileName();
        Image img = null;
        if (path.equals("noImage.jpg")) {
            img = ImageResources.NO_IMAGE;
        } else {
            try {
                img = new Image((Device)Display.getDefault(), path);
            }
            catch (IllegalArgumentException e) {
                Logger.exception((Throwable)e);
                img = ImageResources.NO_IMAGE;
            }
            catch (SWTError err) {
                Logger.exception((Throwable)err);
                img = ImageResources.NO_IMAGE;
            }
            catch (SWTException sWTException) {
                Logger.debug((Object)("Wait for receiving image : " + path));
                img = ImageResources.NO_IMAGE;
            }
            if (img.isDisposed()) {
                Logger.debug((Object)"before set image : disposed");
            }
        }
        this.setImage(img);
        this.canvas.redraw();
        Rectangle rect = img.getBounds();
        int imgType = 0;
        imgType = rect.width > rect.height ? 1 : 0;
        if (this.childShell != null) {
            if (this.imageState != imgType) {
                this.childShell.close();
                this.childShell = null;
                if (imgType == 1) {
                    this.childShellWidth = 402;
                    this.childShellHeight = 242;
                } else {
                    this.childShellWidth = 242;
                    this.childShellHeight = 402;
                }
                this.openChildShell(false);
                this.imageState = imgType;
            } else {
                this.popup.redraw();
            }
        }
    }

    private void setButtonCondition() {
        this.drawCurrentSnapshot();
        ImageInfo prevImage = Global.getPrevImageInfo(this.currentImageInfo);
        ImageInfo nextImage = Global.getNextImageInfo(this.currentImageInfo);
        this.leftEnable = prevImage != null;
        this.rightEnable = nextImage != null;
    }

    private void widgetSelected(long time) {
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(TimelineTableView.imageViewerID, time, time, null, null));
    }

    private void leftArrowAction() {
        ImageInfo imgInfo = Global.getPrevImageInfo(this.currentImageInfo);
        if (imgInfo != null) {
            this.drawSnapshot(imgInfo.getTime());
            this.widgetSelected(imgInfo.getTime());
        } else {
            Logger.warning((Object)"imgInfo is null");
        }
    }

    private void rightArrowAction() {
        ImageInfo imgInfo = Global.getNextImageInfo(this.currentImageInfo);
        if (imgInfo != null) {
            this.drawSnapshot(imgInfo.getTime());
            this.widgetSelected(imgInfo.getTime());
        } else {
            Logger.warning((Object)"imgInfo is null");
        }
    }

    private void setShellSizes(int type) {
        this.imageState = type;
        if (type == 1) {
            this.shellMaxHeight = 242;
            this.shellMaxWidth = 402;
            this.childWidth = 108;
            this.childHeight = 69;
            this.childShellWidth = 108;
            this.childShellHeight = 69;
        } else {
            this.shellMaxHeight = 402;
            this.shellMaxWidth = 242;
            this.childWidth = 69;
            this.childHeight = 108;
            this.childShellWidth = 69;
            this.childShellHeight = 108;
        }
    }

    private void setChildShellSizes(int type) {
        if (type == 1) {
            this.shellMaxHeight = 242;
            this.shellMaxWidth = 402;
            this.childWidth = 108;
            this.childHeight = 69;
        } else {
            this.shellMaxHeight = 402;
            this.shellMaxWidth = 242;
            this.childWidth = 69;
            this.childHeight = 108;
        }
    }

    private void openChildShell(boolean enableAnimation) {
        if (this.image == null) {
            return;
        }
        if (enableAnimation) {
            Rectangle rect = this.image.getBounds();
            if (rect.width > rect.height) {
                this.setShellSizes(1);
            } else {
                this.setShellSizes(0);
            }
        }
        this.childShell = new Shell(this.parent.getShell(), 16384);
        this.childShell.setLayout((Layout)new FillLayout());
        Point p = this.canvas.toDisplay(0, 0);
        this.childShell.setSize(this.childShellWidth, this.childShellHeight);
        this.childShell.setLocation(p.x - this.childShellWidth, p.y - 90);
        this.popup = new Canvas((Composite)this.childShell, 0x20000001);
        this.popup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageViewer.this.image == null || e.gc == null) {
                    return;
                }
                try {
                    Rectangle bounds = ImageViewer.this.image.getBounds();
                    int iw = bounds.width;
                    int ih = bounds.height;
                    int imageType = iw > ih ? 1 : 0;
                    ImageData imageData = new ImageData(imageType);
                    imageData.gc = e.gc;
                    imageData.imgWidth = iw;
                    imageData.imgHeight = ih;
                    if (iw > ih) {
                        ImageViewer.this.setChildShellSizes(1);
                    } else {
                        ImageViewer.this.setChildShellSizes(0);
                    }
                    Rectangle rects = ImageViewer.this.popup.getBounds();
                    int cw = rects.width - 2;
                    int ch = rects.height - 2;
                    e.gc.setForeground(ColorResources.BLACK);
                    imageData.gc.drawRectangle(rects.x, rects.y, rects.width - 1, rects.height - 1);
                    imageData.gc.drawImage(ImageViewer.this.image, 0, 0, imageData.imgWidth, imageData.imgHeight, 1, 1, cw, ch);
                    imageData.gc.dispose();
                }
                catch (SWTException se) {
                    Logger.exception((Throwable)se);
                }
            }
        });
        this.childShell.open();
        if (enableAnimation) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.timer = new Timer("Animation timer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ImageViewer.this.childShell == null || (this).ImageViewer.this.childShellWidth >= ImageViewer.this.shellMaxWidth) {
                                if (ImageViewer.this.timer != null) {
                                    ImageViewer.this.timer.cancel();
                                    ImageViewer.this.timer = null;
                                }
                                if (ImageViewer.this.childShell != null && !ImageViewer.this.childShell.isDisposed()) {
                                    ImageViewer.this.childShell.redraw();
                                }
                                return;
                            }
                            int x = (ImageViewer.this.shellMaxWidth - ImageViewer.this.childWidth) / 3;
                            int y = (ImageViewer.this.shellMaxHeight - ImageViewer.this.childHeight) / 3;
                            (this).ImageViewer.this.childShellWidth += x;
                            (this).ImageViewer.this.childShellHeight += y;
                            (this).ImageViewer.this.childShellWidth = (this).ImageViewer.this.childShellWidth > ImageViewer.this.shellMaxWidth ? ImageViewer.this.shellMaxWidth : (this).ImageViewer.this.childShellWidth;
                            (this).ImageViewer.this.childShellHeight = (this).ImageViewer.this.childShellHeight > ImageViewer.this.shellMaxHeight ? ImageViewer.this.shellMaxHeight : (this).ImageViewer.this.childShellHeight;
                            ImageViewer.this.childShell.setSize((this).ImageViewer.this.childShellWidth, (this).ImageViewer.this.childShellHeight);
                            Point p = ImageViewer.this.canvas.toDisplay(0, 0);
                            ImageViewer.this.childShell.setLocation(p.x - (this).ImageViewer.this.childShellWidth, p.y - 90);
                            ImageViewer.this.childShell.redraw();
                        }
                    });
                }
            }, 10L, 10L);
        }
    }

    static class ImageData {
        public GC gc = null;
        public int imgWidth;
        public int imgHeight;
        public int marginX;
        public int marginY;
        public int maxImageWidth;
        public int maxImageHeight;
        public int minImageWidth;
        public int minImageHeight;
        public double imgWidthRate;
        public double imgHeightRate;

        public ImageData(int type) {
            if (type == 1) {
                this.imgWidth = 450;
                this.imgHeight = 270;
                this.marginX = 5;
                this.marginY = 5;
                this.maxImageWidth = 800;
                this.maxImageHeight = 480;
                this.minImageWidth = 150;
                this.minImageHeight = 90;
                this.imgWidthRate = 216.0;
                this.imgHeightRate = 130.0;
            } else {
                this.imgWidth = 270;
                this.imgHeight = 450;
                this.marginX = 5;
                this.marginY = 5;
                this.maxImageWidth = 480;
                this.maxImageHeight = 800;
                this.minImageWidth = 130;
                this.minImageHeight = 216;
                this.imgWidthRate = 130.0;
                this.imgHeightRate = 216.0;
            }
        }
    }
}

