/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ScreenShotDBTable
extends DBTable {
    public static final String TABLENAME = "TIMELINE_SCREENSHOT";
    private static final int MAX_IMAGEPATH_LEN = 32;
    public static final String CAPTURE_TIME = "CAPTURE_TIME";
    public static final String IMAGE_FILE_PATH = "IMAGE_FILE_PATH";
    public static final String IMAGE_ORIENTATION = "IMAGE_ORIENTATION";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ScreenShotDBTable() {
        this.addColumn(new DBColumn(CAPTURE_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(IMAGE_FILE_PATH, "", "VARCHAR", 32));
        this.addColumn(new DBColumn(IMAGE_ORIENTATION, "NOT NULL", "INTEGER"));
        this.addIndex(COLUMN.CAPTURE_TIME.ordinal());
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.CAPTURE_TIME.ordinal()));
                String image_file = (String)rowData.get(COLUMN.IMAGE_FILE_PATH.ordinal());
                if (image_file != null && image_file.length() > 32) {
                    Logger.error((Object)("Overflow occurs MAX_IMAGEPATH_LEN in ScreenShotDBTable : " + image_file));
                    image_file = null;
                }
                prep.setString(2, image_file);
                prep.setInt(3, (Integer)rowData.get(COLUMN.IMAGE_ORIENTATION.ordinal()));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getString(2));
            row.add(rs.getInt(3));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        CAPTURE_TIME,
        IMAGE_FILE_PATH,
        IMAGE_ORIENTATION;

    }
}

