/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;

public enum MemoryPersistentAllocationsTableIndex {
    SEQ(0, 60, 1, 131072, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_SEQ),
    TIMESTAMP(1, 105, 1, 0x1000000, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TIMESTAMP),
    PID(2, 40, 1, 131072, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_PID),
    TID(3, 40, 1, 131072, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TID),
    ALLOCATED_ADDRESS(4, 90, 1, 131072, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_ALLOCATED_ADDRESS),
    SIZE(5, 45, 1, 131072, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_SIZE),
    LIBRARY(6, 205, 2, 16384, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_LIBRARY),
    CALLED(7, 115, 2, 0x1000000, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_CALLED_FUNCTION),
    LEAK(8, 60, 3, 0x1000000, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_LEAK);

    private int index;
    private int size;
    private int sortType;
    private int alignment;
    private String name;
    private static List<Integer> sizes;
    private static List<Integer> sortTypes;
    private static List<Integer> alignments;
    private static List<String> names;

    static {
        sizes = new ArrayList<Integer>();
        sortTypes = new ArrayList<Integer>();
        alignments = new ArrayList<Integer>();
        names = new ArrayList<String>();
        MemoryPersistentAllocationsTableIndex[] memoryPersistentAllocationsTableIndexArray = MemoryPersistentAllocationsTableIndex.values();
        int n = memoryPersistentAllocationsTableIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryPersistentAllocationsTableIndex col = memoryPersistentAllocationsTableIndexArray[n2];
            sizes.add(col.getSize());
            sortTypes.add(col.getSortType());
            alignments.add(col.getAlignment());
            names.add(col.getName());
            ++n2;
        }
    }

    private MemoryPersistentAllocationsTableIndex(int index, int size, int sortType, int alignment, String name) {
        this.index = index;
        this.size = size;
        this.sortType = sortType;
        this.alignment = alignment;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }

    public int getSortType() {
        return this.sortType;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getName() {
        return this.name;
    }

    private static int[] intListToArray(List<Integer> list) {
        int[] result = new int[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = list.get(i);
            ++i;
        }
        return result;
    }

    public static int[] getSizes() {
        return MemoryPersistentAllocationsTableIndex.intListToArray(sizes);
    }

    public static int[] getSortTypes() {
        return MemoryPersistentAllocationsTableIndex.intListToArray(sortTypes);
    }

    public static int[] getAlignments() {
        return MemoryPersistentAllocationsTableIndex.intListToArray(alignments);
    }

    public static String[] getNames() {
        return names.toArray(new String[0]);
    }
}

