/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLConstantDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateTextureType;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLTextureTable
extends DATableComposite {
    public GLTextureTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = GLTextureTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                GLSelectionData selData = new GLSelectionData(GLPage.textureViewID, -1L, -1L, items, (Control)GLTextureTable.this.table, -1, -1L);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        if (GLDataManager.getInstance().getStateDataManager() == null) {
            return input;
        }
        List<GLStateTextureType> textureList = GLDataManager.getInstance().getStateDataManager().getTextureMakeObject().getTextureList();
        if (textureList == null) {
            return null;
        }
        int size = textureList.size();
        int i = 0;
        while (i < size) {
            block16: {
                List<FilterProperty> filterList = this.getFilterPropertyList();
                String textureId = Integer.toString(textureList.get(i).getObjID());
                DATableDataFormat tableData = new DATableDataFormat(Long.parseLong(textureId));
                String contextId = String.valueOf(GLPageLabels.GL_CONTEXT) + Long.toString(textureList.get(i).getContextID());
                String textureIdStr = String.valueOf(GLPageLabels.GL_TEXTURE) + textureId;
                String type = GLConstantDefine.getAPIConstantString(textureList.get(i).getType());
                String wrapS = GLConstantDefine.getAPIConstantString(textureList.get(i).getWrapS());
                String wrapT = GLConstantDefine.getAPIConstantString(textureList.get(i).getWrapT());
                String minFilter = GLConstantDefine.getAPIConstantString(textureList.get(i).getMinFilter());
                String magFilter = GLConstantDefine.getAPIConstantString(textureList.get(i).getMagFilter());
                int j = 0;
                while (j < filterList.size()) {
                    switch (filterList.get(j).getColumnIndex()) {
                        case 0: {
                            if (contextId.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 1: {
                            if (textureIdStr.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 2: {
                            if (type.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 3: {
                            if (wrapS.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 4: {
                            if (wrapT.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 5: {
                            if (minFilter.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 6: {
                            if (!magFilter.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break block16;
                        }
                    }
                    ++j;
                }
                ArrayList<String> text = new ArrayList<String>();
                text.add(contextId);
                text.add(textureIdStr);
                text.add(type);
                text.add(wrapS);
                text.add(wrapT);
                text.add(minFilter);
                text.add(magFilter);
                TableInput tableInput = new TableInput();
                tableInput.setText(text);
                tableInput.setData(tableData);
                input.add(tableInput);
                long contextID = textureList.get(i).getContextID();
                if (GLDataManager.getInstance().getSelectedContextID() == contextID) {
                    tableInput.setSecondSelection(true);
                }
                if (GLDataManager.getInstance().isSharingData(contextID)) {
                    tableInput.setSecondSelection(true);
                }
            }
            ++i;
        }
        return input;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }
}

