/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.daemon;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.daemon.Server;
import org.tizen.common.daemon.ServerException;
import org.tizen.common.daemon.ServerState;

public abstract class AbstractServer
implements Server,
Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Thread thread = null;
    protected Lock lock = new ReentrantLock();
    protected ServerState state = ServerState.Terminated;
    protected final String name;

    public AbstractServer() {
        this(null);
    }

    public AbstractServer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ServerState getStatus() {
        this.lock.lock();
        try {
            ServerState serverState = this.state;
            return serverState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(ServerState state) {
        this.lock.lock();
        try {
            this.state = state;
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            AbstractServer abstractServer = this;
            synchronized (abstractServer) {
                this.notifyAll();
            }
            throw throwable;
        }
        this.lock.unlock();
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            this.notifyAll();
        }
    }

    public boolean isState(ServerState ... states) {
        this.lock.lock();
        try {
            ServerState[] serverStateArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                ServerState state = serverStateArray[n2];
                if (this.state.equals((Object)state)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitState(ServerState ... states) {
        while (!this.isState(states)) {
            try {
                AbstractServer abstractServer = this;
                synchronized (abstractServer) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (this.isState(new ServerState[]{ServerState.Halting})) {
            this.setStatus(ServerState.Terminated);
            return;
        }
        try {
            block12: {
                this.initialize();
                this.lock.lock();
                if (!this.isState(new ServerState[]{ServerState.Halting})) break block12;
                this.lock.unlock();
                return;
                {
                    catch (Throwable var1_1) {
                        throw var1_1;
                    }
                }
            }
            try {
                try {
                    this.setStatus(ServerState.Running);
                    if (true) ** GOTO lbl23
                }
                finally {
                    this.lock.unlock();
                }
                do {
                    this.process();
lbl23:
                    // 2 sources

                } while (!this.isState(new ServerState[]{ServerState.Halting}));
            }
            catch (Exception e) {
                this.logger.error("Error occurred:", (Throwable)e);
            }
        }
        finally {
            this.terminate();
            this.setStatus(ServerState.Terminated);
        }
    }

    @Override
    public void boot() throws ServerException {
        this.lock.lock();
        try {
            if (!this.isState(ServerState.Terminated)) {
                throw new IllegalStateException();
            }
            String name = this.getName();
            this.thread = name == null ? new Thread(this) : new Thread((Runnable)this, name);
            this.thread.setDaemon(true);
            this.thread.start();
            this.setStatus(ServerState.Initializing);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void down() throws ServerException {
        this.lock.lock();
        try {
            if (this.isState(ServerState.Terminated, ServerState.Halting)) {
                throw new IllegalStateException();
            }
            this.setStatus(ServerState.Halting);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void initialize() throws ServerException;

    protected abstract void process() throws Exception;

    protected abstract void terminate();
}

