/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import java.io.IOException;
import java.rmi.ConnectException;
import org.apache.commons.cli.ParseException;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArgumentsParser;
import org.tizen.dynamicanalyzer.cli.utils.Help;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.util.Logger;

public class StartCommand
extends Command {
    private TracingArguments parsedArgs;

    public StartCommand() {
        super("start", 0, "start tracing on specified target for specified application using selected tracing features", "<ip:port|serial>");
    }

    @Override
    public boolean checkArgs(String[] args) {
        if (this.parsedArgs == null) {
            try {
                this.parsedArgs = TracingArgumentsParser.parse(args);
            }
            catch (ParseException e) {
                System.out.println("Wrong command arguments: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public void printHelp() {
        String message = String.format("  %-25s : %s%n", this.name + " " + this.optsFormat, this.helpMessage);
        try {
            Help.printHelp(message, TracingArgumentsParser.getOpts(), System.out);
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
    }

    @Override
    public ExitCode processCommand(String[] args) {
        DAResult result;
        if (!this.checkArgs(args)) {
            return ExitCode.EX_ARGUMENTS_ERROR;
        }
        try {
            result = CliInternals.startTracingProcess(this.parsedArgs);
        }
        catch (ConnectException e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return ExitCode.EX_CONNECTION_ERROR;
        }
        if (!result.isSuccess()) {
            System.out.println("Can't start tracing. " + result.getMessage());
            return ExitCode.EX_OPERATION_FAILED;
        }
        System.out.println("DA tracing started.");
        System.out.printf("Run \"dacli stop %s\" to finish it.%n", this.parsedArgs.getDevice());
        return ExitCode.EX_SUCCESS;
    }
}

