/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.launch.CSourceLookup;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.internal.symbols.MemoryVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.EDCSymbolReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerEABI;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglingException;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.IFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.services.IFrameRegisters;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IUnmangler;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class Stack
extends AbstractEDCService
implements IStack,
ICachingService {
    public static final String STACK_FRAME = "stack_frame";
    public Boolean showAllVariablesEnabled = null;
    private final Map<String, List<StackFrameDMC>> stackFrames = Collections.synchronizedMap(new HashMap());
    private final Map<String, Boolean> allFramesCached = Collections.synchronizedMap(new HashMap());

    public Stack(DsfSession session, String[] classNames) {
        super(session, Stack.massageClassNames(classNames, new String[]{IStack.class.getName(), Stack.class.getName()}));
    }

    public static String createFrameID(IEDCExecutionDMC executionDMC, EdcStackFrame edcFrame) {
        int level = (Integer)edcFrame.props.get("Level");
        String parentID = executionDMC.getID();
        return String.valueOf(parentID) + ".frame[" + level + "]";
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.getSession().addServiceEventListener((Object)this, null);
    }

    public void getArguments(IStack.IFrameDMContext frameCtx, DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        rm.done();
    }

    public void getFrameData(IStack.IFrameDMContext frameDmc, DataRequestMonitor<IStack.IFrameDMData> rm) {
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(frameDmc));
        }
        rm.setData((Object)new StackFrameData((StackFrameDMC)frameDmc));
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(rm.getData()));
        }
        rm.done();
    }

    public void getFrames(final IDMContext execContext, final DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        RunControl.ExecutionDMC execDmc;
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(execContext));
        }
        if ((execDmc = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)execContext, RunControl.ExecutionDMC.class)) != null) {
            if (!execDmc.isSuspended()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "Context is running: " + execDmc, null));
                rm.done();
                return;
            }
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        rm.setData((Object)Stack.this.getFramesForDMC((RunControl.ExecutionDMC)execContext, 0, -1));
                        if (((IStack.IFrameDMContext[])rm.getData()).length == 0) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No stack frame available for: " + execDmc, null));
                        }
                    }
                    catch (CoreException e) {
                        Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                        EDCDebugger.getMessageLogger().log((IStatus)s);
                        rm.setStatus((IStatus)s);
                    }
                    if (EDCTrace.STACK_TRACE_ON) {
                        EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(rm.getData()));
                    }
                    rm.done();
                }
            }, (RequestMonitor)rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Invalid context", null));
            rm.done();
        }
    }

    public void getLocals(final IStack.IFrameDMContext frameCtx, final DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                StackFrameDMC frameContext = (StackFrameDMC)frameCtx;
                IAddress contextIPAddress = frameContext.getInstructionPtrAddress();
                boolean useVariableCache = false;
                try {
                    IStack.IFrameDMContext[] iFrames;
                    IStack.IFrameDMContext[] iFrameDMContextArray = iFrames = Stack.this.getFramesForDMC(frameContext.getExecutionDMC(), 0, -1);
                    int n = iFrames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStack.IFrameDMContext iFrameDMC = iFrameDMContextArray[n2];
                        if (frameCtx == iFrameDMC) {
                            useVariableCache = true;
                            break;
                        }
                        if (frameContext.equals(iFrameDMC)) {
                            StackFrameDMC frameDMC = (StackFrameDMC)iFrameDMC;
                            IAddress stackFrameIPAddr = frameDMC.getInstructionPtrAddress();
                            if (contextIPAddress.equals((Object)stackFrameIPAddr)) {
                                useVariableCache = true;
                                break;
                            }
                            frameContext.setInstructionPtrAddress(stackFrameIPAddr);
                            break;
                        }
                        ++n2;
                    }
                    rm.setData((Object)frameContext.getLocals(useVariableCache));
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().log(e.getStatus());
                    rm.setStatus(e.getStatus());
                }
                rm.done();
            }
        }, (RequestMonitor)rm);
    }

    public void getStackDepth(IDMContext dmc, final int maxDepth, final DataRequestMonitor<Integer> rm) {
        RunControl.ExecutionDMC execDmc;
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{dmc, maxDepth}));
        }
        if ((execDmc = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)dmc, RunControl.ExecutionDMC.class)) != null) {
            if (!execDmc.isSuspended()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "Context is running: " + execDmc, null));
                rm.done();
                return;
            }
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int startFrame = 0;
                    int endFrame = -1;
                    if (maxDepth > 0) {
                        endFrame = maxDepth - 1;
                    }
                    try {
                        rm.setData((Object)Stack.this.getFramesForDMC(execDmc, startFrame, endFrame).length);
                        if ((Integer)rm.getData() == 0) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No stack frame available for: " + execDmc, null));
                        }
                        if (EDCTrace.STACK_TRACE_ON) {
                            EDCTrace.getTrace().traceExit(null, rm.getData());
                        }
                    }
                    catch (CoreException e) {
                        Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                        EDCDebugger.getMessageLogger().log((IStatus)s);
                        rm.setStatus((IStatus)s);
                    }
                    rm.done();
                }
            }, (RequestMonitor)rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Invalid context", null));
            rm.done();
        }
    }

    public void getTopFrame(final IDMContext execContext, final DataRequestMonitor<IStack.IFrameDMContext> rm) {
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(execContext));
        }
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IStack.IFrameDMContext[] frames = Stack.this.getFramesForDMC((RunControl.ExecutionDMC)execContext, 0, 0);
                    if (frames.length == 0) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No top stack frame available", null));
                        rm.done();
                        return;
                    }
                    rm.setData((Object)frames[0]);
                }
                catch (CoreException e) {
                    Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                    EDCDebugger.getMessageLogger().log((IStatus)s);
                    rm.setStatus((IStatus)s);
                }
                if (EDCTrace.STACK_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(rm.getData()));
                }
                rm.done();
            }
        }, (RequestMonitor)rm);
    }

    public void getVariableData(IStack.IVariableDMContext variableDmc, DataRequestMonitor<IStack.IVariableDMData> rm) {
        rm.setData((Object)new VariableData((VariableDMC)variableDmc));
        rm.done();
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IStack.IFrameDMContext) {
            this.getFrameData((IStack.IFrameDMContext)dmc, rm);
        } else if (dmc instanceof IStack.IVariableDMContext) {
            this.getVariableData((IStack.IVariableDMContext)dmc, rm);
        } else {
            rm.done();
        }
    }

    public void getFrames(final IDMContext execContext, final int startIndex, final int endIndex, final DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        RunControl.ExecutionDMC execDmc;
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{execContext, startIndex, endIndex}));
        }
        if ((execDmc = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)execContext, RunControl.ExecutionDMC.class)) != null) {
            if (!execDmc.isSuspended()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "Context is running: " + execDmc, null));
                rm.done();
                return;
            }
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        rm.setData((Object)Stack.this.getFramesForDMC((RunControl.ExecutionDMC)execContext, startIndex, endIndex));
                        if (((IStack.IFrameDMContext[])rm.getData()).length == 0) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10001, "No stack frame available for: " + execContext, null));
                        }
                    }
                    catch (CoreException e) {
                        Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                        EDCDebugger.getMessageLogger().log((IStatus)s);
                        rm.setStatus((IStatus)s);
                    }
                    if (EDCTrace.STACK_TRACE_ON) {
                        EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArgs((Object[])rm.getData()));
                    }
                    rm.done();
                }
            }, (RequestMonitor)rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Invalid context", null));
            rm.done();
        }
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArgs((Object[])rm.getData()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStack.IFrameDMContext[] getFramesForDMC(IEDCExecutionDMC context, int startIndex, int endIndex) throws CoreException {
        if (EDCTrace.STACK_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context, startIndex, endIndex}));
        }
        if (!context.isSuspended() || !RunControl.isNonContainer((IDMContext)context)) {
            return new IStack.IFrameDMContext[0];
        }
        boolean needsUpdate = false;
        Map<String, List<StackFrameDMC>> map = this.stackFrames;
        synchronized (map) {
            List<StackFrameDMC> frames = this.stackFrames.get(context.getID());
            if (frames == null) {
                needsUpdate = true;
            } else if (this.allFramesCached.get(context.getID()).booleanValue()) {
                needsUpdate = false;
            } else if (endIndex == -1) {
                needsUpdate = true;
            } else {
                boolean bl = needsUpdate = frames.get(0).getLevel() > startIndex || frames.get(frames.size() - 1).getLevel() < endIndex;
            }
            if (needsUpdate) {
                this.updateFrames(context, startIndex, endIndex);
            }
            frames = this.stackFrames.get(context.getID());
            if (endIndex >= 0) {
                frames = startIndex < frames.size() && startIndex <= endIndex ? frames.subList(startIndex, Math.min(endIndex + 1, frames.size())) : Collections.emptyList();
            }
            Object[] result = frames.toArray(new IStack.IFrameDMContext[frames.size()]);
            if (EDCTrace.STACK_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArgs(result));
            }
            return result;
        }
    }

    private void updateFrames(IEDCExecutionDMC context, int startIndex, int endIndex) throws CoreException {
        ArrayList<StackFrameDMC> frames = new ArrayList<StackFrameDMC>();
        List<EdcStackFrame> edcFrames = this.computeStackFrames(context, startIndex, endIndex);
        StackFrameDMC previous = null;
        for (EdcStackFrame edcFrame : edcFrames) {
            StackFrameDMC frame = new StackFrameDMC(context, edcFrame);
            if (previous != null) {
                frame.calledFrame = previous;
            }
            frames.add(frame);
            previous = frame;
        }
        this.stackFrames.put(context.getID(), frames);
        this.allFramesCached.put(context.getID(), startIndex == 0 && (endIndex == -1 || frames.size() <= endIndex));
    }

    protected abstract List<EdcStackFrame> computeStackFrames(IEDCExecutionDMC var1, int var2, int var3) throws CoreException;

    public void loadFramesForContext(IEDCExecutionDMC exeDmc, Element allFrames) throws Exception {
        this.flushCache(null);
        List<StackFrameDMC> frames = Collections.synchronizedList(new ArrayList());
        NodeList frameElements = allFrames.getElementsByTagName(STACK_FRAME);
        int numFrames = frameElements.getLength();
        StackFrameDMC previousFrameDMC = null;
        int i = 0;
        while (i < numFrames) {
            Element groupElement = (Element)frameElements.item(i);
            Element propElement = (Element)groupElement.getElementsByTagName("properties").item(0);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            SnapshotUtils.initializeFromXML(propElement, properties);
            properties.put("Level", i);
            StackFrameDMC frameDMC = new StackFrameDMC(exeDmc, new EdcStackFrame(properties));
            frameDMC.loadSnapshot(groupElement);
            if (previousFrameDMC != null) {
                frameDMC.calledFrame = previousFrameDMC;
            }
            frames.add(frameDMC);
            previousFrameDMC = frameDMC;
            ++i;
        }
        this.stackFrames.put(exeDmc.getID(), frames);
        this.allFramesCached.put(exeDmc.getID(), true);
    }

    public void flushCache(IDMContext context) {
        if (this.isSnapshot()) {
            return;
        }
        if (context != null && context instanceof IEDCDMContext) {
            String contextID = ((IEDCDMContext)context).getID();
            this.stackFrames.remove(contextID);
            this.allFramesCached.remove(contextID);
        } else {
            this.stackFrames.clear();
            this.allFramesCached.clear();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.flushCache(e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.flushCache(e.getDMContext());
    }

    public static class AlwaysFailingFrameRegisters
    implements IFrameRegisters {
        private final CoreException e;

        public AlwaysFailingFrameRegisters(CoreException e) {
            this.e = e;
        }

        @Override
        public BigInteger getRegister(int regnum, int bytes) throws CoreException {
            throw this.e;
        }

        @Override
        public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
            throw this.e;
        }
    }

    public static final class CurrentFrameRegisters
    implements IFrameRegisters {
        private final Registers registers;
        private final IEDCExecutionDMC executionDMC;

        public CurrentFrameRegisters(IEDCExecutionDMC executionDMC, Registers registers) {
            this.executionDMC = executionDMC;
            this.registers = registers;
        }

        @Override
        public BigInteger getRegister(int regnum, int bytes) throws CoreException {
            String value = this.registers.getRegisterValue(this.executionDMC, regnum);
            if (value == null || value.equals("badbadba")) {
                throw EDCDebugger.newCoreException("failed to read register");
            }
            return new BigInteger(value, 16);
        }

        @Override
        public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
            String id = this.registers.getRegisterNameFromCommonID(regnum);
            if (id == null) {
                throw EDCDebugger.newCoreException(MessageFormat.format("could not find register number {0}", regnum));
            }
            this.registers.writeRegister(this.executionDMC, id, Long.toHexString(value.longValue()));
        }
    }

    public class EdcStackFrame {
        public Map<String, Object> props;

        public EdcStackFrame(Map<String, Object> props) {
            this.props = props;
        }
    }

    public class EnumeratorDMC
    extends DMContext
    implements IEnumeratorDMContext,
    IVariableEnumeratorContext {
        private final IEnumerator enumerator;

        public EnumeratorDMC(StackFrameDMC frame, IEnumerator enumerator) {
            super((IDsfService)Stack.this, new IDMContext[]{frame}, enumerator.getName(), enumerator.getName());
            this.enumerator = enumerator;
        }

        public IEnumerator getEnumerator() {
            return this.enumerator;
        }
    }

    public static interface IEnumeratorDMContext {
    }

    public static interface IVariableEnumeratorContext {
    }

    public static class PreservedFrameRegisters
    implements IFrameRegisters {
        private final Map<Integer, BigInteger> preservedRegisters;
        private final EDCServicesTracker dsfServicesTracker;
        private final StackFrameDMC context;

        public PreservedFrameRegisters(EDCServicesTracker dsfServicesTracker, StackFrameDMC context, Map<Integer, BigInteger> preservedRegisters) {
            this.dsfServicesTracker = dsfServicesTracker;
            this.context = context;
            this.preservedRegisters = preservedRegisters;
        }

        @Override
        public BigInteger getRegister(int regnum, int bytes) throws CoreException {
            BigInteger addrVal = this.preservedRegisters.get(regnum);
            if (addrVal != null) {
                MemoryVariableLocation location = new MemoryVariableLocation(this.dsfServicesTracker, (IDMContext)this.context, addrVal, true);
                return location.readValue(bytes);
            }
            throw EDCDebugger.newCoreException("cannot read $R" + regnum + " from frame");
        }

        @Override
        public void writeRegister(int regnum, int bytes, BigInteger value) throws CoreException {
            BigInteger addrVal = this.preservedRegisters.get(regnum);
            if (addrVal != null) {
                MemoryVariableLocation location = new MemoryVariableLocation(this.dsfServicesTracker, (IDMContext)this.context, addrVal, true);
                location.writeValue(bytes, value);
            }
        }
    }

    public class StackFrameDMC
    extends DMContext
    implements IStack.IFrameDMContext,
    Comparable<StackFrameDMC>,
    ISnapshotContributor {
        public static final String LEVEL_INDEX = "Level";
        public static final String ROOT_FRAME = "root_frame";
        public static final String BASE_ADDR = "Base_address";
        public static final String INSTRUCTION_PTR_ADDR = "Instruction_address";
        public static final String MODULE_NAME = "module_name";
        public static final String SOURCE_FILE = "source_file";
        public static final String FUNCTION_NAME = "function_name";
        public static final String LINE_NUMBER = "line_number";
        public static final String IN_PROLOGUE = "in_prologue";
        public static final String PRESERVED_REGISTERS = "preserved_registers";
        private static final String FRAME_PROPERTY_CACHE = "_frame_properties";
        public static final String EXECUTION_DMC_ID = "execution_dmc_id";
        private final EDCServicesTracker dsfServicesTracker;
        private final IEDCExecutionDMC executionDMC;
        private final int level;
        private IAddress baseAddress;
        private IAddress instructionPtrAddress;
        private String moduleName;
        private String sourceFile;
        private String functionName;
        private int lineNumber;
        private IScope variableScope;
        private List<VariableDMC> locals;
        private List<EnumeratorDMC> enumerators;
        private final Map<String, VariableDMC> localsByName;
        private final Map<String, EnumeratorDMC> enumeratorsByName;
        private final Map<String, IVariable> thisPtrs;
        private IFunctionScope functionScope;
        private IFrameRegisters frameRegisters;
        public StackFrameDMC calledFrame;
        private TypeEngine typeEngine;
        private IEDCModuleDMContext module;
        private IAddress instrPtrLinkAddr;
        private IEDCSymbolReader reader;
        private IModuleLineEntryProvider provider;
        private IDebugInfoProvider debugInfoProvider;
        private IPath symbolFile;

        public StackFrameDMC(IEDCExecutionDMC executionDMC, EdcStackFrame edcFrame) {
            String cacheKey;
            super((IDsfService)Stack.this, new IDMContext[]{executionDMC}, Stack.createFrameID(executionDMC, edcFrame), edcFrame.props);
            this.dsfServicesTracker = Stack.this.getEDCServicesTracker();
            this.moduleName = "";
            this.sourceFile = "";
            this.functionName = "";
            this.variableScope = null;
            this.localsByName = Collections.synchronizedMap(new HashMap());
            this.enumeratorsByName = Collections.synchronizedMap(new HashMap());
            this.thisPtrs = Collections.synchronizedMap(new LinkedHashMap());
            this.instrPtrLinkAddr = null;
            this.reader = null;
            this.provider = null;
            this.debugInfoProvider = null;
            this.symbolFile = null;
            Map<String, Object> frameProperties = edcFrame.props;
            this.executionDMC = executionDMC;
            frameProperties.put(EXECUTION_DMC_ID, executionDMC.getID());
            this.level = (Integer)frameProperties.get(LEVEL_INDEX);
            this.moduleName = (String)frameProperties.get(MODULE_NAME);
            this.baseAddress = this.address(frameProperties.get(BASE_ADDR));
            this.instructionPtrAddress = this.address(frameProperties.get(INSTRUCTION_PTR_ADDR));
            IEDCSymbols symbolsService = Stack.this.getService(Symbols.class);
            this.functionScope = symbolsService.getFunctionAtAddress(executionDMC.getSymbolDMContext(), this.instructionPtrAddress);
            boolean usingCachedProperties = false;
            IEDCModules modules = this.dsfServicesTracker.getService(IEDCModules.class);
            Map cachedFrameProperties = new HashMap<IAddress, Map<String, Object>>();
            if (modules != null) {
                this.module = modules.getModuleByAddress(executionDMC.getSymbolDMContext(), this.instructionPtrAddress);
                if (this.module != null) {
                    this.instrPtrLinkAddr = this.module.toLinkAddress(this.instructionPtrAddress);
                    this.reader = this.module.getSymbolReader();
                    if (this.reader != null) {
                        this.symbolFile = this.reader.getSymbolFile();
                        if (this.symbolFile != null) {
                            Map cachedProperties;
                            cacheKey = String.valueOf(this.reader.getSymbolFile().toOSString()) + FRAME_PROPERTY_CACHE;
                            Map cachedData = EDCDebugger.getDefault().getCache().getCachedData(cacheKey, Map.class, this.reader.getModificationDate());
                            if (cachedData != null && (cachedProperties = (Map)(cachedFrameProperties = cachedData).get(this.instrPtrLinkAddr)) != null) {
                                Object fnObj;
                                if (cachedProperties.containsKey(SOURCE_FILE)) {
                                    frameProperties.put(SOURCE_FILE, cachedProperties.get(SOURCE_FILE));
                                }
                                boolean cachedPropertiesHasFunctionName = false;
                                if (cachedProperties.containsKey(FUNCTION_NAME) && (fnObj = cachedProperties.get(FUNCTION_NAME)) != null && fnObj instanceof String && ((String)fnObj).length() != 0) {
                                    frameProperties.put(FUNCTION_NAME, fnObj);
                                    cachedPropertiesHasFunctionName = true;
                                }
                                if (!cachedPropertiesHasFunctionName) {
                                    this.setFunctionName(executionDMC, frameProperties, symbolsService);
                                    cachedProperties.put(FUNCTION_NAME, this.functionName);
                                }
                                if (cachedProperties.containsKey(LINE_NUMBER)) {
                                    frameProperties.put(LINE_NUMBER, cachedProperties.get(LINE_NUMBER));
                                }
                                usingCachedProperties = true;
                            }
                        }
                    }
                }
            }
            if (frameProperties.containsKey(SOURCE_FILE)) {
                this.sourceFile = (String)frameProperties.get(SOURCE_FILE);
                this.functionName = (String)frameProperties.get(FUNCTION_NAME);
                this.lineNumber = (Integer)frameProperties.get(LINE_NUMBER);
            } else if (frameProperties.containsKey(FUNCTION_NAME)) {
                this.functionName = (String)frameProperties.get(FUNCTION_NAME);
            } else if (!usingCachedProperties) {
                ILineEntry line = symbolsService.getLineEntryForAddress(executionDMC.getSymbolDMContext(), this.instructionPtrAddress);
                if (line != null) {
                    this.setSourceProperties(frameProperties, line);
                }
                this.setFunctionName(executionDMC, frameProperties, symbolsService);
            }
            this.properties.putAll(frameProperties);
            if (this.symbolFile != null) {
                cacheKey = String.valueOf(this.symbolFile.toOSString()) + FRAME_PROPERTY_CACHE;
                cachedFrameProperties.put(this.instrPtrLinkAddr, frameProperties);
                EDCDebugger.getDefault().getCache().putCachedData(cacheKey, (Serializable)((Object)cachedFrameProperties), this.reader.getModificationDate());
            }
            if (this.reader instanceof EDCSymbolReader) {
                this.debugInfoProvider = ((EDCSymbolReader)this.reader).getDebugInfoProvider();
            }
            this.typeEngine = new TypeEngine(Stack.this.getTargetEnvironmentService(), this.debugInfoProvider);
        }

        private void setFunctionName(IEDCExecutionDMC executionDMC, Map<String, Object> frameProperties, IEDCSymbols symbolsService) {
            if (this.functionScope != null) {
                IFunctionScope containerScope = this.functionScope;
                while (containerScope.getParent() instanceof IFunctionScope) {
                    containerScope = (IFunctionScope)containerScope.getParent();
                }
                this.functionName = this.unmangle(containerScope.getName());
                this.adjustFunctionSourceInfo(containerScope, frameProperties);
            } else {
                this.functionName = this.unmangle(symbolsService.getSymbolNameAtAddress(executionDMC.getSymbolDMContext(), this.instructionPtrAddress));
            }
            frameProperties.put(FUNCTION_NAME, this.functionName);
        }

        private void adjustFunctionSourceInfo(IFunctionScope container, Map<String, Object> frameProperties) {
            if (this.functionScope.equals(container)) {
                ILineEntry funcFirstEntry = this.getLineEntryInFunction(this.functionScope);
                if (funcFirstEntry != null && !this.instrPtrLinkAddr.equals((Object)funcFirstEntry.getLowAddress())) {
                    this.setSourceProperties(frameProperties, funcFirstEntry);
                }
                return;
            }
            ILineEntry containerEntry = this.getLineEntryInFunction(container);
            if (containerEntry != null && this.isInlineShouldBeHidden(containerEntry)) {
                this.setSourceProperties(frameProperties, containerEntry);
                return;
            }
            this.functionName = String.valueOf(this.unmangle(this.functionScope.getName())) + " inlined in " + this.functionName;
        }

        public boolean isInlineShouldBeHidden(ILineEntry entry) {
            if (this.functionScope == null || !(this.functionScope.getParent() instanceof IFunctionScope) || !this.instrPtrLinkAddr.equals((Object)this.functionScope.getLowAddress())) {
                return false;
            }
            if (entry == null && (entry = this.getLineEntryInFunction(this.functionScope)) == null) {
                return false;
            }
            if (this.instrPtrLinkAddr.equals((Object)entry.getLowAddress())) {
                ILineEntry prevEntry = this.getPreviousLineEntry(entry, true);
                if (prevEntry != null) {
                    ILineEntry testEntry = this.getNextLineEntry(prevEntry, true);
                    return entry.equals(testEntry);
                }
                return true;
            }
            return false;
        }

        private ILineEntry getLineEntryInFunction(IFunctionScope func) {
            return this.getModuleLineEntryProvider().getLineEntryInFunction(this.instrPtrLinkAddr, func);
        }

        private IModuleLineEntryProvider getModuleLineEntryProvider() {
            IModuleScope moduleScope;
            if (this.provider == null && this.reader != null && (moduleScope = this.reader.getModuleScope()) != null) {
                this.provider = moduleScope.getModuleLineEntryProvider();
            }
            return this.provider;
        }

        private ILineEntry getNextLineEntry(ILineEntry entry, boolean collapseInlineFunctions) {
            return this.getModuleLineEntryProvider().getNextLineEntry(entry, collapseInlineFunctions);
        }

        private ILineEntry getPreviousLineEntry(ILineEntry entry, boolean collapseInlineFunctions) {
            return this.getModuleLineEntryProvider().getPreviousLineEntry(entry, collapseInlineFunctions);
        }

        private void setSourceProperties(Map<String, Object> frameProperties, ILineEntry entry) {
            this.sourceFile = entry.getFilePath().toOSString();
            frameProperties.put(SOURCE_FILE, this.sourceFile);
            this.lineNumber = entry.getLineNumber();
            frameProperties.put(LINE_NUMBER, this.lineNumber);
        }

        private String unmangle(String name) {
            if (name == null) {
                return null;
            }
            IUnmangler unmangler = null;
            if (this.reader instanceof EDCSymbolReader) {
                unmangler = ((EDCSymbolReader)this.reader).getUnmangler();
            }
            if (unmangler == null) {
                unmangler = new UnmanglerEABI();
            }
            if (!unmangler.isMangled(name)) {
                return name;
            }
            try {
                return unmangler.unmangleWithoutArgs(name);
            }
            catch (UnmanglingException unmanglingException) {
                return name;
            }
        }

        private IAddress address(Object obj) {
            if (obj instanceof Integer) {
                return new Addr64(obj.toString());
            }
            if (obj instanceof Long) {
                return new Addr64(obj.toString());
            }
            if (obj instanceof String) {
                return new Addr64((String)obj, 16);
            }
            return null;
        }

        private void setInstructionPtrAddress(IAddress ipAddrPtr) {
            this.instructionPtrAddress = ipAddrPtr;
            if (this.module != null) {
                this.instrPtrLinkAddr = this.module.toLinkAddress(this.instructionPtrAddress);
            }
        }

        public IFunctionScope getFunctionScope() {
            return this.functionScope;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public IEDCExecutionDMC getExecutionDMC() {
            return this.executionDMC;
        }

        public IAddress getBaseAddress() {
            return this.baseAddress;
        }

        public IAddress getInstructionPtrAddress() {
            return this.instructionPtrAddress;
        }

        public int getLevel() {
            return this.level;
        }

        public EDCServicesTracker getEDCServicesTracker() {
            return Stack.this.getEDCServicesTracker();
        }

        @Override
        public int compareTo(StackFrameDMC f) {
            if (this.level < f.level) {
                return -1;
            }
            if (this.level > f.level) {
                return 1;
            }
            return 0;
        }

        @Override
        public String toString() {
            return "StackFrameDMC [baseAddress=" + this.baseAddress.toHexAddressString() + ", ipAddress=" + this.instructionPtrAddress.toHexAddressString() + ", sourceFile=" + this.sourceFile + ", functionName=" + this.functionName + ", lineNumber=" + this.lineNumber + "]";
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.baseAddress == null ? 0 : this.baseAddress.hashCode());
            result = 31 * result + (this.executionDMC == null ? 0 : this.executionDMC.hashCode());
            result = 31 * result + this.level;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackFrameDMC other = (StackFrameDMC)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.baseAddress == null ? other.baseAddress != null : !this.baseAddress.equals((Object)other.baseAddress)) {
                return false;
            }
            if (this.executionDMC == null ? other.executionDMC != null : !this.executionDMC.equals(other.executionDMC)) {
                return false;
            }
            return this.level == other.level;
        }

        private String findSourceFile(String sourceFile) {
            CSourceLookupDirector[] directors;
            String result = "";
            CSourceLookup lookup = Stack.this.getService(CSourceLookup.class);
            RunControl runControl = Stack.this.getService(RunControl.class);
            CSourceLookupDirector[] cSourceLookupDirectorArray = directors = lookup.getSourceLookupDirectors(runControl.getRootDMC());
            int n = directors.length;
            int n2 = 0;
            while (n2 < n) {
                CSourceLookupDirector cSourceLookupDirector = cSourceLookupDirectorArray[n2];
                try {
                    Object[] elements = cSourceLookupDirector.findSourceElements((Object)sourceFile);
                    if (elements != null && elements.length > 0) {
                        Object element = elements[0];
                        if (element instanceof File) {
                            try {
                                result = ((File)element).getCanonicalPath();
                            }
                            catch (IOException e) {
                                EDCDebugger.getMessageLogger().logError(null, e);
                            }
                            break;
                        }
                        if (element instanceof IFile) {
                            result = ((IFile)element).getLocation().toOSString();
                            break;
                        }
                        if (element instanceof IStorage) {
                            result = ((IStorage)element).getFullPath().toOSString();
                            break;
                        }
                        if (!(element instanceof ITranslationUnit)) break;
                        result = ((ITranslationUnit)element).getLocation().toOSString();
                        break;
                    }
                }
                catch (CoreException e1) {
                    EDCDebugger.getMessageLogger().logError(sourceFile, e1);
                }
                ++n2;
            }
            return result;
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            Element contextElement = document.createElement(Stack.STACK_FRAME);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            if (this.sourceFile.length() > 0) {
                album.addFile((IPath)new Path(this.findSourceFile(this.sourceFile)));
            }
            return contextElement;
        }

        @Override
        public void loadSnapshot(Element element) {
            Map preservedRegisters = (Map)this.properties.get(PRESERVED_REGISTERS);
            if (preservedRegisters != null) {
                HashMap<Integer, BigInteger> newPreservedRegisters = new HashMap<Integer, BigInteger>();
                for (Map.Entry entry : preservedRegisters.entrySet()) {
                    newPreservedRegisters.put(Integer.valueOf(((String)entry.getKey()).toString()), new BigInteger(((String)entry.getValue()).toString()));
                }
                this.properties.put(PRESERVED_REGISTERS, newPreservedRegisters);
            }
        }

        public IStack.IVariableDMContext[] getLocals() {
            return this.getLocals(true);
        }

        private IStack.IVariableDMContext[] getLocals(boolean useCachedVariables) {
            if (Stack.this.showAllVariablesEnabled == null) {
                IEclipsePreferences scope = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.edc");
                Stack.this.showAllVariablesEnabled = scope.getBoolean("show_all_variables_enabled", false);
            }
            boolean enabled = Stack.this.showAllVariablesEnabled;
            if (this.locals != null) {
                IEclipsePreferences scope = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.edc");
                enabled = scope.getBoolean("show_all_variables_enabled", Stack.this.showAllVariablesEnabled.booleanValue());
            }
            if (this.locals == null || !useCachedVariables || enabled != Stack.this.showAllVariablesEnabled) {
                Stack.this.showAllVariablesEnabled = enabled;
                this.locals = new ArrayList<VariableDMC>();
                this.localsByName.clear();
                this.thisPtrs.clear();
                IEDCSymbols symbolsService = Stack.this.getService(IEDCSymbols.class);
                IFunctionScope scope = symbolsService.getFunctionAtAddress(this.executionDMC.getSymbolDMContext(), this.instructionPtrAddress);
                if (scope != null) {
                    this.variableScope = scope;
                }
                while (scope != null && this.instrPtrLinkAddr != null) {
                    Collection<IVariable> scopedVariables = scope.getScopedVariables(this.instrPtrLinkAddr);
                    for (IVariable variable : scopedVariables) {
                        VariableDMC var = new VariableDMC(Stack.this, this, variable);
                        String name = variable.getName();
                        if (name != null && name.equals("this")) {
                            this.thisPtrs.put(variable.getScope().getName(), variable);
                            continue;
                        }
                        if (!var.getVariable().isDeclared()) continue;
                        VariableDMC variableDMC = this.localsByName.get(name);
                        if (variableDMC != null) {
                            this.localsByName.remove(name);
                            this.locals.remove(variableDMC);
                        }
                        this.locals.add(var);
                        this.localsByName.put(name, var);
                    }
                    IScope parentScope = null;
                    if (Stack.this.showAllVariablesEnabled.booleanValue()) {
                        parentScope = scope.getParent();
                    }
                    while (parentScope != null) {
                        if (parentScope instanceof ICompileUnitScope) {
                            ICompileUnitScope cuScope = (ICompileUnitScope)parentScope;
                            List<Object> cuScopes = null;
                            if (this.debugInfoProvider != null) {
                                cuScopes = this.debugInfoProvider.getCompileUnitsForFile(cuScope.getFilePath());
                            } else {
                                cuScopes = new ArrayList(1);
                                cuScopes.add(cuScope);
                            }
                            String cuFile = ((ICompileUnitScope)parentScope).getFilePath().toOSString();
                            for (ICompileUnitScope iCompileUnitScope : cuScopes) {
                                Collection<IVariable> globals = iCompileUnitScope.getVariables();
                                if (globals == null) continue;
                                for (IVariable variable : globals) {
                                    IPath varFile = variable.getDefiningFile();
                                    if (varFile != null && !varFile.toOSString().equalsIgnoreCase(cuFile)) continue;
                                    VariableDMC var = new VariableDMC(Stack.this, this, variable);
                                    String name = var.getName();
                                    VariableDMC haveLocal = this.localsByName.get(name);
                                    if (haveLocal != null) {
                                        this.localsByName.remove(name);
                                        this.locals.remove(haveLocal);
                                    }
                                    this.locals.add(var);
                                    this.localsByName.put(name, var);
                                }
                            }
                        }
                        parentScope = parentScope.getParent();
                    }
                    if (!(scope.getParent() instanceof IFunctionScope)) break;
                    scope = (IFunctionScope)scope.getParent();
                }
            }
            IStack.IVariableDMContext[] localsArray = new VariableDMC[(this.thisPtrs.isEmpty() ? 0 : 1) + this.locals.size()];
            int i = 0;
            if (!this.thisPtrs.isEmpty()) {
                localsArray[i++] = new VariableDMC(Stack.this, this, this.getOuterThis());
            }
            for (VariableDMC var : this.locals) {
                localsArray[i++] = var;
            }
            return localsArray;
        }

        private IVariable getOuterThis() {
            if (this.thisPtrs.isEmpty()) {
                return null;
            }
            if (this.thisPtrs.size() == 1) {
                return this.thisPtrs.values().iterator().next();
            }
            IVariable outer = null;
            for (IVariable variable : this.thisPtrs.values()) {
                if (outer == null) {
                    outer = variable;
                    continue;
                }
                IScope outerScope = outer.getScope();
                IScope variableScope = variable.getScope();
                if (variableScope.getLowAddress().compareTo((Object)outerScope.getLowAddress()) >= 0 && variableScope.getHighAddress().compareTo((Object)outerScope.getHighAddress()) <= 0) continue;
                outer = variable;
            }
            return outer;
        }

        public IVariableEnumeratorContext findVariableOrEnumeratorByName(String name, String qualifiedName, boolean localsOnly) {
            IVariableEnumeratorContext variableOrEnumerator;
            if (name == null) {
                return null;
            }
            if (this.locals == null) {
                this.getLocals();
            }
            if (qualifiedName != null && (variableOrEnumerator = (IVariableEnumeratorContext)this.localsByName.get(qualifiedName)) != null) {
                return variableOrEnumerator;
            }
            variableOrEnumerator = this.localsByName.get(name);
            if (variableOrEnumerator != null) {
                return variableOrEnumerator;
            }
            if (this.enumerators == null) {
                this.getEnumerators();
            }
            if (qualifiedName != null && (variableOrEnumerator = (IVariableEnumeratorContext)this.enumeratorsByName.get(qualifiedName)) != null) {
                return variableOrEnumerator;
            }
            variableOrEnumerator = this.enumeratorsByName.get(name);
            if (variableOrEnumerator != null) {
                return variableOrEnumerator;
            }
            if (name.equals("this")) {
                if (this.thisPtrs.isEmpty()) {
                    return null;
                }
                return new VariableDMC(Stack.this, this, this.getOuterThis());
            }
            if (localsOnly || this.getVariableScope() == null) {
                return null;
            }
            IScope variableScope = this.getVariableScope().getParent();
            ArrayList<IScope> scopes = new ArrayList<IScope>();
            block0: while (variableOrEnumerator == null && variableScope != null) {
                Object variable;
                if (variableScope instanceof IModuleScope) {
                    Collection<IVariable> variables = ((IModuleScope)variableScope).getVariablesByName(qualifiedName != null ? qualifiedName : name, true);
                    if (variables.size() <= 0) break;
                    for (IVariable varObject : variables) {
                        if (!(varObject instanceof IVariable) || !((variable = varObject).getScope() instanceof IModuleScope)) continue;
                        variableOrEnumerator = new VariableDMC(Stack.this, this, (IVariable)variable);
                        break block0;
                    }
                    break;
                }
                scopes.clear();
                if (variableScope instanceof ICompileUnitScope) {
                    IPath currentFile;
                    IScope parent = variableScope.getParent();
                    while (parent != null && !(parent instanceof IModuleScope)) {
                        parent = parent.getParent();
                    }
                    if (parent != null && (currentFile = ((ICompileUnitScope)variableScope).getFilePath()) != null) {
                        variable = ((IModuleScope)parent).getCompileUnitsForFile(currentFile).iterator();
                        while (variable.hasNext()) {
                            ICompileUnitScope cu = (ICompileUnitScope)variable.next();
                            scopes.add(cu);
                        }
                    }
                }
                if (scopes.isEmpty()) {
                    scopes.add(variableScope);
                }
                block4: for (IScope scope : scopes) {
                    variable = scope.getVariables().iterator();
                    while (variable.hasNext()) {
                        IVariable scopeVariable = (IVariable)variable.next();
                        String scopeVariableName = scopeVariable.getName();
                        if (qualifiedName != null && scopeVariableName.equals(qualifiedName)) {
                            variableOrEnumerator = new VariableDMC(Stack.this, this, scopeVariable);
                            break;
                        }
                        if (!scopeVariableName.equals(name)) continue;
                        variableOrEnumerator = new VariableDMC(Stack.this, this, scopeVariable);
                        break;
                    }
                    if (variableOrEnumerator == null && scope instanceof IFunctionScope) {
                        IFunctionScope functionScope = (IFunctionScope)scope;
                        for (IVariable scopeVariable : functionScope.getParameters()) {
                            String scopeVariableName = scopeVariable.getName();
                            if (qualifiedName != null && scopeVariableName.equals(qualifiedName)) {
                                variableOrEnumerator = new VariableDMC(Stack.this, this, scopeVariable);
                                break;
                            }
                            if (!scopeVariableName.equals(name)) continue;
                            variableOrEnumerator = new VariableDMC(Stack.this, this, scopeVariable);
                            break;
                        }
                    }
                    if (variableOrEnumerator != null) continue;
                    for (IEnumerator scopeEnumerator : scope.getEnumerators()) {
                        String scopeEnumeratorName = scopeEnumerator.getName();
                        if (qualifiedName != null && scopeEnumeratorName.equals(qualifiedName)) {
                            variableOrEnumerator = new EnumeratorDMC(this, scopeEnumerator);
                            continue block4;
                        }
                        if (!scopeEnumeratorName.equals(name)) continue;
                        variableOrEnumerator = new EnumeratorDMC(this, scopeEnumerator);
                        continue block4;
                    }
                }
                variableScope = variableScope.getParent();
            }
            return variableOrEnumerator;
        }

        public IScope getVariableScope() {
            return this.variableScope;
        }

        public EnumeratorDMC[] getEnumerators() {
            if (this.enumerators == null) {
                this.enumerators = new ArrayList<EnumeratorDMC>();
                if (Stack.this.getServicesTracker() != null) {
                    IEDCSymbols symbolsService = Stack.this.getService(Symbols.class);
                    if (this.executionDMC != null && symbolsService != null) {
                        IFunctionScope scope = symbolsService.getFunctionAtAddress(this.executionDMC.getSymbolDMContext(), this.instructionPtrAddress);
                        while (scope != null) {
                            Collection<IEnumerator> localEnumerators = scope.getEnumerators();
                            for (IEnumerator enumerator : localEnumerators) {
                                EnumeratorDMC enumeratorDMC = new EnumeratorDMC(this, enumerator);
                                this.enumerators.add(enumeratorDMC);
                                this.enumeratorsByName.put(enumerator.getName(), enumeratorDMC);
                            }
                            if (!(scope.getParent() instanceof IFunctionScope)) break;
                            scope = (IFunctionScope)scope.getParent();
                        }
                    }
                }
            }
            return this.enumerators.toArray(new EnumeratorDMC[this.enumerators.size()]);
        }

        public EnumeratorDMC findEnumeratorbyName(String name) {
            if (this.enumerators == null) {
                this.getEnumerators();
            }
            return this.enumeratorsByName.get(name);
        }

        public IFrameRegisters getFrameRegisters() {
            if (this.frameRegisters == null) {
                if (this.level == 0) {
                    Registers registers = this.getEDCServicesTracker().getService(Registers.class);
                    this.frameRegisters = new CurrentFrameRegisters(this.executionDMC, registers);
                } else {
                    Map preservedRegisters;
                    Symbols symbolsService;
                    IFrameRegisterProvider frameRegisterProvider;
                    if (this.module != null && (frameRegisterProvider = (symbolsService = Stack.this.getService(Symbols.class)).getFrameRegisterProvider(this.executionDMC.getSymbolDMContext(), this.instructionPtrAddress)) != null) {
                        try {
                            this.frameRegisters = frameRegisterProvider.getFrameRegisters(Stack.this.getSession(), this.getEDCServicesTracker(), this);
                        }
                        catch (CoreException e) {
                            this.frameRegisters = new AlwaysFailingFrameRegisters(e);
                        }
                    }
                    if (this.frameRegisters == null && (preservedRegisters = (Map)this.properties.get(PRESERVED_REGISTERS)) != null) {
                        this.frameRegisters = new PreservedFrameRegisters(this.dsfServicesTracker, this, preservedRegisters);
                    }
                    if (this.frameRegisters == null) {
                        this.frameRegisters = new AlwaysFailingFrameRegisters(EDCDebugger.newCoreException("cannot read variables in this frame"));
                    }
                }
            }
            return this.frameRegisters;
        }

        public StackFrameDMC getCalledFrame() throws CoreException {
            return this.calledFrame;
        }

        public TypeEngine getTypeEngine() {
            return this.typeEngine;
        }

        public IEDCModuleDMContext getModule() {
            return this.module;
        }

        private Stack getOuterType() {
            return Stack.this;
        }
    }

    public static class StackFrameData
    implements IStack.IFrameDMData {
        public final IAddress address;
        public final int level;
        public final String function;
        public final String module;
        private final String file;
        private final int lineNumber;

        StackFrameData(StackFrameDMC dmc) {
            this.level = dmc.getLevel();
            this.address = dmc.getInstructionPtrAddress();
            this.module = dmc.getModuleName();
            this.file = dmc.getSourceFile();
            this.lineNumber = dmc.getLineNumber();
            this.function = dmc.getFunctionName();
        }

        public IAddress getAddress() {
            return this.address;
        }

        public String getFunction() {
            return this.function;
        }

        public int getLevel() {
            return this.level;
        }

        public String getFile() {
            return this.file;
        }

        public int getLine() {
            return this.lineNumber;
        }

        public int getColumn() {
            return 0;
        }

        public String getModule() {
            return this.module;
        }

        public boolean equals(Object other) {
            return this == other || other != null && other instanceof StackFrameData && this.getAddress().equals((Object)((StackFrameData)other).getAddress()) && this.getFunction().equals(((StackFrameData)other).getFunction()) && this.getLevel() == ((StackFrameData)other).getLevel() && this.getFile().equals(((StackFrameData)other).getFile()) && this.getLine() == ((StackFrameData)other).getLine() && this.getColumn() == ((StackFrameData)other).getColumn() && this.getModule().equals(((StackFrameData)other).getModule());
        }
    }

    public class VariableDMC
    extends DMContext
    implements IStack.IVariableDMContext,
    IVariableEnumeratorContext {
        public static final String PROP_LOCATION = "Location";
        private final IVariable variable;

        public VariableDMC(IDsfService service, StackFrameDMC frame, IVariable variable) {
            super((IDsfService)Stack.this, new IDMContext[]{frame}, variable.getName(), variable.getName());
            this.variable = variable;
        }

        public IVariable getVariable() {
            return this.variable;
        }
    }

    public class VariableData
    implements IStack.IVariableDMData {
        private final String name;

        public VariableData(VariableDMC variableDMC) {
            this.name = variableDMC.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return "0";
        }
    }
}

