/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.logparser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.control.DataThread;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.swap.model.data.LSanData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryMapData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessAddInfoData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessInfoData;
import org.tizen.dynamicanalyzer.ui.memory.data.LsanDataManager;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class MessageParser
extends DataThread<LogData> {
    private static MessageParser instance = new MessageParser();
    private static final int MSG_BUFFER_MAX = 5000;
    private static final int MSG_BUFFER_TIMER_DELAY = 5;
    private static final int MSG_BUFFER_TIMER_PERIOD = 1000;
    private Lock lock = new ReentrantLock();
    private List<LogData> sendBuffer = null;
    private Timer timer = null;

    public static MessageParser getInstance() {
        return instance;
    }

    @Override
    protected String getThreadName() {
        return "Message parsing thread";
    }

    @Override
    protected boolean workAfterStart() {
        return true;
    }

    @Override
    protected boolean workAfterStopNormal() {
        return true;
    }

    @Override
    protected boolean workAfterStopForced() {
        return true;
    }

    @Override
    protected void resetBeforeStart() {
        this.stopTimer();
        this.sendBuffer = new ArrayList<LogData>();
    }

    @Override
    protected void clearAfterStop() {
        this.stopTimer();
        this.sendBuffer = null;
    }

    private void startTimer() {
        this.timer = new Timer("Hand over data timer");
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!MessageParser.this.sendBuffer.isEmpty()) {
                    MessageParser.this.sendDataToLogParser();
                }
            }
        }, 5L, 1000L);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void sendDataToLogParser() {
        this.lock.lock();
        try {
            if (this.sendBuffer != null && this.sendBuffer.size() != 0) {
                LogParser.getInstance().pushData(this.sendBuffer);
            }
            this.sendBuffer = new ArrayList<LogData>();
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean pushEOQ() {
        return LogParser.getInstance().pushData(LogParser.END_OF_QUEUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DebugLog.openDataChannelWriter();
        Thread curThread = Thread.currentThread();
        try {
            Object object = AnalyzerManager.waitStartAck;
            synchronized (object) {
                try {
                    while (Global.getProject().getProfilingStartTime() == null) {
                        AnalyzerManager.waitStartAck.wait();
                    }
                }
                catch (InterruptedException e) {
                    Logger.debug((Object)("Interrupted while waiting for trace start aknowledge message: " + e.getLocalizedMessage()));
                    Thread.currentThread().interrupt();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.stopTimer();
                    this.sendDataToLogParser();
                    this.pushEOQ();
                    DebugLog.closeDataChannelWriter();
                    return;
                }
            }
            this.startTimer();
            while (this.testThread(curThread)) {
                LogData log = (LogData)this.pollData();
                if (log == null) return;
                if (log == LogData.END_OF_QUEUE) {
                    return;
                }
                this.processMessage(log);
            }
            return;
        }
        finally {
            this.stopTimer();
            this.sendDataToLogParser();
            this.pushEOQ();
            DebugLog.closeDataChannelWriter();
        }
    }

    private boolean processMessage(LogData log) {
        boolean bret = log.parsePublic(Global.getProject().getProfilingStartTime());
        if (!bret) {
            return bret;
        }
        int msgID = log.getMsgID();
        switch (msgID) {
            case 1: {
                this.processProcessInfo(log);
                break;
            }
            case 18: 
            case 19: {
                try {
                    this.memoryMapChanged(log);
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                this.processTerminate();
                break;
            }
            case 3: {
                break;
            }
            case 20: {
                this.processAddInfo(log);
                break;
            }
            case 6: {
                break;
            }
            case 34: {
                AnalyzerUtil.getLSanLock().lock();
                try {
                    this.processLSanMessage(log);
                    break;
                }
                finally {
                    AnalyzerUtil.getLSanLock().unlock();
                }
            }
            default: {
                if (msgID != 0) {
                    if (!AnalyzerManager.isProcessInfoArrived()) break;
                    this.sendBuffer.add(log);
                    break;
                }
                bret = false;
            }
        }
        if (5000 <= this.sendBuffer.size()) {
            this.sendDataToLogParser();
        }
        return bret;
    }

    private void processLSanMessage(LogData log) {
        LSanData data = (LSanData)log;
        switch (data.getStatus()) {
            case INITIALIZED: {
                if (Global.isLSanInitialized()) {
                    Logger.warning((Object)"LeakSanitizer is already initialized");
                    return;
                }
                Global.setLSanInitialized(true);
                break;
            }
            case REPORT: {
                AnalyzerUtil.getLSanCondition().signal();
                if (!Global.isLSanInitialized()) {
                    Logger.error((Object)"LeakSanitizer is not initialized");
                    return;
                }
                Global.setLSanInitialized(false);
                String source = data.getData();
                if (source.isEmpty()) {
                    Logger.warning((Object)"Empty LeakSanitizer report file path: nothing to parse");
                    return;
                }
                int index = source.lastIndexOf(47) + 1;
                String destination = index > 0 && index < source.length() ? String.valueOf(PathManager.DA_TEMP_FOLDER_PATH) + File.separator + source.substring(index) : String.valueOf(PathManager.DA_TEMP_FOLDER_PATH) + File.separator + source;
                DAResult result = DACommunicator.pullFromCurrentDevice(source, destination);
                if (!result.isSuccess()) {
                    Logger.error((Object)("Failed to pull LeakSanitizer report file: " + source));
                    return;
                }
                Logger.debug((Object)("Pulled LeakSanitizer report file: " + source));
                LsanDataManager.getInstance().parseLSanReportFile(destination);
                break;
            }
            case ERROR: {
                Logger.error((Object)("LeakSanitizer has exited with error: " + data.getData()));
            }
        }
    }

    private void processProcessInfo(LogData plog) {
        Project project = Global.getProject();
        ProcessInfoData log = (ProcessInfoData)plog;
        int pid = log.getPid();
        long starttime = log.getStartTime();
        ProcessInformation pinfo = project.getProcessInformation(pid);
        if (pinfo == null) {
            pinfo = new ProcessInformation();
            int ppid = log.getPpid();
            pinfo.setPid(pid);
            pinfo.setPpid(ppid);
            pinfo.setStartTime(starttime);
            pinfo.setProcessName(log.getCmdname());
            project.putProcessInformation(pinfo);
            pinfo.setDropLog(true);
        }
        ProcessMemoryMap pMap = new ProcessMemoryMap(pinfo.getPid(), starttime);
        pinfo.addProcessMemoryMap(pMap);
        List<LibraryObject> libObjects = log.getLibObjects();
        int dependentLibCount = libObjects.size();
        int i = 0;
        while (i < dependentLibCount) {
            pMap.addLibraryMap(libObjects.get(i));
            ++i;
        }
        pMap.setMainBinary(new LibraryObject(project.getDeviceStatusInfo().getBinaryInfo(log.getBinaryPath()).getID(), log.getLowAddr(), log.getHighAddr()));
        AnalyzerManager.setProcessInfoArrived(true);
        ThreadDataManager.getInstance().getThreadDataMaker().createMainThreadItem(pid);
    }

    private void memoryMapChanged(LogData plog) {
        MemoryMapData log;
        int pid;
        Project project = Global.getProject();
        ProcessInformation pinfo = project.getProcessInformation(pid = (log = (MemoryMapData)plog).getPid());
        if (pinfo == null) {
            Logger.error((Object)"Memory map changed before process memory info arrived.");
            return;
        }
        ProcessMemoryMap lastMap = pinfo.getLastProcessMemoryMap();
        int msgID = log.getMsgID();
        long lowAddr = log.getLowAddr();
        long highAddr = log.getHighAddr();
        ProcessMemoryMap newMap = new ProcessMemoryMap(pinfo.getPid(), log.getTime());
        newMap.copy(lastMap);
        if (msgID == 18) {
            String libPath = log.getLibPath();
            BinaryInfo bininfo = project.getDeviceStatusInfo().getBinaryInfo(libPath);
            LibraryObject libObj = new LibraryObject(bininfo.getID(), lowAddr, highAddr);
            if (!newMap.addLibraryMap(libObj)) {
                Logger.error((String)"library mapping overlap (%d, %d, %s)", (Object[])new Object[]{lowAddr, highAddr, libPath});
            } else {
                pinfo.addProcessMemoryMap(newMap);
                Logger.debug((String)"map library (%d, %d, %s)", (Object[])new Object[]{lowAddr, highAddr, libPath});
            }
        } else if (!newMap.removeMapping(lowAddr, highAddr)) {
            Logger.info((String)"nothing to unmap in range (%d, %d)", (Object[])new Object[]{lowAddr, highAddr});
        } else {
            pinfo.addProcessMemoryMap(newMap);
            Logger.debug((String)"unmapped memory map (%d, %d)", (Object[])new Object[]{lowAddr, highAddr});
        }
    }

    private void processAddInfo(LogData plog) {
        ProcessAddInfoData log;
        int pid;
        Project project = Global.getProject();
        ProcessInformation process = project.getProcessInformation(pid = (log = (ProcessAddInfoData)plog).getPid());
        if (process != null) {
            process.setProcessName(log.getCmdname());
        }
    }

    private void processTerminate() {
    }
}

