/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.util.Arrays;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDataManager;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupTable;
import org.tizen.dynamicanalyzer.ui.info.appStartup.WebAppStartupTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAHidableViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class AppStartupView
extends DAHidableViewComposite {
    private String[] observingViews = null;
    private StackLayout stackLayout;
    private AppStartupTable nativeTable = null;
    private WebAppStartupTable webTable = null;

    public AppStartupView(Composite parent, int style) {
        super(parent, style, false, "");
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InformationViewLabels.APP_STARTUP_VIEW_TITLE);
        this.stackLayout = new StackLayout();
        Composite dataComp = new Composite(this.getContentArea(), 0);
        dataComp.setLayout((Layout)this.stackLayout);
        this.setDataComposite(dataComp);
        this.nativeTable = new AppStartupTable(dataComp, 0, 2818);
        this.webTable = new WebAppStartupTable(dataComp, 0, 2818);
        if (!this.hideIfNotSupported()) {
            Project currentProject = Global.getProject();
            if (currentProject == null) {
                this.stackLayout.topControl = this.nativeTable;
            } else {
                this.changeTable(currentProject.isWebApplication());
            }
            DataManagerRegistry.registerPageDataManager(AppStartupDataManager.getInstance());
        }
    }

    public void setObservingViews(String[] viewIDs) {
        this.observingViews = viewIDs;
    }

    public String[] getObservingViews() {
        return this.observingViews;
    }

    public void changeTable(boolean isWeb) {
        if (this.hideIfNotSupported()) {
            return;
        }
        this.stackLayout.topControl = isWeb ? this.webTable : this.nativeTable;
        this.getContentArea().layout();
    }

    public void updateView() {
        if (this.hideIfNotSupported()) {
            return;
        }
        if (this.stackLayout.topControl instanceof DATableComposite) {
            ((DATableComposite)this.stackLayout.topControl).updateTable();
        }
    }

    public void updateView(DAViewData data) {
        if (this.hideIfNotSupported()) {
            return;
        }
        if (this.stackLayout.topControl instanceof DATableComposite) {
            ((DATableComposite)this.stackLayout.topControl).deselectAll();
        }
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            if (this.stackLayout.topControl == this.nativeTable) {
                this.nativeTable.setSelectionByTime(start, end);
            } else {
                this.webTable.setSelectionByTime(start, end);
            }
            this.updateView();
        }
    }

    private boolean hideIfNotSupported() {
        boolean hide = true;
        if (this.isUIHVSelected()) {
            this.setLabelText(TimelinePageLabels.APPSTARTUP_NOT_SUPPORTED_LABEL_UIHV);
        } else if (this.isNotSupportedProtocol()) {
            this.setLabelText(TimelinePageLabels.APPSTARTUP_NOT_SUPPORTED_LABEL_TARGET);
        } else {
            hide = false;
        }
        this.hide(hide);
        return hide;
    }

    private boolean isUIHVSelected() {
        Project curProject = Global.getProject();
        if (curProject != null && curProject.getPageTabList() != null) {
            return Arrays.asList(curProject.getPageTabList()).contains(SettingConstants.PAGE_NAME_HIERARCHY);
        }
        return SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.UI_HIERARCHY_ANALYSIS);
    }

    private boolean isNotSupportedProtocol() {
        Protocol usedProtocol = Global.getCurrentProtocol();
        return usedProtocol != null && usedProtocol != Protocol.VERSION_UNKNOWN && usedProtocol.getVersionNum() < Protocol.VERSION_41.getVersionNum();
    }

    public void clear() {
        this.nativeTable.clear();
        this.webTable.clear();
        this.hideIfNotSupported();
    }

    public Control getControl() {
        return this.stackLayout.topControl;
    }
}

