/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.NumberFormatUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.util.TCFTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class Registers
extends AbstractEDCService
implements org.eclipse.cdt.dsf.debug.service.IRegisters,
ICachingService,
IDSFServiceUsingTCF {
    private Map<String, List<RegisterGroupDMC>> registerGroupsPerContext = Collections.synchronizedMap(new HashMap());
    protected IRegisters tcfRegistersService = null;
    private Map<String, Map<String, BigInteger>> registerValueCache = Collections.synchronizedMap(new HashMap());
    private long tcfTimeout;
    protected static final String REGISTER_VALUE_ERROR = "badbadba";
    public static final String PROP_EXECUTION_CONTEXT_ID = "Context_ID";
    private static final String REGISTER = "register";

    public Registers(DsfSession session, String[] classNames) {
        super(session, Registers.massageClassNames(classNames, new String[]{org.eclipse.cdt.dsf.debug.service.IRegisters.class.getName(), Registers.class.getName()}));
        this.setTCFTimeout(15000L);
    }

    public RegisterDMC findRegisterDMCByName(IEDCExecutionDMC exeDMC, String name) throws CoreException {
        IRegisters.IRegisterGroupDMContext[] regGroups;
        assert (RunControl.isNonContainer((IDMContext)exeDMC));
        IRegisters.IRegisterGroupDMContext[] iRegisterGroupDMContextArray = regGroups = this.getGroupsForContext(exeDMC);
        int n = regGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisters.IRegisterGroupDMContext g = iRegisterGroupDMContextArray[n2];
            RegisterDMC[] registerDMCArray = ((RegisterGroupDMC)g).getRegisters();
            int n3 = registerDMCArray.length;
            int n4 = 0;
            while (n4 < n3) {
                RegisterDMC reg = registerDMCArray[n4];
                String n5 = (String)reg.getProperties().get("Name");
                if (name.equals(n5)) {
                    return reg;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.getSession().addServiceEventListener((Object)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegisters.IRegisterGroupDMContext[] getGroupsForContext(IEDCExecutionDMC executableContext) throws CoreException {
        String contextID = executableContext.getID();
        List<RegisterGroupDMC> groupsForContext = this.registerGroupsPerContext.get(contextID);
        if (groupsForContext == null) {
            groupsForContext = this.createGroupsForContext(executableContext);
            Map<String, List<RegisterGroupDMC>> map = this.registerGroupsPerContext;
            synchronized (map) {
                this.registerGroupsPerContext.put(contextID, groupsForContext);
            }
        }
        return groupsForContext.toArray(new IRegisters.IRegisterGroupDMContext[groupsForContext.size()]);
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, String bitFieldValue, String formatId, RequestMonitor rm) {
        rm.done();
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, IRegisters.IMnemonic mnemonic, RequestMonitor rm) {
        rm.done();
    }

    public void writeRegister(IEDCExecutionDMC context, String regID, String regValue) throws CoreException {
        RegisterDMC regDMC = this.findRegisterDMCByName(context, regID);
        assert (regDMC != null);
        this.writeRegister(regDMC, regValue, "HEX.Format", new RequestMonitor((Executor)this.getExecutor(), null));
    }

    public void writeRegister(IRegisters.IRegisterDMContext regCtx, String regValue, String formatID) throws CoreException {
        Map<String, BigInteger> exeDMCRegisters;
        assert (regCtx instanceof RegisterDMC);
        final RegisterDMC regDMC = (RegisterDMC)regCtx;
        IRunControl.IExecutionDMContext exeDMC = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)regDMC, IRunControl.IExecutionDMContext.class);
        if (exeDMC == null || !(exeDMC instanceof IEDCDMContext)) {
            throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "No valid execution context for finding the register ID"));
        }
        String exeDMCID = ((IEDCDMContext)exeDMC).getID();
        if (formatID.equals("OCTAL.Format") || formatID.equals("BINARY.Format") || formatID.equals("DECIMAL.Format")) {
            BigInteger bigRegValue = null;
            try {
                bigRegValue = NumberFormatUtils.parseIntegerByFormat(regValue, formatID);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Cannot change register to invalid value \"" + regValue + "\""));
            }
            regValue = Long.toHexString(bigRegValue.longValue());
        }
        if (this.tcfRegistersService != null) {
            int regSize = regDMC.getTCFContext().getSize();
            if (regValue.length() > regSize * 2) {
                regValue = regValue.substring(regValue.length() - regSize * 2);
            }
        }
        if (this.tcfRegistersService != null) {
            final IRegisters.RegistersContext tcfReg = regDMC.getTCFContext();
            byte[] bv = null;
            try {
                bv = MemoryUtils.convertHexStringToByteArray(regValue, tcfReg.getSize(), 2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Cannot change register to invalid value \"" + regValue + "\""));
            }
            final byte[] byteVal = bv;
            TCFTask<Object> tcfTask = new TCFTask<Object>(){

                public void run() {
                    tcfReg.set(byteVal, new IRegisters.DoneSet(){

                        public void doneSet(IToken token, Exception error) {
                            if (error == null) {
                                Registers.this.generateRegisterChangedEvent(regDMC);
                                this.done(null);
                            } else {
                                this.done(new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error writing register.", (Throwable)error));
                            }
                        }
                    });
                }
            };
            try {
                Object result = tcfTask.get(this.getTCFTimeout(), TimeUnit.MILLISECONDS);
                if (result != null && result instanceof IStatus) {
                    throw new CoreException((IStatus)result);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error writing register.", (Throwable)e));
            }
        }
        if ((exeDMCRegisters = this.registerValueCache.get(exeDMCID)) != null) {
            exeDMCRegisters.put(regDMC.getID(), new BigInteger(regValue, 16));
        }
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"HEX.Format", "DECIMAL.Format", "OCTAL.Format", "BINARY.Format", "NATURAL.Format"});
        rm.done();
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        if (dmc.getParents().length == 1 && dmc.getParents()[0] instanceof RegisterDMC) {
            this.getRegisterDataValue((RegisterDMC)dmc.getParents()[0], dmc.getFormatID(), rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public String getRegisterValue(IRunControl.IExecutionDMContext context, String id) throws CoreException {
        RegisterDMC regDMC = this.findRegisterDMCByName((IEDCExecutionDMC)context, id);
        assert (regDMC != null);
        return this.getRegisterValueAsHexString(regDMC);
    }

    public String getRegisterValueAsHexString(RegisterDMC registerDMC) throws CoreException {
        return this.getRegisterValue(registerDMC).toString(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getRegisterValue(RegisterDMC registerDMC) throws CoreException {
        IRunControl.IExecutionDMContext exeDMC = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)registerDMC, IRunControl.IExecutionDMContext.class);
        if (exeDMC == null || !(exeDMC instanceof IEDCDMContext)) {
            throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "No valid executionDMC for the register."));
        }
        String exeDMCID = ((IEDCDMContext)exeDMC).getID();
        String registerDMCID = registerDMC.getID();
        Map<String, Map<String, BigInteger>> map = this.registerValueCache;
        synchronized (map) {
            BigInteger cachedValue;
            Map<String, BigInteger> exeDMCRegisters = this.registerValueCache.get(exeDMCID);
            if (exeDMCRegisters != null && (cachedValue = exeDMCRegisters.get(registerDMC.getID())) != null) {
                return cachedValue;
            }
        }
        if (this.tcfRegistersService != null) {
            final IRegisters.RegistersContext tcfReg = registerDMC.getTCFContext();
            if (tcfReg == null) {
                throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "RegisterDMC " + registerDMC.getID() + " has no underlying TCF register context."));
            }
            TCFTask<byte[]> tcfTask = new TCFTask<byte[]>(){

                public void run() {
                    tcfReg.get(new IRegisters.DoneGet(){

                        public void doneGet(IToken token, Exception error, byte[] value) {
                            this.done(value);
                        }
                    });
                }
            };
            try {
                byte[] value = (byte[])tcfTask.get(this.getTCFTimeout(), TimeUnit.MILLISECONDS);
                String strVal = MemoryUtils.convertByteArrayToHexString(value);
                BigInteger biValue = new BigInteger(strVal, 16);
                Map<String, Map<String, BigInteger>> map2 = this.registerValueCache;
                synchronized (map2) {
                    Map<String, BigInteger> exeDMCRegisters = this.registerValueCache.get(exeDMCID);
                    if (exeDMCRegisters == null) {
                        exeDMCRegisters = new HashMap<String, BigInteger>();
                        this.registerValueCache.put(exeDMCID, exeDMCRegisters);
                    }
                    exeDMCRegisters.put(registerDMCID, biValue);
                }
                return biValue;
            }
            catch (Throwable e) {
                throw new CoreException(EDCDebugger.dsfRequestFailedStatus("Exception reading register " + registerDMC.getName(), e));
            }
        }
        throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "No data for register " + registerDMC.getName()));
    }

    private void generateRegisterChangedEvent(IRegisters.IRegisterDMContext dmc) {
        this.getSession().dispatchEvent((Object)new RegisterChangedDMEvent(dmc), this.getProperties());
        RegisterDMC regdmc = (RegisterDMC)dmc;
        if (regdmc.getName().equals(this.getTargetEnvironmentService().getPCRegisterID())) {
            IRunControl.IExecutionDMContext exeDMC = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IExecutionDMContext.class);
            this.getSession().dispatchEvent((Object)new RunControl.SuspendedEvent(exeDMC, IRunControl.StateChangeReason.USER_REQUEST, new HashMap<String, Object>()), this.getProperties());
        }
    }

    private void getRegisterDataValue(RegisterDMC registerDMC, String formatID, DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        try {
            BigInteger bigIntValue = this.getRegisterValue(registerDMC);
            String formattedValue = bigIntValue.toString(16);
            if (formatID.equals("OCTAL.Format")) {
                formattedValue = NumberFormatUtils.toOctalString(bigIntValue);
            }
            if (formatID.equals("BINARY.Format")) {
                formattedValue = NumberFormatUtils.asBinary(bigIntValue);
            }
            if (formatID.equals("DECIMAL.Format")) {
                formattedValue = bigIntValue.toString();
            }
            rm.setData((Object)new IFormattedValues.FormattedValueDMData(formattedValue));
        }
        catch (CoreException e) {
            Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), "Error in getRegisterDataValue.", (Throwable)e);
            EDCDebugger.getMessageLogger().log((IStatus)s);
            rm.setStatus((IStatus)s);
        }
        rm.done();
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        if (dmc instanceof RegisterDMC) {
            return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)dmc, formatId);
        }
        return null;
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof RegisterGroupDMC) {
            this.getRegisterGroupData((IRegisters.IRegisterGroupDMContext)dmc, rm);
        } else if (dmc instanceof RegisterDMC) {
            this.getRegisterData((IRegisters.IRegisterDMContext)dmc, rm);
        } else if (dmc instanceof IFormattedValues.FormattedValueDMContext) {
            this.getFormattedExpressionValue((IFormattedValues.FormattedValueDMContext)dmc, rm);
        } else {
            rm.done();
        }
    }

    public void flushCache(IDMContext context) {
        if (this.isSnapshot()) {
            return;
        }
        this.registerValueCache.clear();
    }

    public void loadGroupsForContext(IEDCExecutionDMC executionDmc, Element element) throws Exception {
        String cxtID = executionDmc.getID();
        this.registerGroupsPerContext.remove(cxtID);
        this.registerValueCache.remove(cxtID);
        NodeList registerGroups = element.getElementsByTagName("register_group");
        List<RegisterGroupDMC> regGroups = Collections.synchronizedList(new ArrayList());
        int numGroups = registerGroups.getLength();
        int i = 0;
        while (i < numGroups) {
            Element groupElement = (Element)registerGroups.item(i);
            Element propElement = (Element)groupElement.getElementsByTagName("properties").item(0);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            SnapshotUtils.initializeFromXML(propElement, properties);
            RegisterGroupDMC regdmc = new RegisterGroupDMC(this, executionDmc, properties);
            regdmc.loadSnapshot(groupElement);
            regGroups.add(regdmc);
            ++i;
        }
        this.registerGroupsPerContext.put(executionDmc.getID(), regGroups);
    }

    @Override
    public void tcfServiceReady(IService service) {
        this.tcfRegistersService = (IRegisters)service;
    }

    public String getRegisterValue(IEDCExecutionDMC executionDMC, int id) throws CoreException {
        String name = this.getRegisterNameFromCommonID(id);
        if (name != null) {
            return this.getRegisterValue((IRunControl.IExecutionDMContext)executionDMC, name);
        }
        return null;
    }

    protected List<IRegisters.RegistersContext> getTCFRegistersContexts(final String parentID) throws CoreException {
        String[] childIDs;
        ArrayList<IRegisters.RegistersContext> tcfRegContexts = new ArrayList<IRegisters.RegistersContext>();
        TCFTask<String[]> getChildIDTask = new TCFTask<String[]>(){

            public void run() {
                Registers.this.tcfRegistersService.getChildren(parentID, new IRegisters.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contextIds) {
                        if (error == null) {
                            this.done(contextIds);
                        } else {
                            this.error(error);
                        }
                    }
                });
            }
        };
        try {
            childIDs = (String[])getChildIDTask.get(this.getTCFTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new CoreException(EDCDebugger.dsfRequestFailedStatus("Fail to get TCF context for: " + parentID, e));
        }
        String[] stringArray = childIDs;
        int n = childIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String gid;
            final String id = gid = stringArray[n2];
            TCFTask<IRegisters.RegistersContext> getGroupContextTask = new TCFTask<IRegisters.RegistersContext>(){

                public void run() {
                    Registers.this.tcfRegistersService.getContext(id, new IRegisters.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                            if (error == null) {
                                this.done(context);
                            } else {
                                this.error(error);
                            }
                        }
                    });
                }
            };
            IRegisters.RegistersContext rgc = null;
            try {
                rgc = (IRegisters.RegistersContext)getGroupContextTask.get(this.getTCFTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                throw new CoreException(EDCDebugger.dsfRequestFailedStatus("Fail to get TCF context for: " + parentID, e));
            }
            if (rgc != null) {
                tcfRegContexts.add(rgc);
            }
            ++n2;
        }
        return tcfRegContexts;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.flushCache(null);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.flushCache(null);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        IRunControl.IExecutionDMContext cxt = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (cxt != null && cxt instanceof IEDCDMContext) {
            String cxtID = ((IEDCDMContext)cxt).getID();
            this.registerGroupsPerContext.remove(cxtID);
            this.registerValueCache.remove(cxtID);
        }
    }

    protected List<RegisterDMC> createRegistersForGroup(RegisterGroupDMC registerGroupDMC) throws CoreException {
        ArrayList<RegisterDMC> registers = new ArrayList<RegisterDMC>();
        if (this.tcfRegistersService != null) {
            List<IRegisters.RegistersContext> tcfRegs = this.getTCFRegistersContexts(registerGroupDMC.getID());
            for (IRegisters.RegistersContext rg : tcfRegs) {
                registers.add(new RegisterDMC(registerGroupDMC, registerGroupDMC.getExecutionDMC(), rg));
            }
        }
        return registers;
    }

    protected List<RegisterGroupDMC> createGroupsForContext(IEDCExecutionDMC ctx) throws CoreException {
        List<RegisterGroupDMC> groups = Collections.synchronizedList(new ArrayList());
        if (RunControl.isNonContainer((IDMContext)ctx) && this.tcfRegistersService != null) {
            List<IRegisters.RegistersContext> tcfRegGroups = this.getTCFRegistersContexts(ctx.getID());
            for (IRegisters.RegistersContext rg : tcfRegGroups) {
                groups.add(new RegisterGroupDMC(this, ctx, (Map<String, Object>)rg.getProperties()));
            }
        }
        return groups;
    }

    public abstract String getRegisterNameFromCommonID(int var1);

    public void setTCFTimeout(long msecs) {
        this.tcfTimeout = msecs;
    }

    public long getTCFTimeout() {
        return this.tcfTimeout;
    }

    public void getRegisterGroups(final IDMContext ctx, final DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IEDCExecutionDMC execDmc = (IEDCExecutionDMC)DMContexts.getAncestorOfType((IDMContext)ctx, IEDCExecutionDMC.class);
                if (execDmc != null && RunControl.isNonContainer((IDMContext)execDmc)) {
                    try {
                        rm.setData((Object)Registers.this.getGroupsForContext(execDmc));
                    }
                    catch (CoreException e) {
                        EDCDebugger.getMessageLogger().log(e.getStatus());
                        rm.setStatus(e.getStatus());
                    }
                    rm.done();
                    return;
                }
                Stack.StackFrameDMC frameDmc = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)ctx, Stack.StackFrameDMC.class);
                if (frameDmc != null) {
                    try {
                        rm.setData((Object)Registers.this.getGroupsForContext(frameDmc.getExecutionDMC()));
                    }
                    catch (CoreException e) {
                        EDCDebugger.getMessageLogger().log(e.getStatus());
                        rm.setStatus(e.getStatus());
                    }
                    rm.done();
                    return;
                }
                rm.setData((Object)new IRegisters.IRegisterGroupDMContext[0]);
                rm.done();
            }
        }, (RequestMonitor)rm);
    }

    public void getRegisters(final IDMContext ctx, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                RegisterGroupDMC groupContext = (RegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)ctx, RegisterGroupDMC.class);
                IEDCExecutionDMC executionContext = (IEDCExecutionDMC)DMContexts.getAncestorOfType((IDMContext)ctx, IEDCExecutionDMC.class);
                try {
                    RegisterDMC[] allRegisters = groupContext != null && executionContext != null ? groupContext.getRegisters() : new RegisterDMC[]{};
                    rm.setData((Object)allRegisters);
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().log(e.getStatus());
                    rm.setStatus(e.getStatus());
                }
                rm.done();
            }
        }, (RequestMonitor)rm);
    }

    public void getBitFields(IDMContext ctx, DataRequestMonitor<IRegisters.IBitFieldDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "BitField not supported", null));
        rm.done();
    }

    public void findRegisterGroup(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterGroupDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "findRegisterGroup not supported", null));
        rm.done();
    }

    public void findRegister(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "findRegister not supported", null));
        rm.done();
    }

    public void findBitField(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IBitFieldDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "findBitField not supported", null));
        rm.done();
    }

    public void getRegisterGroupData(IRegisters.IRegisterGroupDMContext dmc, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
        class RegisterGroupData
        implements IRegisters.IRegisterGroupDMData {
            private final String name;
            private final String description;

            public RegisterGroupData(RegisterGroupDMC dmc) {
                this.name = dmc.getName();
                this.description = (String)dmc.getProperty("Description");
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }
        }
        rm.setData((Object)new RegisterGroupData((RegisterGroupDMC)dmc));
        rm.done();
    }

    public void getRegisterData(IRegisters.IRegisterDMContext dmc, DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
        RegisterDMC regdmc = (RegisterDMC)dmc;
        rm.setData((Object)new RegisterData(regdmc.getProperties()));
        rm.done();
    }

    public void getBitFieldData(IRegisters.IBitFieldDMContext dmc, DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Bit fields not yet supported", null));
        rm.done();
    }

    public void writeRegister(final IRegisters.IRegisterDMContext regCtx, final String regValue, final String formatID, final RequestMonitor rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Registers.this.writeRegister(regCtx, regValue, formatID);
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().log(e.getStatus());
                    rm.setStatus(e.getStatus());
                }
                rm.done();
            }
        }, rm);
    }

    public static class RegisterChangedDMEvent
    implements IRegisters.IRegisterChangedDMEvent {
        private final IRegisters.IRegisterDMContext fRegisterDMC;

        RegisterChangedDMEvent(IRegisters.IRegisterDMContext registerDMC) {
            this.fRegisterDMC = registerDMC;
        }

        public IRegisters.IRegisterDMContext getDMContext() {
            return this.fRegisterDMC;
        }
    }

    public class RegisterDMC
    extends DMContext
    implements IRegisters.IRegisterDMContext,
    ISnapshotContributor {
        private IRegisters.RegistersContext tcfContext;

        public RegisterDMC(IEDCExecutionDMC executableDMC, String name, String description, String id) {
            super((IDsfService)Registers.this, new IDMContext[]{executableDMC}, name, id);
            this.tcfContext = null;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, executableDMC.getID());
        }

        public RegisterDMC(RegisterGroupDMC registerGroupDmc, IEDCExecutionDMC executableDMC, Map<String, Object> properties) {
            super(Registers.this, new IDMContext[]{executableDMC}, properties);
            this.tcfContext = null;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, executableDMC.getID());
        }

        public RegisterDMC(RegisterGroupDMC registerGroupDMC, IEDCExecutionDMC executableDMC, IRegisters.RegistersContext tcfContext) {
            super(Registers.this, new IDMContext[]{registerGroupDMC}, (Map<String, Object>)tcfContext.getProperties());
            this.tcfContext = null;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, executableDMC.getID());
            this.tcfContext = tcfContext;
        }

        public IRegisters.RegistersContext getTCFContext() {
            return this.tcfContext;
        }

        @Override
        public String toString() {
            return String.valueOf(this.baseToString()) + ".register[" + this.getName() + "]";
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) throws Exception {
            Element registerElement = document.createElement(Registers.REGISTER);
            registerElement.setAttribute("ID", this.getID());
            registerElement.setAttribute("Value", Registers.this.getRegisterValueAsHexString(this));
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            registerElement.appendChild(propsElement);
            return registerElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadSnapshot(Element element) throws Exception {
            String registerValue = element.getAttribute("Value");
            String contextID = (String)this.getProperties().get(Registers.PROP_EXECUTION_CONTEXT_ID);
            Map map = Registers.this.registerValueCache;
            synchronized (map) {
                HashMap<String, BigInteger> exeDMCRegisters = (HashMap<String, BigInteger>)Registers.this.registerValueCache.get(contextID);
                if (exeDMCRegisters == null) {
                    exeDMCRegisters = new HashMap<String, BigInteger>();
                    Registers.this.registerValueCache.put(contextID, exeDMCRegisters);
                }
                exeDMCRegisters.put(this.getID(), new BigInteger(registerValue, 16));
            }
        }
    }

    class RegisterData
    implements IRegisters.IRegisterDMData {
        private final HashMap<String, Object> properties = new HashMap();

        public RegisterData(Map<String, Object> properties) {
            this.properties.putAll(properties);
        }

        public boolean isReadable() {
            Boolean n = (Boolean)this.properties.get("Readable");
            if (n == null) {
                return true;
            }
            return n;
        }

        public boolean isReadOnce() {
            Boolean n = (Boolean)this.properties.get("ReadOnce");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean isWriteable() {
            Boolean n = (Boolean)this.properties.get("Writeable");
            if (n == null) {
                return true;
            }
            return n;
        }

        public boolean isWriteOnce() {
            Boolean n = (Boolean)this.properties.get("WriteOnce");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean hasSideEffects() {
            Boolean n = (Boolean)this.properties.get("SideEffects");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean isVolatile() {
            Boolean n = (Boolean)this.properties.get("Volatile");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean isFloat() {
            Boolean n = (Boolean)this.properties.get("Float");
            if (n == null) {
                return false;
            }
            return n;
        }

        public String getName() {
            return (String)this.properties.get("Name");
        }

        public String getDescription() {
            return (String)this.properties.get("Description");
        }
    }

    public class RegisterGroupDMC
    extends DMContext
    implements IRegisters.IRegisterGroupDMContext,
    ISnapshotContributor {
        private static final String REGISTER_GROUP = "register_group";
        private List<RegisterDMC> registers;
        private final IEDCExecutionDMC exeContext;

        public RegisterGroupDMC(Registers service, IEDCExecutionDMC executionDMC, String groupName, String groupDescription, String groupID) {
            super((IDsfService)service, new IDMContext[]{executionDMC}, groupName, groupID);
            this.registers = Collections.synchronizedList(new ArrayList());
            this.exeContext = executionDMC;
            this.properties.put("Description", groupDescription);
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, executionDMC.getID());
        }

        public RegisterGroupDMC(Registers service, IEDCExecutionDMC executionDmc, Map<String, Object> props) {
            super(service, new IDMContext[]{executionDmc}, props);
            this.registers = Collections.synchronizedList(new ArrayList());
            this.exeContext = executionDmc;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, this.exeContext.getID());
        }

        @Override
        public String toString() {
            return String.valueOf(this.baseToString()) + ".group[" + this.getName() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RegisterDMC[] getRegisters() throws CoreException {
            RegisterDMC[] result = new RegisterDMC[]{};
            List<RegisterDMC> list = this.registers;
            synchronized (list) {
                if (this.registers.size() == 0) {
                    this.registers = Registers.this.createRegistersForGroup(this);
                }
                result = this.registers.toArray(new RegisterDMC[this.registers.size()]);
            }
            return result;
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) throws Exception {
            Element contextElement = document.createElement(REGISTER_GROUP);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            RegisterDMC[] allRegisters = this.getRegisters();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(allRegisters.length * 1000));
            progress.subTask("Registers");
            RegisterDMC[] registerDMCArray = allRegisters;
            int n = allRegisters.length;
            int n2 = 0;
            while (n2 < n) {
                RegisterDMC registerDMC = registerDMCArray[n2];
                Element dmcElement = registerDMC.takeSnapshot(album, document, (IProgressMonitor)progress.newChild(1000));
                contextElement.appendChild(dmcElement);
                ++n2;
            }
            return contextElement;
        }

        public IEDCExecutionDMC getExecutionDMC() {
            return this.exeContext;
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            NodeList registerElement = element.getElementsByTagName(Registers.REGISTER);
            int numRegisters = registerElement.getLength();
            int i = 0;
            while (i < numRegisters) {
                Element regElement = (Element)registerElement.item(i);
                Element propElement = (Element)regElement.getElementsByTagName("properties").item(0);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                SnapshotUtils.initializeFromXML(propElement, properties);
                RegisterDMC regdmc = new RegisterDMC(this, this.exeContext, properties);
                regdmc.loadSnapshot(regElement);
                this.registers.add(regdmc);
                ++i;
            }
        }
    }
}

