/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSettingEntryFactory {
    private static final HashSet<IPath> EMPTY_SET = new HashSet(0);
    private KindBasedStore<HashMap<String, ?>> fStore = new KindBasedStore(false);

    private <K, V> HashMap<String, HashMap<K, V>> getNameMap(int kind, boolean create, HashMap<K, V> type) {
        HashMap<String, HashMap<K, V>> map = this.fStore.get(kind);
        if (map == null && create) {
            map = new HashMap();
            this.fStore.put(kind, map);
        }
        return map;
    }

    private <K, V> HashMap<K, V> getValueMap(String name, boolean create, HashMap<K, V> type) {
        HashMap<String, HashMap<K, V>> nameMap = this.getNameMap(4, create, null);
        if (nameMap != null) {
            return CSettingEntryFactory.getMap(nameMap, name, create);
        }
        return null;
    }

    private HashMap<Integer, ICSettingEntry> getFlagMap(int kind, String name, String value, IPath[] exclusionPatters, boolean create) {
        switch (kind) {
            case 4: {
                HashMap valueMap = this.getValueMap(name, create, null);
                if (valueMap != null) {
                    return CSettingEntryFactory.getMap(valueMap, name, create);
                }
                return null;
            }
            case 64: 
            case 128: {
                HashMap<HashSet<IPath>, HashMap<Integer, ICSettingEntry>> excPatternMap = this.getExclusionPatternsMap(kind, name, create);
                if (excPatternMap != null) {
                    HashSet<IPath> setKey = exclusionPatters == null || exclusionPatters.length == 0 ? EMPTY_SET : new HashSet<IPath>(Arrays.asList(exclusionPatters));
                    return CSettingEntryFactory.getMap(excPatternMap, setKey, create);
                }
                return null;
            }
        }
        HashMap nameMap = this.getNameMap(kind, create, null);
        if (nameMap != null) {
            return CSettingEntryFactory.getMap(nameMap, name, create);
        }
        return null;
    }

    private HashMap<HashSet<IPath>, HashMap<Integer, ICSettingEntry>> getExclusionPatternsMap(int kind, String name, boolean create) {
        HashMap nameMap = this.getNameMap(kind, create, null);
        if (nameMap != null) {
            return CSettingEntryFactory.getMap(nameMap, name, create);
        }
        return null;
    }

    private static <Key, K, V> HashMap<K, V> getMap(HashMap<Key, HashMap<K, V>> container, Key key, boolean create) {
        HashMap<K, V> map = container.get(key);
        if (map == null && create) {
            map = new HashMap();
            container.put(key, map);
        }
        return map;
    }

    public ICSettingEntry getEntry(ICSettingEntry entry) {
        switch (entry.getKind()) {
            case 64: 
            case 128: {
                return this.getEntry(entry.getKind(), entry.getName(), null, ((ICExclusionPatternPathEntry)entry).getExclusionPatterns(), entry.getFlags(), entry, true);
            }
        }
        return this.getLanguageSettingEntry((ICLanguageSettingEntry)entry);
    }

    public ICLanguageSettingEntry getLanguageSettingEntry(ICLanguageSettingEntry lEntry) {
        return (ICLanguageSettingEntry)this.getEntry(lEntry.getKind(), lEntry.getName(), lEntry.getValue(), null, lEntry.getFlags(), lEntry, true);
    }

    public ICSettingEntry getEntry(int kind, String name, String value, IPath[] exclusionPatterns, int flags, boolean create) {
        return this.getEntry(kind, name, value, exclusionPatterns, flags, null, create);
    }

    private ICSettingEntry getEntry(int kind, String name, String value, IPath[] exclusionPatterns, int flags, ICSettingEntry baseEntry, boolean create) {
        HashMap<Integer, ICSettingEntry> flagMap = this.getFlagMap(kind, name, value, exclusionPatterns, create);
        if (flagMap != null) {
            Integer iFlags = new Integer(flags);
            ICSettingEntry entry = flagMap.get(iFlags);
            if (entry == null && create) {
                entry = baseEntry != null ? baseEntry : CDataUtil.createEntry(kind, name, value, exclusionPatterns, flags);
                flagMap.put(iFlags, entry);
            }
            return entry;
        }
        return null;
    }

    public void clear() {
        this.fStore.clear();
    }
}

