/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.widgets.FilterInputRow;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialog;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.base.WarningDialog;

public class FilterDialog
extends DAMessageBox {
    private ScrolledComposite scrolledComposite = null;
    private Composite filterInputComposite = null;
    private DAButton addButton = null;
    private DAButton clearButton = null;
    private DAButton okButton = null;
    private DATableComposite ownTableComposite = null;
    private String compositeName = null;
    private int selectedColumnIndex = -1;
    private List<FilterInputRow> filterInputRowList = null;
    private FilterColumn[] filterColumns = null;
    private int visibleColumnCount = 0;
    private static final int FILTER_DIALOG_WIDTH = 434;
    private static final int FILTER_DIALOG_HEIGHT = 306;
    private DACustomButtonClickEventListener clearButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            WarningDialog dialog = new WarningDialog(FilterDialog.this.shell, 0);
            dialog.setMessage(AnalyzerLabels.FILTER_DLG_CLEAR_MESSAGE);
            boolean result = dialog.open();
            if (!result) {
                return;
            }
            FilterDialog.this.clearFilterInputRows();
            FilterDialog.this.clearSelectedColumns();
            FilterDialog.this.updateLayout();
        }
    };
    private DACustomButtonClickEventListener addButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FilterInputRow inputRow = new FilterInputRow(FilterDialog.this.filterInputComposite, FilterDialog.this.removeButtonListener, FilterDialog.this.comboMouseDownListener, false);
            inputRow.setComboText(FilterDialog.this.getFirstSelectableColumnName());
            inputRow.addSelectionListener(FilterDialog.this.comboSelectionListener);
            FilterDialog.this.filterInputRowList.add(inputRow);
            FilterDialog.this.updateLayout();
        }
    };
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FilterDialog.this.ownTableComposite.clearFilterPropertyList();
            int size = FilterDialog.this.filterInputRowList.size();
            int i = 0;
            while (i < size) {
                FilterProperty property = new FilterProperty();
                property.setColumnIndex(FilterDialog.this.getColumnIndex(((FilterInputRow)((Object)FilterDialog.this.filterInputRowList.get(i))).getCurrentlySelectedColumnName()));
                String keyWord = ((FilterInputRow)((Object)FilterDialog.this.filterInputRowList.get(i))).getKeyWord();
                if (keyWord == null || keyWord.isEmpty()) {
                    DADialog dialog = new DADialog(FilterDialog.this.shell, DADialog.DIALOGTYPE.ERROR, 0);
                    dialog.setMessage(AnalyzerLabels.FILTER_DLG_KEYWORD_VERIFICATION_MESSAGE);
                    dialog.setIcon(ImageResources.DIALOG_WARNING_ICON);
                    dialog.setDialog();
                    dialog.open();
                    return;
                }
                property.setKeyWord(((FilterInputRow)((Object)FilterDialog.this.filterInputRowList.get(i))).getKeyWord());
                FilterDialog.this.ownTableComposite.addFilterProperty(property);
                ++i;
            }
            FilterDialog.this.ownTableComposite.updateTable();
            FilterDialog.this.shell.close();
        }
    };
    private DACustomButtonClickEventListener removeButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FilterInputRow inputRow = (FilterInputRow)button.getParent();
            int curColumnIndex = FilterDialog.this.getColumnIndex(inputRow.getCurrentlySelectedColumnName());
            FilterDialog.this.filterColumns[curColumnIndex].setSelection(false);
            FilterDialog.this.removeFilterInputRow(inputRow.getCurrentlySelectedColumnName());
            FilterDialog.this.updateLayout();
        }
    };
    private DACustomComboSelectionListener comboSelectionListener = new DACustomComboSelectionListener(){

        public void selectionEvent(DACustomCombo combo) {
            String curColumnName;
            String prevColumnName = ((FilterInputRow)combo.getParent()).getCurrentlySelectedColumnName();
            if (prevColumnName.compareTo(curColumnName = combo.getText()) == 0) {
                Logger.debug((Object)"same column is selected !!");
                return;
            }
            FilterDialog.this.changeColumnSelection(combo);
            FilterDialog.this.updateLayout();
        }
    };
    private Listener comboMouseDownListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 3) {
                FilterInputRow inputRow = (FilterInputRow)((DACustomCombo)event.widget).getParent();
                List columnNames = FilterDialog.this.makeColumnNames(inputRow.getCurrentlySelectedColumnName());
                inputRow.addColumnNameComboItems(columnNames);
            }
        }
    };

    public FilterDialog(Shell parentShell, DATableComposite composite, int selectedColumnIndex) {
        super(parentShell);
        if (composite instanceof DATreeComposite) {
            this.ownTableComposite = (DATreeComposite)composite;
        } else if (composite instanceof DAWindowingTableComposite) {
            this.ownTableComposite = (DAWindowingTableComposite)composite;
        } else if (composite instanceof DATableComposite) {
            this.ownTableComposite = composite;
        } else {
            Logger.error((Object)"This composite type is not supported !!");
            return;
        }
        this.compositeName = this.ownTableComposite.getTableName();
        List<String> allColumnName = this.ownTableComposite.getColumnsName();
        if (allColumnName == null) {
            Logger.error((Object)"Cannot get all column name !!");
            return;
        }
        boolean[] columnVisibility = this.ownTableComposite.getColumnVisibility();
        if (columnVisibility != null) {
            this.filterColumns = new FilterColumn[columnVisibility.length];
            int i = 0;
            while (i < columnVisibility.length) {
                if (columnVisibility[i]) {
                    this.filterColumns[i] = new FilterColumn(allColumnName.get(i), false);
                    ++this.visibleColumnCount;
                }
                ++i;
            }
        } else {
            Logger.error((Object)"Column visibility data is wrong !!");
            return;
        }
        if (selectedColumnIndex != -1) {
            this.selectedColumnIndex = selectedColumnIndex;
        }
        this.filterInputRowList = new ArrayList<FilterInputRow>();
    }

    private void initFilterInputRows() {
        List<FilterProperty> filterPropertyList = null;
        this.clearFilterInputRows();
        filterPropertyList = this.ownTableComposite.getFilterPropertyList();
        if (filterPropertyList == null || filterPropertyList.isEmpty()) {
            this.updateLayout();
            return;
        }
        int i = 0;
        while (i < filterPropertyList.size()) {
            FilterProperty property = filterPropertyList.get(i);
            int columnIndex = property.getColumnIndex();
            this.filterColumns[columnIndex].setSelection(true);
            FilterInputRow inputRow = null;
            inputRow = this.selectedColumnIndex != -1 && columnIndex == this.selectedColumnIndex ? new FilterInputRow(this.filterInputComposite, this.removeButtonListener, this.comboMouseDownListener, true) : new FilterInputRow(this.filterInputComposite, this.removeButtonListener, this.comboMouseDownListener, false);
            inputRow.setComboText(this.filterColumns[columnIndex].getColumnName());
            inputRow.setKeyWordText(property.getKeyWord());
            inputRow.addSelectionListener(this.comboSelectionListener);
            this.filterInputRowList.add(inputRow);
            ++i;
        }
        this.updateLayout();
    }

    private void updateLayout() {
        this.filterInputComposite.layout();
        this.scrolledComposite.setMinSize(this.filterInputComposite.computeSize(-1, -1));
        this.clearButtonSetting();
        this.addButtonSetting();
    }

    private void clearButtonSetting() {
        if (this.filterInputRowList.isEmpty()) {
            this.clearButton.setButtonEnabled(false);
        } else {
            this.clearButton.setButtonEnabled(true);
        }
    }

    private void addButtonSetting() {
        if (this.filterInputRowList.size() >= this.visibleColumnCount) {
            this.addButton.setButtonEnabled(false);
        } else {
            this.addButton.setButtonEnabled(true);
        }
    }

    protected boolean run() {
        if (this.ownTableComposite == null) {
            return false;
        }
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(434, 306);
        this.shell.setBackground(ColorResources.FILTER_DIALOG_DEFAULT_BACKGROUND_COLOR);
        this.shell.setText(String.valueOf(AnalyzerLabels.FILTER_DLG_TITLE_PREFIX) + " " + this.compositeName + " " + AnalyzerLabels.FILTER_DLG_TITLE_POSTFIX);
        Composite frameComposite = new Composite((Composite)this.shell, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -47);
        frameComposite.setLayoutData((Object)data);
        frameComposite.setLayout((Layout)new FormLayout());
        frameComposite.setBackground(ColorResources.DIALOG_BG_UPPER);
        frameComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_1);
                gc.drawLine(0, rect.height - 1, rect.width - 1, rect.height - 1);
                gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_2);
                gc.drawLine(0, rect.height, rect.width - 1, rect.height);
            }
        });
        this.scrolledComposite = new ScrolledComposite(frameComposite, 2816);
        data = new FormData();
        data.top = new FormAttachment(0, 6);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.bottom = new FormAttachment(100, -35);
        this.scrolledComposite.setLayoutData((Object)data);
        this.scrolledComposite.setLayout((Layout)new FormLayout());
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(ColorResources.FILTER_DIALOG_WHITE_BACKGROUND_COLOR);
        this.filterInputComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.filterInputComposite);
        this.scrolledComposite.setMinSize(this.filterInputComposite.computeSize(-1, -1));
        this.scrolledComposite.setShowFocusedControl(true);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.filterInputComposite.setLayoutData((Object)data);
        this.filterInputComposite.setLayout((Layout)new FormLayout());
        this.filterInputComposite.setBackground(ColorResources.FILTER_DIALOG_WHITE_BACKGROUND_COLOR);
        this.clearButton = new DAButton(frameComposite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 3);
        data.right = new FormAttachment(100, -6);
        data.height = 22;
        data.width = 60;
        this.clearButton.setLayoutData((Object)data);
        this.clearButton.setText(AnalyzerLabels.FILTER_DLG_CLEAR_BUTTON);
        this.clearButton.addClickListener(this.clearButtonListener);
        this.addButton = new DAButton(frameComposite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 3);
        data.right = new FormAttachment((Control)this.clearButton, -6);
        data.height = 22;
        data.width = 60;
        this.addButton.setLayoutData((Object)data);
        this.addButton.setText(AnalyzerLabels.FILTER_DLG_ADD_BUTTON);
        this.addButton.addClickListener(this.addButtonListener);
        this.okButton = new DAButton((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)frameComposite, 11);
        data.right = new FormAttachment(100, -9);
        data.height = 28;
        data.width = 100;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(this.okButtonListener);
        this.shell.open();
        this.initFilterInputRows();
        return true;
    }

    private void clearFilterInputRows() {
        int i = 0;
        while (i < this.filterInputRowList.size()) {
            this.filterInputRowList.get(i).dispose();
            ++i;
        }
        this.filterInputRowList.clear();
    }

    private void clearSelectedColumns() {
        int i = 0;
        while (i < this.filterColumns.length) {
            FilterColumn col = this.filterColumns[i];
            if (col != null) {
                col.setSelection(false);
            }
            ++i;
        }
    }

    private void removeFilterInputRow(String columnName) {
        FilterInputRow prev = null;
        FilterInputRow cur = null;
        FilterInputRow next = null;
        int i = 0;
        while (i < this.filterInputRowList.size()) {
            if (i != 0) {
                prev = cur;
            }
            cur = this.filterInputRowList.get(i);
            next = i != this.filterInputRowList.size() - 1 ? this.filterInputRowList.get(i + 1) : null;
            if (cur.getCurrentlySelectedColumnName().equalsIgnoreCase(columnName)) {
                if (next != null) {
                    FormData nextData = (FormData)next.getLayoutData();
                    nextData.top = prev != null ? new FormAttachment((Control)prev, 2) : new FormAttachment(0, 0);
                }
                this.filterInputRowList.get(i).dispose();
                this.filterInputRowList.remove(i);
                break;
            }
            ++i;
        }
    }

    private void changeColumnSelection(DACustomCombo combo) {
        FilterInputRow changedFilterInputRow = (FilterInputRow)combo.getParent();
        this.swapSelectionState(changedFilterInputRow.getCurrentlySelectedColumnName(), combo.getText());
        changedFilterInputRow.setCurrentlySelectedColumnName(combo.getText());
    }

    private List<String> getSelectableColumnNames() {
        ArrayList<String> selectableColumnNames = new ArrayList<String>();
        int i = 0;
        while (i < this.filterColumns.length) {
            FilterColumn col = this.filterColumns[i];
            if (col != null && !col.getSelection()) {
                selectableColumnNames.add(col.getColumnName());
            }
            ++i;
        }
        return selectableColumnNames;
    }

    private String getFirstSelectableColumnName() {
        int i = 0;
        while (i < this.filterColumns.length) {
            FilterColumn col = this.filterColumns[i];
            if (col != null && !col.getSelection()) {
                col.setSelection(true);
                return col.getColumnName();
            }
            ++i;
        }
        return "";
    }

    private List<String> makeColumnNames(String selectedColumnName) {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (!selectedColumnName.isEmpty()) {
            columnNames.add(selectedColumnName);
        } else {
            Logger.debug((Object)"selected column name is empty !!");
        }
        columnNames.addAll(this.getSelectableColumnNames());
        return columnNames;
    }

    private int getColumnIndex(String columnName) {
        int i = 0;
        while (i < this.filterColumns.length) {
            FilterColumn col = this.filterColumns[i];
            if (col != null && col.getColumnName().compareTo(columnName) == 0) {
                return i;
            }
            ++i;
        }
        Logger.error((String)"There is not same column name - %s", (Object[])new Object[]{columnName});
        return -1;
    }

    private void swapSelectionState(String prevColumnName, String curColumnName) {
        int prevColumnIndex = this.getColumnIndex(prevColumnName);
        int curColumnIndex = this.getColumnIndex(curColumnName);
        if (prevColumnIndex == -1 || curColumnIndex == -1) {
            Logger.error((Object)"Failed to change selection state !!");
            return;
        }
        this.filterColumns[prevColumnIndex].setSelection(false);
        this.filterColumns[curColumnIndex].setSelection(true);
    }

    class FilterColumn {
        String columnName = null;
        boolean isSelection = false;

        public FilterColumn(String columnName, boolean isSelection) {
            this.columnName = columnName;
            this.isSelection = isSelection;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean getSelection() {
            return this.isSelection;
        }

        public void setSelection(boolean isSelection) {
            this.isSelection = isSelection;
        }
    }
}

