/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Expressions;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.BreakpointsMediator2;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IBreakpoints;

public class Breakpoints
extends AbstractEDCService
implements org.eclipse.cdt.dsf.debug.service.IBreakpoints,
IDSFServiceUsingTCF {
    public static final String PREFIX = "org.eclipse.cdt.debug.edc.breakpoint";
    public static final String BREAKPOINT_TYPE = "org.eclipse.cdt.debug.edc.breakpoint.type";
    public static final String BREAKPOINT = "breakpoint";
    public static final String WATCHPOINT = "watchpoint";
    public static final String CATCHPOINT = "catchpoint";
    public static final String BREAKPOINT_SUBTYPE = "org.eclipse.cdt.debug.edc.breakpoint.subtype";
    public static final String LINE_BREAKPOINT = "line_bp";
    public static final String FUNCTION_BREAKPOINT = "function_bp";
    public static final String ADDRESS_BREAKPOINT = "address_bp";
    public static final String RUNTIME_ADDRESS = "org.eclipse.cdt.debug.edc.breakpoint.runtime_addr";
    static final String NULL_STRING = "";
    static final String UNKNOWN_EXECUTION_CONTEXT = "Unknown execution context";
    static final String UNKNOWN_BREAKPOINT_CONTEXT = "Unknown breakpoint context";
    static final String UNKNOWN_BREAKPOINT_TYPE = "Unknown breakpoint type";
    static final String UNKNOWN_BREAKPOINT = "Unknown breakpoint";
    static final String BREAKPOINT_INSERTION_FAILURE = "Breakpoint insertion failure";
    static final String WATCHPOINT_INSERTION_FAILURE = "Watchpoint insertion failure";
    static final String INVALID_CONDITION = "Invalid condition";
    private final Map<IBreakpoints.IBreakpointDMContext, BreakpointDMData> userBreakpoints = new HashMap<IBreakpoints.IBreakpointDMContext, BreakpointDMData>();
    private final List<BreakpointDMData> tempBreakpoints = new ArrayList<BreakpointDMData>();
    private IBreakpoints tcfBreakpointService;
    private Map<ILaunchConfiguration, Modules.ModuleDMC> startupBreakpointModule = new HashMap<ILaunchConfiguration, Modules.ModuleDMC>();
    private ISourceLocator sourceLocator;
    private Map<ICBreakpoint, IMarker> fBreakpointMarkers = new HashMap<ICBreakpoint, IMarker>();
    private static long nextBreakpointID = 1L;

    public Breakpoints(DsfSession session) {
        super(session, new String[]{org.eclipse.cdt.dsf.debug.service.IBreakpoints.class.getName(), Breakpoints.class.getName()});
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                Breakpoints.this.getSession().addServiceEventListener((Object)Breakpoints.this, null);
                rm.done();
            }
        });
    }

    public void getBreakpointDMData(IBreakpoints.IBreakpointDMContext dmc, DataRequestMonitor<IBreakpoints.IBreakpointDMData> drm) {
        if (!this.userBreakpoints.containsKey(dmc)) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", UNKNOWN_BREAKPOINT));
        } else {
            drm.setData((Object)this.userBreakpoints.get(dmc));
        }
        drm.done();
    }

    public void getBreakpoints(IBreakpoints.IBreakpointsTargetDMContext context, DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> drm) {
        Set<IBreakpoints.IBreakpointDMContext> breakpointIDs = this.userBreakpoints.keySet();
        drm.setData((Object)breakpointIDs.toArray(new IBreakpoints.IBreakpointDMContext[breakpointIDs.size()]));
        drm.done();
    }

    public BreakpointDMData findBreakpoint(IAddress addr) {
        BreakpointDMData bp = this.findUserBreakpoint(addr);
        if (bp == null) {
            bp = this.findTempBreakpoint(addr);
        }
        return bp;
    }

    public BreakpointDMData findUserBreakpoint(IAddress addr) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("Find user breakpoint at " + addr.toHexAddressString()));
        }
        for (BreakpointDMData bp : this.userBreakpoints.values()) {
            if (!bp.getAddresses()[0].equals((Object)addr)) continue;
            if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(bp.toString()));
            }
            return bp;
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)"not found.");
        }
        return null;
    }

    public BreakpointDMData findTempBreakpoint(IAddress addr) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("Find temp breakpoint at " + addr.toHexAddressString()));
        }
        for (BreakpointDMData bp : this.tempBreakpoints) {
            if (!bp.getAddresses()[0].equals((Object)addr)) continue;
            if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(bp.toString()));
            }
            return bp;
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)"not found.");
        }
        return null;
    }

    public void removeBreakpointFromMemoryBuffer(IAddress startAddr, MemoryByte[] memBuffer) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("remove bp in memory area:" + startAddr.toHexAddressString() + "," + memBuffer.length));
        }
        if (this.usesTCFBreakpointService()) {
            return;
        }
        for (BreakpointDMData edcBp : this.userBreakpoints.values()) {
            IAddress bpAddr = edcBp.getAddresses()[0];
            int bpOffset = (int)startAddr.distanceTo(bpAddr).longValue();
            if (bpOffset < 0 || bpOffset >= memBuffer.length) continue;
            byte[] orgInst = edcBp.getOriginalInstruction();
            int i = 0;
            while (i < orgInst.length && i + bpOffset < memBuffer.length) {
                memBuffer[bpOffset + i].setValue(orgInst[i]);
                ++i;
            }
            if (!EDCTrace.BREAKPOINTS_TRACE_ON) continue;
            EDCTrace.getTrace().trace(null, "breakpoint removed at offset " + bpOffset);
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public void insertBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{attributes}));
        }
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, UNKNOWN_EXECUTION_CONTEXT, null));
            drm.done();
            return;
        }
        String type = (String)attributes.get(BREAKPOINT_TYPE);
        if (type == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            drm.done();
            return;
        }
        if (type.equals(BREAKPOINT)) {
            this.addBreakpoint(context, attributes, drm);
        } else if (type.equals(WATCHPOINT)) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Watchpoint is not supported yet.", null));
            drm.done();
        } else {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            drm.done();
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    private void addBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{attributes}));
        }
        IRunControl.IExecutionDMContext exe_dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IExecutionDMContext.class);
        String bpAddr = (String)attributes.get(RUNTIME_ADDRESS);
        assert (exe_dmc != null) : "ExecutionDMContext is unknown in addBreakpoint().";
        assert (bpAddr != null);
        this.createBreakpoint(exe_dmc, (IAddress)new Addr64(bpAddr, 16), attributes, new DataRequestMonitor<BreakpointDMData>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                final BreakpointDMData bpd = (BreakpointDMData)this.getData();
                Breakpoints.this.enableBreakpoint(bpd, new RequestMonitor((Executor)Breakpoints.this.getExecutor(), (RequestMonitor)drm){

                    protected void handleSuccess() {
                        IBreakpoints.IBreakpointDMContext bp_dmc = bpd.getContext();
                        drm.setData((Object)bp_dmc);
                        Breakpoints.this.userBreakpoints.put(bp_dmc, bpd);
                        drm.done();
                    }
                });
            }
        });
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public ISourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    public void setSourceLocator(ISourceLocator sourceLocator) {
        this.sourceLocator = sourceLocator;
    }

    public void setTempBreakpoint(IRunControl.IExecutionDMContext context, final IAddress address, final RequestMonitor rm) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("set temp breakpoint at " + address.toHexAddressString()));
        }
        if (this.findBreakpoint(address) != null) {
            rm.done();
            if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)("A breakpoint exists at " + address.toHexAddressString()));
            }
            return;
        }
        this.createBreakpoint(context, address, new HashMap<String, Object>(), new DataRequestMonitor<BreakpointDMData>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                final BreakpointDMData bp_data = (BreakpointDMData)this.getData();
                Breakpoints.this.enableBreakpoint(bp_data, new RequestMonitor((Executor)Breakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        Breakpoints.this.tempBreakpoints.add(bp_data);
                        rm.done();
                        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg("A temp breakpoint successfully set at " + address.toHexAddressString()));
                        }
                    }
                });
            }
        });
    }

    public void removeAllTempBreakpoints(RequestMonitor rm) {
        int numTempBps = this.tempBreakpoints.size();
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("remove " + numTempBps + " temp breakpoint" + (numTempBps == 1 ? NULL_STRING : "s") + "."));
        }
        if (numTempBps == 0) {
            rm.done();
            return;
        }
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (this.getStatus().isOK()) {
                    Breakpoints.this.tempBreakpoints.clear();
                }
                super.handleCompleted();
            }
        };
        crm.setDoneCount(this.tempBreakpoints.size());
        for (BreakpointDMData bp : this.tempBreakpoints) {
            this.disableBreakpoint(bp, (RequestMonitor)crm);
        }
    }

    private void createBreakpoint(final IRunControl.IExecutionDMContext exeDMC, final IAddress address, final Map<String, Object> props, final DataRequestMonitor<BreakpointDMData> drm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                final long id = Breakpoints.this.getNewBreakpointID();
                final BreakpointDMContext bp_dmc = new BreakpointDMContext(Breakpoints.this.getSession().getId(), new IDMContext[]{exeDMC}, id);
                final IAddress[] bp_addrs = new IAddress[]{address};
                final HashMap<String, Object> properties = new HashMap<String, Object>(props);
                if (Breakpoints.this.usesTCFBreakpointService()) {
                    properties.put("ID", Long.toString(id));
                    properties.put("Enabled", true);
                    properties.put("BreakpointType", "Auto");
                    properties.put("Location", address.toString());
                    IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)exeDMC, IBreakpoints.IBreakpointsTargetDMContext.class);
                    String[] contexts = !exeDMC.equals(bpTargetDMC) ? new String[]{((IEDCDMContext)bpTargetDMC).getID(), ((IEDCDMContext)exeDMC).getID()} : new String[]{((IEDCDMContext)bpTargetDMC).getID()};
                    properties.put("ContextIds", contexts);
                    Breakpoints.this.getTargetEnvironmentService().updateBreakpointProperties((IDMContext)exeDMC, address, properties);
                    drm.setData((Object)new BreakpointDMData(id, bp_dmc, bp_addrs, properties));
                    drm.done();
                } else {
                    byte[] bpInstruction = Breakpoints.this.getTargetEnvironmentService().getBreakpointInstruction((IDMContext)exeDMC, address);
                    int inst_size = bpInstruction.length;
                    Memory memoryService = Breakpoints.this.getService(Memory.class);
                    IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)exeDMC, IMemory.IMemoryDMContext.class);
                    memoryService.getMemory(mem_dmc, address, 0L, 1, inst_size, new DataRequestMonitor<MemoryByte[]>((Executor)Breakpoints.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            MemoryByte[] org_inst = (MemoryByte[])this.getData();
                            byte[] org_inst_bytes = new byte[org_inst.length];
                            int i = 0;
                            while (i < org_inst.length) {
                                if (!org_inst[i].isReadable()) {
                                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Cannot read memory at 0x" + address.add((long)i).getValue().toString(16), null));
                                    drm.done();
                                    return;
                                }
                                org_inst_bytes[i] = org_inst[i].getValue();
                                ++i;
                            }
                            drm.setData((Object)new BreakpointDMData(id, bp_dmc, bp_addrs, org_inst_bytes, properties));
                            drm.done();
                        }
                    });
                }
            }
        }, (RequestMonitor)drm);
    }

    public void enableBreakpoint(final BreakpointDMData bp, final RequestMonitor rm) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(bp));
        }
        if (this.usesTCFBreakpointService()) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Breakpoints.this.tcfBreakpointService.add(bp.getProperties(), new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "TCF agent fails to install " + bp + " because:\n" + error.getLocalizedMessage(), (Throwable)error));
                                rm.done();
                            } else {
                                Breakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(bp.getContext()), new Hashtable<String, Object>(bp.getProperties()));
                                rm.done();
                            }
                        }
                    });
                }
            });
        } else {
            IAddress bp_addr = bp.getAddresses()[0];
            IRunControl.IExecutionDMContext exe_dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)bp.getContext(), IRunControl.IExecutionDMContext.class);
            byte[] bpInstruction = this.getTargetEnvironmentService().getBreakpointInstruction((IDMContext)exe_dmc, bp_addr);
            Memory memoryService = this.getService(Memory.class);
            IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)bp.getContext(), IMemory.IMemoryDMContext.class);
            memoryService.setMemory(mem_dmc, bp_addr, 0L, 1, bpInstruction.length, bpInstruction, rm);
            this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(bp.getContext()), new Hashtable<String, Object>(bp.getProperties()));
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    private synchronized long getNewBreakpointID() {
        return nextBreakpointID++;
    }

    public void removeBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, RequestMonitor rm) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{dmc}));
        }
        if (!(dmc instanceof BreakpointDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "Unrecognized breakpoint context."));
            rm.done();
            return;
        }
        if (!this.userBreakpoints.containsKey(dmc)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", UNKNOWN_BREAKPOINT));
            rm.done();
            return;
        }
        this.disableBreakpoint(this.userBreakpoints.get(dmc), new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                Breakpoints.this.userBreakpoints.remove(dmc);
                super.handleSuccess();
            }
        });
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public void disableBreakpoint(final BreakpointDMData bp, final RequestMonitor rm) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{bp}));
        }
        if (!this.usesTCFBreakpointService()) {
            Memory memoryService = this.getService(Memory.class);
            IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)bp.getContext(), IMemory.IMemoryDMContext.class);
            byte[] orgInst = bp.getOriginalInstruction();
            memoryService.setMemory(mem_dmc, bp.getAddresses()[0], 0L, 1, orgInst.length, orgInst, rm);
        } else {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Map<String, Object> properties = bp.getProperties();
                    String id = (String)properties.get("ID");
                    Breakpoints.this.tcfBreakpointService.remove(new String[]{id}, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            rm.done();
                        }
                    });
                }
            });
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public void updateBreakpoint(IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> delta, RequestMonitor rm) {
        BreakpointDMData bp = this.userBreakpoints.get(dmc);
        if (bp == null) {
            assert (false) : "Fail to find BreakpointDMData linked with the IBreakpointDMContext:" + dmc;
        } else {
            Map<String, Object> existingProps = bp.getProperties();
            for (String key : delta.keySet()) {
                existingProps.put(key, delta.get(key));
            }
        }
        rm.done();
    }

    public boolean usesTCFBreakpointService() {
        return this.tcfBreakpointService != null;
    }

    @Override
    public void tcfServiceReady(IService service) {
        this.tcfBreakpointService = (IBreakpoints)service;
    }

    @DsfServiceEventHandler
    public void eventHandler_installBreakpointsForModule(IModules.ModuleLoadedDMEvent e) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{e}));
        }
        Modules.ModuleLoadedEvent event = (Modules.ModuleLoadedEvent)e;
        final IRunControl.IExecutionDMContext executionDMC = event.getExecutionDMC();
        final Modules.ModuleDMC module = (Modules.ModuleDMC)e.getLoadedModuleContext();
        BreakpointsMediator2 bm = this.getService(BreakpointsMediator2.class);
        if (bm == null) {
            EDCDebugger.getMessageLogger().logError("Fail to get BreakpointsMediator service to install breakpoints for loaded module " + module, null);
            assert (false);
            return;
        }
        final boolean requireResume = this.requireResume(module);
        IBreakpoints.IBreakpointsTargetDMContext bt_dmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)module, IBreakpoints.IBreakpointsTargetDMContext.class);
        bm.startTrackingBreakpoints(bt_dmc, new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    IStatus status = this.getStatus();
                    String msg = MessageFormat.format("Failed to install some breakpoints in the module [{0}]. Errors: \n", module.getName());
                    if (status.isMultiStatus()) {
                        IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
                        int n = iStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus s = iStatusArray[n2];
                            msg = String.valueOf(msg) + s.getMessage() + "\n";
                            ++n2;
                        }
                    } else {
                        msg = String.valueOf(msg) + status.getMessage();
                    }
                    if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                        EDCTrace.getTrace().trace(null, msg);
                    }
                }
                Breakpoints.this.setStartupBreakpoint(module, new RequestMonitor((Executor)Breakpoints.this.getExecutor(), null){

                    protected void handleCompleted() {
                        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                            EDCTrace.getTrace().trace(null, "resume process after module load event ...");
                        }
                        if (requireResume) {
                            ((RunControl.ExecutionDMC)executionDMC).resume(new RequestMonitor((Executor)Breakpoints.this.getExecutor(), null));
                        }
                    }
                });
            }
        });
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    private boolean requireResume(Modules.ModuleDMC module) {
        boolean requireResume = true;
        Object propvalue = module.getProperties().get("RequireResume");
        if (propvalue != null && propvalue instanceof Boolean) {
            requireResume = (Boolean)propvalue;
        }
        return requireResume;
    }

    protected void setStartupBreakpoint(Modules.ModuleDMC module, RequestMonitor rm) {
        long address;
        Addr32 iaddr;
        String startupStopAt;
        ILaunchConfiguration launchConfig;
        block15: {
            EDCLaunch launch = EDCLaunch.getLaunchForSession(this.getSession().getId());
            launchConfig = launch.getLaunchConfiguration();
            if (this.startupBreakpointModule.get(launchConfig) != null) {
                rm.done();
                return;
            }
            startupStopAt = launch.getStartupStopAtPoint();
            if (startupStopAt == null) {
                rm.done();
                return;
            }
            ITargetEnvironment te = this.getTargetEnvironmentService();
            if (!te.needStartupBreakpointInExecutable(module.getName())) {
                rm.done();
                return;
            }
            iaddr = null;
            address = 0L;
            try {
                address = Long.parseLong(startupStopAt);
            }
            catch (NumberFormatException numberFormatException) {
                if (!startupStopAt.toLowerCase().startsWith("0x")) break block15;
                try {
                    address = Long.parseLong(startupStopAt.substring(2), 16);
                }
                catch (IllegalFormatException illegalFormatException) {}
            }
        }
        if (address != 0L) {
            iaddr = new Addr32(address);
            IAddress runAddr = module.toRuntimeAddress((IAddress)iaddr);
            if (module.containsAddress(runAddr)) {
                iaddr = runAddr;
            } else if (!module.containsAddress((IAddress)iaddr)) {
                iaddr = null;
            }
        } else {
            Symbols symService = this.getService(Symbols.class);
            List<IAddress> addrs = symService.getFunctionAddress(module, startupStopAt);
            if (addrs.size() > 0) {
                iaddr = addrs.get(0);
            }
        }
        if (iaddr == null) {
            EDCDebugger.getMessageLogger().logError("Could not resolve startup breakpoint: " + startupStopAt, null);
            rm.done();
        } else {
            this.startupBreakpointModule.put(launchConfig, module);
            IRunControl.IExecutionDMContext exe_dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)module, IRunControl.IExecutionDMContext.class);
            this.setTempBreakpoint(exe_dmc, (IAddress)iaddr, rm);
        }
    }

    @DsfServiceEventHandler
    public void eventHandler_uninstallBreakpointsForModule(IModules.ModuleUnloadedDMEvent e) {
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{e.getClass().getName(), e}));
        }
        Modules.ModuleUnloadedEvent event = (Modules.ModuleUnloadedEvent)e;
        final RunControl.ExecutionDMC executionDMC = (RunControl.ExecutionDMC)event.getExecutionDMC();
        Modules.ModuleDMC module = (Modules.ModuleDMC)e.getUnloadedModuleContext();
        if (this.startupBreakpointModule != null && this.startupBreakpointModule.equals(module)) {
            this.startupBreakpointModule = null;
        }
        final boolean requireResume = this.requireResume(module);
        BreakpointsMediator2 bm = this.getService(BreakpointsMediator2.class);
        IBreakpoints.IBreakpointsTargetDMContext bt_dmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)e.getUnloadedModuleContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
        bm.stopTrackingBreakpoints(bt_dmc, new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleFailure() {
                super.handleFailure();
                if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, "uninstalling breakpoints failed");
                }
            }

            protected void handleSuccess() {
                super.handleSuccess();
                if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, "breakpoints uninstalled and resume process...");
                }
                if (requireResume) {
                    executionDMC.resume(new RequestMonitor((Executor)Breakpoints.this.getExecutor(), null));
                }
            }
        });
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    protected void addBreakpointProblemMarker(final ICBreakpoint breakpoint, final String description, final int severity) {
        if (!(breakpoint instanceof ICLineBreakpoint)) {
            return;
        }
        new Job("Add Breakpoint Problem Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                IMarker marker = (IMarker)Breakpoints.this.fBreakpointMarkers.remove(breakpoint);
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {}
                }
                ICLineBreakpoint lineBreakpoint = (ICLineBreakpoint)breakpoint;
                try {
                    IMarker breakpoint_marker = lineBreakpoint.getMarker();
                    IResource resource = breakpoint_marker.getResource();
                    IMarker problem_marker = resource.createMarker("org.eclipse.cdt.debug.core.breakpointproblem");
                    int line_number = lineBreakpoint.getLineNumber();
                    problem_marker.setAttribute("location", (Object)String.valueOf(line_number));
                    problem_marker.setAttribute("message", (Object)description);
                    problem_marker.setAttribute("severity", severity);
                    problem_marker.setAttribute("lineNumber", line_number);
                    Breakpoints.this.fBreakpointMarkers.put(breakpoint, problem_marker);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void removeBreakpointProblemMarker(ICBreakpoint breakpoint) {
        final IMarker marker = this.fBreakpointMarkers.remove(breakpoint);
        if (marker == null) {
            return;
        }
        new Job("Remove Breakpoint Problem Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void evaluateBreakpointCondition(IRunControl.IExecutionDMContext context, final BreakpointDMData bp, final DataRequestMonitor<Boolean> drm) {
        final String expr = bp.getCondition();
        if (expr == null || expr.length() == 0) {
            bp.incrementHitCount();
            drm.setData((Object)(bp.getHitCount() > bp.getIgnoreCount() ? 1 : 0));
            drm.done();
            return;
        }
        Stack stackService = this.getService(Stack.class);
        stackService.getTopFrame((IDMContext)context, new DataRequestMonitor<IStack.IFrameDMContext>((Executor)this.getExecutor(), drm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    bp.incrementHitCount();
                    drm.setData((Object)(bp.getHitCount() > bp.getIgnoreCount() ? 1 : 0));
                    drm.done();
                } else {
                    IFormattedValues.FormattedValueDMContext fvc;
                    Expressions exprService = Breakpoints.this.getService(Expressions.class);
                    IEDCExpression expression = (IEDCExpression)exprService.createExpression((IDMContext)this.getData(), expr);
                    IFormattedValues.FormattedValueDMData value = expression.getFormattedValue(fvc = exprService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expression, "NATURAL.Format"));
                    String vstr = value.getFormattedValue();
                    if (!vstr.equals("true") && !vstr.equals("false")) {
                        Breakpoints.this.reportBreakpointProblem(bp.getContext(), "Breakpoint condition failed to resolve to boolean: " + vstr);
                    } else {
                        Breakpoints.this.reportBreakpointProblem(bp.getContext(), Breakpoints.NULL_STRING);
                    }
                    if (!vstr.equals("false")) {
                        bp.incrementHitCount();
                        drm.setData((Object)(bp.getHitCount() > bp.getIgnoreCount() ? 1 : 0));
                    } else {
                        drm.setData((Object)false);
                    }
                    drm.done();
                }
            }
        });
    }

    protected void reportBreakpointProblem(IBreakpoints.IBreakpointDMContext targetBP, String description) {
        BreakpointsMediator2 bmService = this.getService(BreakpointsMediator2.class);
        if (bmService == null) {
            assert (false);
            return;
        }
        IBreakpoint platformBP = bmService.getPlatformBreakpoint(null, targetBP);
        if (platformBP == null) {
            return;
        }
        if (description.length() > 0) {
            this.addBreakpointProblemMarker((ICBreakpoint)platformBP, description, 1);
        } else {
            this.removeBreakpointProblemMarker((ICBreakpoint)platformBP);
        }
    }

    public class BreakpointAddedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsAddedEvent {
        public BreakpointAddedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    @Immutable
    public static final class BreakpointDMContext
    extends DMContext
    implements IBreakpoints.IBreakpointDMContext {
        public BreakpointDMContext(String sessionID, IDMContext[] parents, long id) {
            super(sessionID, parents, Long.toString(id));
        }

        @Override
        public String toString() {
            return "BreakpointDMContext [id=" + this.getID() + "]";
        }
    }

    public class BreakpointDMData
    implements IBreakpoints.IBreakpointDMData {
        private final long id;
        private final IBreakpoints.IBreakpointDMContext context;
        private final IAddress[] addresses;
        private final byte[] originalInstruction;
        private Map<String, Object> properties;
        private int hitCount;

        public BreakpointDMData(long id, IBreakpoints.IBreakpointDMContext context, IAddress[] addresses, Map<String, Object> properties) {
            this.id = id;
            this.context = context;
            this.addresses = addresses;
            this.originalInstruction = null;
            this.properties = new HashMap<String, Object>(properties);
        }

        public BreakpointDMData(long id, IBreakpoints.IBreakpointDMContext context, IAddress[] addresses, byte[] fOriginalInstruction, Map<String, Object> properties) {
            this.id = id;
            this.context = context;
            this.addresses = addresses;
            this.originalInstruction = fOriginalInstruction;
            this.properties = new HashMap<String, Object>(properties);
        }

        public IAddress[] getAddresses() {
            return this.addresses;
        }

        public String getBreakpointType() {
            return (String)this.properties.get(Breakpoints.BREAKPOINT_TYPE);
        }

        public String getCondition() {
            return (String)this.properties.get("org.eclipse.cdt.debug.core.condition");
        }

        public String getExpression() {
            return (String)this.properties.get("org.eclipse.cdt.debug.core.expression");
        }

        public String getFileName() {
            return (String)this.properties.get("org.eclipse.cdt.debug.core.sourceHandle");
        }

        public String getFunctionName() {
            return (String)this.properties.get("org.eclipse.cdt.debug.core.function");
        }

        public int getIgnoreCount() {
            return (Integer)this.properties.get("org.eclipse.cdt.debug.core.ignoreCount");
        }

        public int getLineNumber() {
            return (Integer)this.properties.get("lineNumber");
        }

        public boolean isEnabled() {
            return (Boolean)this.properties.get("org.eclipse.debug.core.enabled");
        }

        public long getID() {
            return this.id;
        }

        public byte[] getOriginalInstruction() {
            return this.originalInstruction;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public IBreakpoints.IBreakpointDMContext getContext() {
            return this.context;
        }

        public void setProperties(Map<String, Object> props) {
            this.properties = new HashMap<String, Object>(props);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BreakpointDMData other = (BreakpointDMData)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.id == other.id;
        }

        private Breakpoints getOuterType() {
            return Breakpoints.this;
        }

        public String toString() {
            String s = this.getFileName();
            s = s == null ? this.getAddresses()[0].toHexAddressString() : (this.getFunctionName() != null ? String.valueOf(s) + ": " + this.getFunctionName() : String.valueOf(s) + ":line " + this.getLineNumber());
            return "Breakpoint@" + s;
        }

        public void incrementHitCount() {
            ++this.hitCount;
        }

        public int getHitCount() {
            return this.hitCount;
        }
    }

    public class BreakpointRemovedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsRemovedEvent {
        public BreakpointRemovedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointUpdatedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsUpdatedEvent {
        public BreakpointUpdatedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointsChangedEvent
    extends AbstractDMEvent<IBreakpoints.IBreakpointsTargetDMContext>
    implements IBreakpoints.IBreakpointsChangedEvent {
        private IBreakpoints.IBreakpointDMContext[] eventBreakpoints;

        public BreakpointsChangedEvent(IBreakpoints.IBreakpointDMContext bp) {
            super((IDMContext)((IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)bp, IBreakpoints.IBreakpointsTargetDMContext.class)));
            this.eventBreakpoints = new IBreakpoints.IBreakpointDMContext[]{bp};
        }

        public IBreakpoints.IBreakpointDMContext[] getBreakpoints() {
            return this.eventBreakpoints;
        }
    }
}

