/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.manager;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.tizen.dynamicanalyzer.cli.manager.ProcessManager;
import org.tizen.dynamicanalyzer.cli.manager.ProcessManagerMBean;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessManagerJMXAgent {
    public static final int AGENT_SHUTDOWN_TIMEOUT_MS = 60000;
    public static final String PROCESS_MANAGER_MBEAN_OBJECT_NAME = "dynamicanalyzer.tizen.org:type=ProcessManager";

    public static void startProcessManager() throws JMException {
        MBeanServer mbServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName pmName = null;
        try {
            pmName = new ObjectName(PROCESS_MANAGER_MBEAN_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            Logger.error((String)"Wrong JMX Object Name: %s.", (Object[])new Object[]{e.toString()});
            throw e;
        }
        mbServer.registerMBean(ProcessManagerHolder.INSTANCE, pmName);
        Logger.info((Object)"MBean server started. PM bean registered.");
    }

    public static void waitForProcessManagerCompletion() throws InterruptedException {
        try {
            Thread.sleep(60000L);
            while (ProcessManagerHolder.INSTANCE.getTracedDevices().length != 0) {
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException e) {
            Logger.warning((Object)"Process Manager Agent thread was interrupted.");
            throw e;
        }
    }

    public static ProcessManagerMBean getProcessManager() {
        return ProcessManagerHolder.INSTANCE;
    }

    public static void main(String[] args) {
        Logger.init((int)2);
        Logger.info((Object)"Starting Process Manager Agent.");
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessManagerHolder.INSTANCE.stopAll();
            }
        }, "PM Shutdown Hook"));
        try {
            ProcessManagerJMXAgent.startProcessManager();
        }
        catch (JMException e) {
            Logger.error((String)"Error during initilization of PM Agent: %s.", (Object[])new Object[]{e.toString()});
            System.exit(1);
        }
        try {
            ProcessManagerJMXAgent.waitForProcessManagerCompletion();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class ProcessManagerHolder {
        public static ProcessManagerMBean INSTANCE = new ProcessManager();

        private ProcessManagerHolder() {
        }
    }
}

