/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfilingTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class FunctionUsageProfilingView
extends DAViewComposite {
    Composite contents = null;
    protected StackLayout stackLayout;
    protected ProfilingTable nativeTable = null;
    protected WebProfilingTable webTable = null;

    public FunctionUsageProfilingView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.nativeTable = new ProfilingTable(this.contents, 0, 2820);
        this.webTable = new WebProfilingTable(this.contents, 0, 2820);
        Project currentProject = Global.getProject();
        if (currentProject == null) {
            this.stackLayout.topControl = this.nativeTable;
        } else {
            this.changeTable(currentProject.isWebApplication());
        }
    }

    public void updateView() {
        ((DATreeComposite)this.stackLayout.topControl).updateTree();
    }

    public void updateView(DAViewData data) {
        ((DATreeComposite)this.stackLayout.topControl).deselectAll();
    }

    public void clear() {
        ((DATreeComposite)this.stackLayout.topControl).clear();
    }

    public Control getControl() {
        return this.stackLayout.topControl;
    }

    public void changeTable(boolean isWeb) {
        this.stackLayout.topControl = isWeb ? this.webTable : this.nativeTable;
        this.contents.layout();
    }
}

