/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.failed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.error.ErrorCodeManager;
import org.tizen.dynamicanalyzer.listeners.SummaryMouseDoubleClickListener;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiDataMaker;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class FailedApiTable
extends DATableComposite {
    private final FailedApiDataMaker failedApiDataMaker = SummaryDataManager.getInstance().getFailedApiDataMaker();

    public FailedApiTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.setContextMenu(1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = FailedApiTable.this.table.getSelection();
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                long time = dataFormat.getLogData().getTime();
                String id = SummaryPage.failedViewID;
                DASelectionData selData = new DASelectionData(id, time, 0L, items, (Control)FailedApiTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new SummaryMouseDoubleClickListener(SummaryPage.failedViewID));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<TableInput> makeTableInput() {
        List<List<Object>> failedData = null;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        List<FilterProperty> filterList = this.getFilterList();
        if (!filterList.isEmpty()) {
            List<String> whereQueryList = this.convertFilterProperty2Query(filterList);
            failedData = this.failedApiDataMaker.getFailedApiDataFromDB(selectedPid, whereQueryList);
        } else {
            failedData = this.failedApiDataMaker.getFailedApiDataFromDB(selectedPid, null);
        }
        if (failedData == null) {
            return null;
        }
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        int size = failedData.size();
        int i = 0;
        while (i < size) {
            block19: {
                String errMsg;
                List<Object> idata = failedData.get(i);
                long time = (Long)idata.get(FailedApiDataDBTable.COLUMN.START_TIME.index);
                String timeFormat = null;
                try {
                    timeFormat = Formatter.toTimeFormat(time);
                }
                catch (NumberFormatException e) {
                    Logger.exception((Throwable)e);
                    timeFormat = Long.toString(time);
                }
                int apiId = (Integer)idata.get(FailedApiDataDBTable.COLUMN.API_ID.index);
                String apiName = Global.getFunctionName(apiId);
                long errNum = (Long)idata.get(FailedApiDataDBTable.COLUMN.ERROR_NUMBER.index);
                String errCode = null;
                try {
                    errCode = ErrorCodeManager.getInatance().getErrorCode(errNum).name();
                    if (errCode == null) {
                        errCode = SummaryLabels.FAILED_API_LIST_UNDEFINED_ERROR_NUMBER;
                    }
                }
                catch (NullPointerException e) {
                    Logger.exception((Throwable)e);
                    errCode = SummaryLabels.FAILED_API_LIST_UNDEFINED_ERROR_NUMBER;
                }
                if ((errMsg = ErrorCodeManager.getInatance().getErrorDescription(errNum)) == null) {
                    errMsg = SummaryLabels.FAILED_API_LIST_UNDEFINED_ERROR_NUMBER;
                }
                int index = 0;
                while (index < filterList.size()) {
                    switch (filterList.get(index).getColumnIndex()) {
                        case 1: {
                            if (timeFormat.toLowerCase().contains(filterList.get(index).getKeyWord().toLowerCase())) break;
                            break block19;
                        }
                        case 2: {
                            if (apiName.toLowerCase().contains(filterList.get(index).getKeyWord().toLowerCase())) break;
                            break block19;
                        }
                        case 5: {
                            if (errCode.toLowerCase().contains(filterList.get(index).getKeyWord().toLowerCase())) break;
                            break block19;
                        }
                        case 6: {
                            if (!errMsg.toLowerCase().contains(filterList.get(index).getKeyWord().toLowerCase())) break block19;
                        }
                    }
                    ++index;
                }
                ArrayList<String> text = new ArrayList<String>();
                ArrayList<Object> data = new ArrayList<Object>();
                Long seq = (Long)idata.get(FailedApiDataDBTable.COLUMN.SEQUENCE_NUMBER.index);
                text.add(Long.toString(seq));
                data.add(seq);
                text.add(timeFormat);
                data.add(time);
                text.add(apiName);
                data.add(apiName);
                String args = (String)idata.get(FailedApiDataDBTable.COLUMN.ARGUMENT.index);
                text.add(args);
                data.add(args);
                String retValue = (String)idata.get(FailedApiDataDBTable.COLUMN.RETURN_VALUE.index);
                text.add(retValue);
                data.add(retValue);
                text.add(errCode);
                data.add(errNum);
                text.add(errMsg);
                data.add(errNum);
                int pid = (Integer)idata.get(FailedApiDataDBTable.COLUMN.PID.index);
                text.add(Integer.toString(pid));
                data.add(pid);
                long callerPcAddr = (Long)idata.get(FailedApiDataDBTable.COLUMN.CALLER_PC_ADDRESS.index);
                data.add(callerPcAddr);
                String libName = (String)idata.get(FailedApiDataDBTable.COLUMN.CALLER_LIBRARY_NAME.index);
                data.add(libName);
                DATableDataFormat tableData = new DATableDataFormat(seq);
                ProbeCommonData probeData = new ProbeCommonData();
                probeData.setSeq(seq);
                probeData.setApiName(apiName);
                probeData.setPid(pid);
                probeData.setTime(time);
                probeData.setArgs(args);
                probeData.setReturn(retValue);
                probeData.setErrNo(errNum);
                probeData.setCallerAddress(callerPcAddr);
                probeData.setLibName(libName);
                probeData.setMsgID((Integer)idata.get(FailedApiDataDBTable.COLUMN.MESSAGE_ID.index));
                tableData.setLogData(probeData);
                tableData.getData().addAll(data);
                tableData.setType(2);
                TableInput tableInput = new TableInput();
                tableInput.setText(text);
                tableInput.setData(tableData);
                input.add(tableInput);
            }
            ++i;
        }
        return input;
    }

    private List<FilterProperty> getFilterList() {
        List<FilterProperty> filterList = this.getFilterPropertyList();
        if (!filterList.isEmpty()) {
            ArrayList<FilterProperty> filterListRep = new ArrayList<FilterProperty>();
            filterListRep.addAll(filterList);
            return filterListRep;
        }
        return filterList;
    }

    @Override
    protected List<String> convertFilterProperty2Query(List<FilterProperty> filterList) {
        ArrayList<String> queries = new ArrayList<String>();
        Iterator<FilterProperty> iter = filterList.iterator();
        while (iter.hasNext()) {
            FilterProperty prop = iter.next();
            String queryPrefix = this.getFilteredColumnName(prop.getColumnIndex());
            if (queryPrefix == null) continue;
            queries.add(this.makeFilterWhereClause(queryPrefix, prop.getKeyWord()));
            iter.remove();
        }
        return queries;
    }

    @Override
    protected String getFilteredColumnName(int index) {
        String columnName = null;
        switch (index) {
            case 3: {
                columnName = this.addLowerOperation(FailedApiDataDBTable.COLUMN.ARGUMENT.name);
                break;
            }
            case 4: {
                columnName = this.addLowerOperation(FailedApiDataDBTable.COLUMN.RETURN_VALUE.name);
                break;
            }
            case 7: {
                columnName = FailedApiDataDBTable.COLUMN.PID.name;
                break;
            }
        }
        return columnName;
    }
}

