/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.thread.chart.SyncChart;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadDataEvent;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class ThreadChart
extends SyncChart {
    private DAChartSeries threadLoadSeries;
    private DAChartSeries threadEventSeries;
    private DAChartSeries threadAPISeries;

    public ThreadChart(int chartId, DAChartBoardItem item, DAChart chart, int chartType) {
        super(chartId, item, chart, chartType);
    }

    @Override
    public void setItem(DAChartBoardItem item) {
        super.setItem(item);
        this.item = item;
        this.setChart(item.getChart());
        this.threadLoadSeries = new DAChartSeries(ThreadPageLabels.THREAD_CHART_SERIES_LOAD, 11, ColorResources.THREAD_GRAPH_MIN_CPU_LOAD_COLOR, ColorResources.THREAD_GRAPH_MAX_CPU_LOAD_COLOR);
        this.threadLoadSeries.setBarWidth(1L);
        this.threadAPISeries = new DAChartSeries(ThreadPageLabels.THREAD_CHART_SERIES_API, 8, ColorResources.YELLOW);
        this.threadEventSeries = new DAChartSeries(ThreadPageLabels.THREAD_CHART_SERIES_EVENT, 12, ColorResources.THREAD_GRAPH_CALLEE_COLOR);
        this.threadAPISeries.setSummarizeTooltipText(ThreadPageLabels.THREAD_TOOLTIP_APIS);
        this.threadEventSeries.setFont(FontResources.CHART_ARROW_TID_FONT);
        this.chart.addSeries(this.threadLoadSeries);
        this.chart.addSeries(this.threadAPISeries);
        this.chart.addSeries(this.threadEventSeries);
    }

    @Override
    public void clearSeries() {
        super.clearSeries();
        if (this.threadLoadSeries != null) {
            this.threadLoadSeries.clear();
        }
        if (this.threadEventSeries != null) {
            this.threadEventSeries.clear();
        }
        if (this.threadAPISeries != null) {
            this.threadAPISeries.clear();
        }
    }

    public void updateThreadSeries(List<ThreadPageThreadDataEvent> eventList) {
        for (ThreadPageThreadDataEvent threadEvent : eventList) {
            if (this.getChartType() != 2 || this.chartID != threadEvent.getThreadDataID()) continue;
            this.addThreadSeriesItem(threadEvent);
        }
        this.chart.redraw();
    }

    private void addThreadSeriesItem(ThreadPageThreadDataEvent threadEvent) {
        switch (threadEvent.getEventType()) {
            case 2: {
                this.updateLoadSeries(threadEvent);
                break;
            }
            case 1: {
                this.updateEventSeries(threadEvent);
                break;
            }
            case 0: {
                this.updateAPISeries(threadEvent);
                break;
            }
        }
    }

    private void updateLoadSeries(ThreadPageThreadDataEvent threadEvent) {
        DAChartSeriesItem seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), (double)threadEvent.getThreadType() * 2.55, threadEvent.getTooltipContent());
        this.threadLoadSeries.addSeriesItem(seriesItem);
    }

    private void updateEventSeries(ThreadPageThreadDataEvent threadEvent) {
        DAChartSeriesItem seriesItem;
        int eventApiType = threadEvent.getApiType();
        if (eventApiType == 6) {
            seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), -1.0, threadEvent.getTooltipContent());
            seriesItem.setBarWidth((double)threadEvent.getCallerTid());
        } else if (eventApiType == 5) {
            if (threadEvent.isJoinAPI()) {
                seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), -1.0, ThreadPageLabels.THREAD_CHART_ITEM_JOINED);
                seriesItem.setBarWidth((double)threadEvent.getCallerTid());
            } else {
                seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), 0.0, threadEvent.getTooltipContent());
            }
        } else if (eventApiType == 7) {
            if (threadEvent.getCallerTid() != -1) {
                seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), 1.0, threadEvent.getTooltipContent());
                seriesItem.setBarWidth((double)threadEvent.getCallerTid());
            } else {
                seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), 0.0, threadEvent.getTooltipContent());
            }
        } else {
            seriesItem = new DAChartSeriesItem(threadEvent.getDoubleTime(), 0.0, threadEvent.getTooltipContent());
        }
        this.threadEventSeries.addSeriesItem(seriesItem);
    }

    private void updateAPISeries(ThreadPageThreadDataEvent threadEvent) {
        long errorNum = threadEvent.getErrorNum();
        DAChartSeriesItem seriesItem = this.createAPIItem(threadEvent, errorNum);
        this.threadAPISeries.addSeriesItem(seriesItem);
    }

    private DAChartSeriesItem createAPIItem(ThreadPageThreadDataEvent event, long errno) {
        DAChartSeriesItem apiItem = null;
        apiItem = 0L != errno ? new DAChartSeriesItem(event.getDoubleTime(), 0.0, ColorResources.RED, String.valueOf(event.getTooltipContent()) + ThreadPageLabels.SYNC_CHART_ITEM_FAILED) : new DAChartSeriesItem(event.getDoubleTime(), 0.0, ColorResources.YELLOW, event.getTooltipContent());
        return apiItem;
    }
}

