/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class WebFunctionEntryDBTable
extends DBTable {
    public static final String TABLE_NAME = "WEB_FUNCTION_ENTRY";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.SEQUENCE_NUMBER.name) + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.FUNCTION_LINE_NUMBER.name + "," + COLUMN.FUNCTION_NAME.name + "," + COLUMN.FUNCTION_URL.name + "," + COLUMN.START_TIME.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "WEB_FUNCTION_ENTRY" + "  where " + COLUMN.START_TIME.name + " between %s and %s";

    public WebFunctionEntryDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_LINE_NUMBER.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_NAME.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_URL.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "NOT NULL", "BIGINT"));
        this.addIndex(COLUMN.START_TIME.index);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setInt(COLUMN.FUNCTION_LINE_NUMBER.index + 1, (Integer)rowData.get(COLUMN.FUNCTION_LINE_NUMBER.index));
                String functionStr = this.clipString((String)rowData.get(COLUMN.FUNCTION_NAME.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.FUNCTION_NAME.index + 1, functionStr);
                String functionURLStr = this.clipString((String)rowData.get(COLUMN.FUNCTION_URL.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.FUNCTION_URL.index + 1, functionURLStr);
                prep.setLong(COLUMN.START_TIME.index + 1, (Long)rowData.get(COLUMN.START_TIME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getString(5));
            row.add(rs.getString(6));
            row.add(rs.getLong(7));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return row;
    }

    public List<List<Object>> getWebFunctionEntryFromDB() {
        return this.selectAllColumnData(null);
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        TID(2, "TID"),
        FUNCTION_LINE_NUMBER(3, "FUNCTION_LINE_NUMBER"),
        FUNCTION_NAME(4, "FUNCTION_NAME"),
        FUNCTION_URL(5, "FUNCTION_URL"),
        START_TIME(6, "START_TIME");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

