/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.view;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class DAHidableViewComposite
extends DAViewComposite {
    private Label hiddenStateLabel;
    private StackLayout layout = new StackLayout();
    private Composite dataComp;
    private Composite baseComp;

    public DAHidableViewComposite(Composite parent, int style, boolean titleVisibilty, String hiddenStateText) {
        super(parent, style, titleVisibilty);
        this.setLayout((Layout)new FillLayout());
        this.contentArea.setLayout((Layout)new FillLayout());
        this.baseComp = new Composite(this.contentArea, 0);
        this.baseComp.setLayout((Layout)this.layout);
        this.baseComp.setBackgroundMode(1);
        this.baseComp.setBackground(ColorResources.WHITE);
        this.hiddenStateLabel = new Label(this.baseComp, 0);
        this.hiddenStateLabel.setText(hiddenStateText);
        this.hiddenStateLabel.setFont(FontResources.TABLE_HEADER_FONT);
        this.hiddenStateLabel.setForeground(ColorResources.TABLE_HEADER_FONT_COLOR);
        this.hiddenStateLabel.setAlignment(0x1000000);
        this.layout.topControl = this.hiddenStateLabel;
    }

    @Override
    public Composite getContentArea() {
        return this.baseComp;
    }

    public void setDataComposite(Composite dataComp) {
        this.dataComp = dataComp;
    }

    public void hide(boolean hide) {
        this.layout.topControl = hide ? this.hiddenStateLabel : this.dataComp;
        this.baseComp.layout();
    }

    public void show() {
        this.hide(false);
    }

    public void hide() {
        this.hide(true);
    }

    public boolean isHidden() {
        return this.layout.topControl == this.hiddenStateLabel;
    }

    public void setLabelText(String text) {
        this.hiddenStateLabel.setText(text);
    }
}

