/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.checkbox;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckboxSelectionListener;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACheckBox
extends Canvas {
    public static final int CHECKBOX_SELECTED = 0;
    public static final int CHECKBOX_UNSELECTED = 1;
    public static final int CHECKBOX_UNSELECTED_HOVER = 2;
    public static final int CHECKBOX_SELECTED_DISABLE = 3;
    public static final int CHECKBOX_UNSELECTED_DISABLE = 4;
    private int state = 1;
    private String text = null;
    private PaintListener checkboxPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DACheckBox me = (DACheckBox)e.widget;
            Rectangle rect = me.getClientArea();
            Image img = null;
            if (DACheckBox.this.state == 0) {
                img = ImageResources.CHECKBOX_SELECTED;
            } else if (DACheckBox.this.state == 2) {
                img = ImageResources.CHECKBOX_UNSELECTED_HOVER;
            } else if (DACheckBox.this.state == 1) {
                img = ImageResources.CHECKBOX_UNSELECTED;
            } else if (DACheckBox.this.state == 4) {
                img = ImageResources.CHECKBOX_UNSELECTED_DISABLE;
            } else if (DACheckBox.this.state == 3) {
                img = ImageResources.CHECKBOX_SELECTED_DISABLE;
            } else {
                return;
            }
            Rectangle imgRect = img.getBounds();
            int x = 0;
            int y = (rect.height - imgRect.height) / 2;
            if (DACheckBox.this.getBackground() != null) {
                e.gc.setBackground(DACheckBox.this.getBackground());
            }
            e.gc.fillRectangle(rect);
            e.gc.drawImage(img, x, y);
            if (DACheckBox.this.state == 3 || DACheckBox.this.state == 4) {
                e.gc.setForeground(ColorResources.CHECKBOX_DISABLED_FONT_COLOR);
            } else if (DACheckBox.this.getForeground() != null) {
                e.gc.setForeground(DACheckBox.this.getForeground());
            } else {
                e.gc.setForeground(ColorResources.BLACK);
            }
            int fontHeight = e.gc.getFontMetrics().getHeight();
            x = imgRect.width + 4;
            y = (rect.height - fontHeight) / 2;
            e.gc.drawText(DACheckBox.this.text, x, y);
        }
    };
    protected Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (DACheckBox.this.state == 3 || DACheckBox.this.state == 4) {
                return;
            }
            if (event.type == 6 && DACheckBox.this.state != 0) {
                DACheckBox.this.state = 2;
            }
            if (event.type == 7 && DACheckBox.this.state != 0) {
                DACheckBox.this.state = 1;
            }
            if (event.type == 32 && DACheckBox.this.state != 0) {
                DACheckBox.this.state = 2;
            }
            if (event.type == 4) {
                DACheckBox.this.state = 0;
            }
            DACheckBox.this.redraw();
        }
    };

    public DACheckBox(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this.checkboxPaintListener);
        this.addListener(6, this.mouseListener);
        this.addListener(7, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.text = "";
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setChecked(boolean checked) {
        this.state = checked ? 0 : 1;
    }

    public void setCheckboxEnabled(boolean enabled) {
        this.state = this.state == 0 || this.state == 3 ? (enabled ? 0 : 3) : (enabled ? 1 : 4);
        this.redraw();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setCheckboxEnabled(enabled);
    }

    public boolean isCheckboxEnabled() {
        return this.state != 3 && this.state != 4;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Image img = ImageResources.CHECKBOX_SELECTED;
        GC gc = new GC((Drawable)this);
        Point textSize = gc.stringExtent(this.text);
        Rectangle imgBounds = img.getBounds();
        return new Point(imgBounds.width + 4 + textSize.x, Math.max(gc.getFontMetrics().getHeight(), imgBounds.height));
    }

    public void addSelectionListener(DACheckboxSelectionListener listener) {
        this.addListener(4, listener);
    }
}

