/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.common.UIMode;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.protocol.Protocol;

public class Global {
    private static UIMode currentUIMode = UIMode.GUI;
    private static DeviceInfo currentDevice = null;
    private static AppInfo currentApplication = null;
    private static Project currentProject = null;
    private static volatile boolean lsanInitSucceeded = false;

    public static boolean isLSanInitialized() {
        return lsanInitSucceeded;
    }

    public static void setLSanInitialized(boolean initSucceeded) {
        lsanInitSucceeded = initSucceeded;
    }

    public static UIMode getCurrentUIMode() {
        return currentUIMode;
    }

    public static void setCurrentUIMode(UIMode uiMode) {
        currentUIMode = uiMode;
    }

    public static boolean isGUIMode() {
        return currentUIMode == UIMode.GUI;
    }

    public static boolean isCLIMode() {
        return currentUIMode == UIMode.CLI;
    }

    public static DeviceInfo getCurrentDeviceInfo() {
        return currentDevice;
    }

    public static void setCurrentDeviceInfo(DeviceInfo device) {
        currentDevice = device;
    }

    public static AppInfo getCurrentApplication() {
        return currentApplication;
    }

    public static void setCurrentApplication(AppInfo pkgInfo) {
        currentApplication = pkgInfo;
    }

    public static Project getProject() {
        return currentProject;
    }

    public static void setProject(Project p) {
        currentProject = p;
    }

    public static Protocol getCurrentProtocol() {
        if (currentProject != null && currentProject.getProtocolVersion() != null) {
            return Protocol.getVersion(currentProject.getProtocolVersion());
        }
        if (currentDevice != null && currentDevice.getCommunicator().getProtocolVersion() != null) {
            return Protocol.getVersion(currentDevice.getCommunicator().getProtocolVersion());
        }
        return Protocol.VERSION_UNKNOWN;
    }

    public static String getFunctionName(int id) {
        if (currentProject != null) {
            return currentProject.getFunctionName(id);
        }
        return null;
    }

    public static int getFunctionID(String name) {
        if (currentProject != null) {
            return currentProject.getFunctionID(name);
        }
        return -2;
    }

    public static ImageInfo getLeastImageInfoByTime(long time) {
        if (currentProject != null) {
            return currentProject.getLeastImageInfoByTime(time);
        }
        return null;
    }

    public static ImageInfo getGreatestImageInfoByTime(long time) {
        if (currentProject != null) {
            return currentProject.getGreatestImageInfoByTime(time);
        }
        return null;
    }

    public static ImageInfo getPrevImageInfo(ImageInfo info) {
        if (currentProject != null) {
            return currentProject.getPrevImageInfo(info);
        }
        return null;
    }

    public static ImageInfo getNextImageInfo(ImageInfo info) {
        if (currentProject != null) {
            return currentProject.getNextImageInfo(info);
        }
        return null;
    }

    public static Set<Map.Entry<Long, ImageInfo>> getImageInfoSet() {
        if (currentProject != null) {
            return currentProject.getImageInfoSet();
        }
        return null;
    }

    public static int getBinaryID(int pid, long time, long address) {
        if (currentProject != null) {
            return currentProject.getBinaryID(pid, time, address);
        }
        return -2;
    }

    public static String getLibraryName(int binaryID) {
        if (binaryID >= 0 && currentProject != null) {
            return currentProject.getDeviceStatusInfo().getBinaryInfo(binaryID).getTargetBinaryPath();
        }
        return "unknown";
    }
}

