/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol.p41;

import java.io.File;
import java.util.Set;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.AckMessage;
import org.tizen.dynamicanalyzer.communicator.BaseCommunicator;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.communicator.ProtocolSerializer;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.protocol.p40.Communicator40;
import org.tizen.dynamicanalyzer.protocol.p41.ProtocolConfig41;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.communicator.SwapErrorCode;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.DownloadContentfileManager;

public class Communicator41
extends Communicator40 {
    public Communicator41(BaseCommunicator parent) {
        super(parent);
    }

    @Override
    public DAResult sendConfigurationMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(4);
        Set<FlatFeature> selectedFeatures = SettingDataManager.INSTANCE.getSelectedFlatFeatureSet();
        Set<FlatPreferences> selectedPreferences = SettingDataManager.INSTANCE.getSelectedPreferenceSet();
        byte[] featureFlag = ProtocolConfig41.getFlatFeatureFlagValue(selectedFeatures, selectedPreferences);
        ps.putByteArray(featureFlag);
        int systemPeriod = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.SYSTEM_SAMPLING_RATE);
        int samplingPeriod = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.FUNCTION_SAMPLING_RATE);
        ps.putInt(systemPeriod);
        ps.putInt(samplingPeriod);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isSuccess() && result.isCorrectID(4100)) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_CONFIG_FAILED);
    }

    @Override
    public DAResult sendUIHierarchyMessage(IProgress progress, int requestOption) throws UnsupportedProtocolException {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(18);
        ps.putByte((byte)requestOption);
        byte[] msg = ps.toByteArray();
        AckMessage ack = this.parent.handleControlMessage(msg, 0);
        if (ack == null || !ack.isCorrectID(4114)) {
            return new DAResult(DAResult.ErrorCode.ERR_RECEIVE_ACK_FAIL);
        }
        if (ack.isSuccess()) {
            return DAResult.SUCCESS;
        }
        return new DAResult(DAResult.ErrorCode.ERR_UIHIERARCHY_GET_FAIL);
    }

    @Override
    public DAResult sendUIScreenshotMessage(IProgress progress, long uiObjectAddress) throws UnsupportedProtocolException {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(19);
        ps.putLong(uiObjectAddress);
        byte[] msg = ps.toByteArray();
        AckMessage ack = this.parent.handleControlMessage(msg, 0);
        if (ack == null || !ack.isCorrectID(4115)) {
            return new DAResult(DAResult.ErrorCode.ERR_RECEIVE_ACK_FAIL);
        }
        if (ack.isSuccess()) {
            ProtocolParser parser = new ProtocolParser(ack.getPayload());
            parser.getInt();
            String from = parser.getString();
            String fileName = Long.toString(uiObjectAddress);
            String to = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + fileName;
            if (!DownloadContentfileManager.pullFile(from, to)) {
                return new DAResult(DAResult.ErrorCode.ERR_DOWNLOAD_FILE_FAILED);
            }
        } else {
            if (ack.getReturnCode() == SwapErrorCode.ERR_UI_OBJECT_CAN_NOT_TAKE_SCREENSHOT.getErrorNumber()) {
                return new DAResult(DAResult.ErrorCode.ERR_UI_OBJECT_CAN_NOT_TAKE_SCREENSHOT);
            }
            if (ack.getReturnCode() == SwapErrorCode.ERR_UI_OBJECT_NOT_FOUND.getErrorNumber()) {
                return new DAResult(DAResult.ErrorCode.ERR_UI_OBJECT_NOT_FOUND);
            }
        }
        return DAResult.SUCCESS;
    }

    @Override
    public DAResult sendUIHierarchyCancelMessage(IProgress progress) throws UnsupportedProtocolException {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(20);
        byte[] msg = ps.toByteArray();
        AckMessage ack = this.parent.handleControlMessage(msg, 0);
        if (ack == null || !ack.isCorrectID(4116)) {
            return new DAResult(DAResult.ErrorCode.ERR_RECEIVE_ACK_FAIL);
        }
        if (ack.isSuccess()) {
            Logger.info((Object)"Cancel is successed.");
            return DAResult.SUCCESS;
        }
        Logger.warning((Object)("sendUIHierarchyCancelMessage is failed with error (" + ack.getReturnCode() + ")"));
        return new DAResult(DAResult.ErrorCode.ERR_UIHIERARCHY_GET_CANCEL_FAIL);
    }
}

