/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tizen.dynamicanalyzer.swap.model.data.WebProfileData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfilingData;
import org.tizen.dynamicanalyzer.util.Logger;

public class WebProfileDataMaker {
    private int pid = 0;
    private WebProfilingData appBin = null;
    private Map<Integer, WebProfilingData> currentFunctionTidMap = new HashMap<Integer, WebProfilingData>();
    private Map<String, Integer> symbolIDMap = new ConcurrentHashMap<String, Integer>();
    private Map<Integer, WebProfilingData> profilingDataMap = new ConcurrentHashMap<Integer, WebProfilingData>();

    public WebProfileDataMaker(int pid) {
        this.pid = pid;
    }

    public void makeWebFunctionUsageProfileData(WebProfileData log) {
        long exeTime = 0L;
        int type = log.getMsgID();
        int tid = log.getTid();
        WebProfilingData function = null;
        if (type == 21) {
            if (this.appBin == null) {
                this.appBin = new WebProfilingData(FunctionUsageProfiler.APPLICATION);
                this.profilingDataMap.put(this.appBin.getProfilingDataID(), this.appBin);
                function = this.makeWebProfilingData(log);
                this.currentFunctionTidMap.put(log.getTid(), function);
            } else {
                Integer profilingDataID = this.symbolIDMap.get(log.generateFunctionKey());
                if (profilingDataID == null) {
                    function = this.makeWebProfilingData(log);
                } else {
                    function = this.profilingDataMap.get(profilingDataID);
                    function.initRelationData();
                    function.addCallCount();
                    function.setStartTime(log.getTime());
                }
                WebProfilingData current = this.currentFunctionTidMap.get(tid);
                if (current != null) {
                    function.setParent(current);
                } else {
                    Logger.debug((Object)"Current function does not exist");
                }
                this.currentFunctionTidMap.put(log.getTid(), function);
            }
        } else if (type == 22) {
            Integer profilingDataID;
            WebProfilingData current = this.currentFunctionTidMap.get(tid);
            if (current == null || !current.getFunctionName().equals(log.getFunctionName())) {
                Logger.debug((Object)("exit without entry or EXIT self is not the same as top of user callstack :" + log.getFunctionName()));
                return;
            }
            long startTime = current.getStartTime();
            if (startTime != -1L) {
                exeTime = log.getTime() - startTime;
                current.initStartTime();
            }
            if ((profilingDataID = this.symbolIDMap.get(current.generateFunctionKey())) != null) {
                function = this.profilingDataMap.get(profilingDataID);
                function.addElapsedTime(exeTime);
                function.addExclusiveElapsedTime(current.getExclusiveExeTime());
            } else {
                Logger.debug((Object)("Function entry for " + current.generateFunctionKey() + " is not found"));
            }
            WebProfilingData parent = current.getParent();
            if (parent != null) {
                parent.addChildExeTime(current.getLastElapsedTime());
            } else {
                Logger.debug((Object)("Parent profilingData of " + current.generateFunctionKey() + " is not found"));
            }
            this.currentFunctionTidMap.put(log.getTid(), current.getParent());
            current.initRelationData();
        }
    }

    private WebProfilingData makeWebProfilingData(WebProfileData log) {
        WebProfilingData function = new WebProfilingData(log);
        this.symbolIDMap.put(log.generateFunctionKey(), function.getProfilingDataID());
        this.profilingDataMap.put(function.getProfilingDataID(), function);
        this.appBin.addChildrenWebProfilingDataID(function.getProfilingDataID());
        function.addCallCount();
        return function;
    }

    public WebProfilingData getAppBin() {
        return this.appBin;
    }

    public void setAppBin(WebProfilingData appBin) {
        this.appBin = appBin;
    }

    public Map<Integer, WebProfilingData> webProfilingDataMap() {
        return this.profilingDataMap;
    }

    public List<WebProfilingData> getChildList(List<Integer> profilingDataIDList) {
        ArrayList<WebProfilingData> output = new ArrayList<WebProfilingData>();
        int i = 0;
        while (i < profilingDataIDList.size()) {
            WebProfilingData function = this.profilingDataMap.get(profilingDataIDList.get(i));
            if (function != null) {
                output.add(function);
            }
            ++i;
        }
        return output;
    }
}

