/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;

public class LicenseDialog {
    private Shell parent = null;
    private Shell shell = null;
    private DACustomButton okButton = null;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            LicenseDialog.this.shell.dispose();
        }
    };

    public LicenseDialog(Shell parent) {
        this.parent = parent;
    }

    private String getLicenseString() {
        StringBuffer ret;
        block9: {
            String configFileName = "license";
            ret = new StringBuffer("");
            File configFolder = new File(PathManager.DA_CONFIG_FOLDER_PATH);
            if (!configFolder.isDirectory()) {
                return AnalyzerLabels.LICENSE_DIALOG_NOT_FOUND;
            }
            File configFile = new File(configFolder, configFileName);
            if (!configFile.isFile()) {
                return AnalyzerLabels.LICENSE_DIALOG_NOT_FOUND;
            }
            BufferedReader in = null;
            try {
                String content;
                in = new BufferedReader(new FileReader(configFile));
                while ((content = in.readLine()) != null) {
                    ret.append(content);
                    ret.append(CommonConstants.NEW_LINE);
                }
            }
            catch (FileNotFoundException e) {
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
        return ret.toString();
    }

    public int open() {
        this.shell = new Shell(this.parent, 67680);
        this.shell.setSize(608, 460);
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setText(AnalyzerLabels.LICENSE);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        Composite base = new Composite((Composite)this.shell.getShell(), 0);
        base.setLayout((Layout)new FormLayout());
        base.setVisible(true);
        base.setBackground(ColorResources.DIALOG_BG_UPPER);
        FormData baseData = new FormData();
        baseData.top = new FormAttachment(0, 0);
        baseData.left = new FormAttachment(0, 0);
        baseData.right = new FormAttachment(100, 0);
        baseData.bottom = new FormAttachment(100, 0);
        base.setLayoutData((Object)baseData);
        Label icon = new Label(base, 0x40000000);
        icon.setImage(ImageResources.LICENSE_TIZEN_SDK);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.height = 80;
        icon.setLayoutData((Object)layoutData);
        Text contents = new Text(base, 74);
        contents.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        contents.setBackground(ColorResources.DIALOG_BG_UPPER);
        contents.setFont(FontResources.LICENSE_TEXT);
        contents.setText(this.getLicenseString());
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 18);
        layoutData.right = new FormAttachment(100, -18);
        layoutData.top = new FormAttachment((Control)icon, 18);
        layoutData.height = 287;
        contents.setLayoutData((Object)layoutData);
        Composite buttonComp = new Composite(base, 0);
        FormLayout compLayout = new FormLayout();
        buttonComp.setLayout((Layout)compLayout);
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)contents, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.height = 51;
        buttonComp.setLayoutData((Object)compData);
        this.okButton = new DAButton(buttonComp, 0);
        this.okButton.addClickListener(this.okButtonListener);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData okData = new FormData();
        okData.top = new FormAttachment(0, 9);
        okData.right = new FormAttachment(100, -9);
        okData.width = 86;
        okData.height = 24;
        this.okButton.setLayoutData((Object)okData);
        this.shell.open();
        return 0;
    }
}

