/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.util.Logger;

public class ImageUtilSWT {
    private static ImageData rotateImageData(ImageData srcData, int direction) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int width = 0;
        int height = 0;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        width = srcData.width;
                        height = srcData.height;
                    }
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(width, height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    private static void saveFile(Image image, String filePath) {
        if (filePath == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            try {
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{image.getImageData()};
                fos = new FileOutputStream(filePath, false);
                loader.save((OutputStream)fos, 5);
            }
            catch (FileNotFoundException ex) {
                Logger.exception((Throwable)ex);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                }
            }
            catch (Exception ex) {
                Logger.exception((Throwable)ex);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                }
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
    }

    private static Image createResizedImage(Image imageOrigin, int width, int height) {
        if (imageOrigin == null) {
            return null;
        }
        ImageData imageDataSrc = imageOrigin.getImageData();
        ImageData imageDataDst = (ImageData)imageDataSrc.clone();
        imageDataDst = imageDataDst.scaledTo(width, height);
        return new Image((Device)Display.getDefault(), imageDataDst);
    }

    public static void transform(String originFilePath, String newFilePath, int width, int height, int angle) {
        Image img = null;
        ImageData newImageData = null;
        try {
            img = new Image((Device)Display.getDefault(), originFilePath);
            Image scaledImage = ImageUtilSWT.createResizedImage(img, width, height);
            if (angle == 0) {
                newImageData = scaledImage.getImageData();
            } else if (angle == 90) {
                newImageData = ImageUtilSWT.rotateImageData(scaledImage.getImageData(), 131072);
            } else if (angle == 270) {
                newImageData = ImageUtilSWT.rotateImageData(scaledImage.getImageData(), 16384);
            } else if (angle == 180) {
                newImageData = ImageUtilSWT.rotateImageData(scaledImage.getImageData(), 1024);
            }
            Image newImage = new Image((Device)Display.getDefault(), newImageData);
            ImageUtilSWT.saveFile(newImage, newFilePath);
        }
        catch (IllegalArgumentException e) {
            Logger.exception((Throwable)e);
        }
        catch (SWTError err) {
            Logger.exception((Throwable)err);
        }
        catch (SWTException e) {
            Logger.exception((Throwable)e);
        }
    }

    public static void resize(String originFilePath, String newFilePath, int width, int height) {
        Image img = null;
        try {
            img = new Image((Device)Display.getDefault(), originFilePath);
            Image scaledImage = ImageUtilSWT.createResizedImage(img, width, height);
            ImageUtilSWT.saveFile(scaledImage, newFilePath);
        }
        catch (IllegalArgumentException e) {
            Logger.exception((Throwable)e);
        }
        catch (SWTError err) {
            Logger.exception((Throwable)err);
        }
        catch (SWTException e) {
            Logger.exception((Throwable)e);
        }
    }
}

