/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class CallstackTable
extends DATableComposite {
    static final List<String> forbiddenViewId = new ArrayList<String>(Arrays.asList(FilePage.chartViewID, GLPage.chartViewID, GLPage.contextViewID, "contextHistoryID.id", GLPage.programViewID, GLPage.statisticsViewID, GLPage.redundantViewID, GLPage.textureViewID, SummaryPage.profilingViewID));

    public CallstackTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AnalyzerManager.getCurrentPage().updateView(new DAViewData(TimelineTableView.callstackViewID, null));
                GridItem[] sels = CallstackTable.this.table.getSelection();
                if (sels.length <= 0) {
                    return;
                }
                CallstackTable.this.table.setFocusItem(sels[0]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.applyFilterImage();
    }

    @Override
    public void updateTable() {
    }

    public void updateCallstackTable(DASelectionData selData) {
        this.table.removeAll();
        if (selData == null) {
            return;
        }
        String viewId = selData.getViewID();
        if (viewId == null || viewId.isEmpty() || forbiddenViewId.contains(viewId)) {
            return;
        }
        Object obj = selData.getData();
        if (obj instanceof GridItem[]) {
            GridItem[] items = (GridItem[])obj;
            if (items.length <= 0) {
                return;
            }
            DATableDataFormat tableData = (DATableDataFormat)items[0].getData();
            List<CallStackUnit> callStack = this.getCallStack(tableData);
            if (callStack.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < callStack.size()) {
                String hexAddr = Formatter.toHexString(Long.toString(callStack.get(i).getAddr()));
                CallStackUnit api = callStack.get(i);
                if (api == null || api.getPath() == null) {
                    Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not found"));
                    return;
                }
                String path = api.getPath();
                GridItem gridItem = new GridItem(this.table, 0);
                long address = api.getAddr();
                DATableDataFormat callstackTableData = new DATableDataFormat(address);
                callstackTableData.setType(1);
                callstackTableData.setObject(address);
                gridItem.setData((Object)callstackTableData);
                gridItem.setData("address", (Object)address);
                gridItem.setData("pid", (Object)api.getPid());
                gridItem.setData("time", (Object)api.getTime());
                gridItem.setData("libName", (Object)path);
                String addrInput = api.getAddr() == 0L ? "" : hexAddr;
                gridItem.setText(1, addrInput.toLowerCase());
                String fName = api.getFunctionName();
                gridItem.setText(0, fName);
                gridItem.setText(2, path);
                ++i;
            }
        }
    }

    private List<CallStackUnit> getCallStack(DATableDataFormat tableData) {
        long time;
        int pid;
        if (!DAState.isStartable()) {
            return Collections.emptyList();
        }
        int tid = -1;
        if (tableData.getType() == 2) {
            List<Object> failedData = tableData.getData();
            pid = (Integer)failedData.get(7);
            time = (Long)failedData.get(1);
        } else if (tableData.getType() == 4) {
            List<Object> leakData = tableData.getData();
            pid = (Integer)leakData.get(2);
            time = (Long)leakData.get(4);
        } else if (tableData.getType() == 32) {
            List<Object> calltraceData = tableData.getData();
            pid = (Integer)calltraceData.get(FunctionEntryDBTable.COLUMN.PID.index);
            time = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
            tid = (Integer)calltraceData.get(FunctionEntryDBTable.COLUMN.TID.index);
        } else {
            if (tableData.getType() == 2048) {
                return Collections.emptyList();
            }
            LogData logData = tableData.getLogData();
            pid = logData.getPid();
            time = logData.getTime();
        }
        if (tid == -1) {
            tid = pid;
        }
        return CallTraceDataManager.getInstance().getCallstackForTable(pid, tid, time);
    }

    @Override
    protected List<TableInput> makeTableInput() {
        return null;
    }
}

