/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.jface.viewers.TreePath;

public class ChildrenUpdate
extends ViewerUpdateMonitor
implements IChildrenUpdate {
    private Object[] fElements;
    private int fIndex;
    private int fLength;

    public ChildrenUpdate(TreeModelContentProvider provider, Object viewerInput, TreePath elementPath, Object element, int index, IElementContentProvider elementContentProvider) {
        super(provider, viewerInput, elementPath, element, elementContentProvider, provider.getPresentationContext());
        this.fIndex = index;
        this.fLength = 1;
    }

    public ChildrenUpdate(TreeModelContentProvider provider, Object viewerInput, TreePath elementPath, Object element, int index, int length, IElementContentProvider elementContentProvider) {
        super(provider, viewerInput, elementPath, element, elementContentProvider, provider.getPresentationContext());
        this.fIndex = index;
        this.fLength = length;
    }

    protected void performUpdate(boolean updateFilterOnly) {
        TreeModelContentProvider provider = this.getContentProvider();
        TreePath elementPath = this.getElementPath();
        if (this.fElements != null) {
            IInternalTreeModelViewer viewer = provider.getViewer();
            int i = 0;
            while (i < this.fElements.length) {
                int modelIndex = this.fIndex + i;
                Object element = this.fElements[i];
                if (element != null) {
                    int viewIndex = provider.modelToViewIndex(elementPath, modelIndex);
                    if (provider.shouldFilter(elementPath, element)) {
                        if (provider.addFilteredIndex(elementPath, modelIndex, element) && !updateFilterOnly) {
                            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                                DebugUIPlugin.trace("REMOVE(" + this.getElement() + ", modelIndex: " + modelIndex + " viewIndex: " + viewIndex + ", " + element + ")");
                            }
                            viewer.remove(elementPath, viewIndex);
                        }
                    } else {
                        if (provider.isFiltered(elementPath, modelIndex)) {
                            provider.clearFilteredChild(elementPath, modelIndex);
                            if (!updateFilterOnly) {
                                int insertIndex = provider.modelToViewIndex(elementPath, modelIndex);
                                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER) {
                                    DebugUIPlugin.trace("insert(" + this.getElement() + ", modelIndex: " + modelIndex + " insertIndex: " + insertIndex + ", " + element + ")");
                                }
                                viewer.insert(elementPath, element, insertIndex);
                            }
                        } else if (!updateFilterOnly) {
                            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                                DebugUIPlugin.trace("replace(" + this.getElement() + ", modelIndex: " + modelIndex + " viewIndex: " + viewIndex + ", " + element + ")");
                            }
                            viewer.replace(elementPath, viewIndex, element);
                        }
                        if (!updateFilterOnly) {
                            TreePath childPath = elementPath.createChildPath(element);
                            provider.updateHasChildren(childPath);
                            provider.getStateTracker().restorePendingStateOnUpdate(childPath, modelIndex, false, false, false);
                        }
                    }
                }
                ++i;
            }
            if (!updateFilterOnly) {
                provider.getStateTracker().restorePendingStateOnUpdate(elementPath, -1, true, true, true);
            }
        } else if (!updateFilterOnly) {
            provider.updateHasChildren(elementPath);
        }
    }

    @Override
    protected void performUpdate() {
        this.performUpdate(false);
    }

    @Override
    public void setChild(Object child, int index) {
        if (this.fElements == null) {
            this.fElements = new Object[this.fLength];
        }
        this.fElements[index - this.fIndex] = child;
    }

    @Override
    public synchronized boolean coalesce(ViewerUpdateMonitor request) {
        if (request instanceof ChildrenUpdate) {
            ChildrenUpdate cu = (ChildrenUpdate)request;
            if (this.getElement().equals(cu.getElement()) && this.getElementPath().equals((Object)cu.getElementPath())) {
                int end = this.fIndex + this.fLength;
                int otherStart = cu.getOffset();
                int otherEnd = otherStart + cu.getLength();
                if (otherStart >= this.fIndex && otherStart <= end || otherEnd >= this.fIndex && otherEnd <= end) {
                    this.fIndex = Math.min(this.fIndex, otherStart);
                    end = Math.max(end, otherEnd);
                    this.fLength = end - this.fIndex;
                    if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                        DebugUIPlugin.trace("coalesced: " + this.toString());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    boolean containsUpdate(TreePath path) {
        return this.getElementPath().equals((Object)path);
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getOffset() {
        return this.fIndex;
    }

    @Override
    void startRequest() {
        this.getElementContentProvider().update(new IChildrenUpdate[]{this});
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IChildrenUpdate: ");
        buf.append(this.getElement());
        buf.append(" {");
        buf.append(this.getOffset());
        buf.append("->");
        buf.append(this.getOffset() + this.getLength() - 1);
        buf.append("}");
        return buf.toString();
    }

    @Override
    int getPriority() {
        return 3;
    }

    @Override
    TreePath getSchedulingPath() {
        return this.getElementPath();
    }

    void setOffset(int offset) {
        this.fIndex = offset;
    }

    Object[] getElements() {
        return this.fElements;
    }

    @Override
    protected boolean doEquals(ViewerUpdateMonitor update) {
        return update instanceof ChildrenUpdate && ((ChildrenUpdate)update).getOffset() == this.getOffset() && ((ChildrenUpdate)update).getLength() == this.getLength() && this.getViewerInput().equals(update.getViewerInput()) && this.getElementPath().equals((Object)update.getElementPath());
    }

    @Override
    protected int doHashCode() {
        return (int)Math.pow((this.getClass().hashCode() + this.getViewerInput().hashCode() + this.getElementPath().hashCode()) * (this.getOffset() + 2), this.getLength() + 2);
    }
}

