/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.CommentHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.OffsetHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTCommenter {
    public static NodeCommentMap getCommentedNodeMap(IASTTranslationUnit transUnit) {
        if (transUnit == null) {
            return new NodeCommentMap();
        }
        ArrayList<IASTComment> comments = ASTCommenter.removeNotNeededComments(transUnit);
        if (comments == null || comments.size() == 0) {
            return new NodeCommentMap();
        }
        return ASTCommenter.addCommentsToCommentMap(transUnit, comments);
    }

    private static ArrayList<IASTComment> removeNotNeededComments(IASTTranslationUnit transUnit) {
        ArrayList<IASTComment> comments = ASTCommenter.getCommentsInWorkspace(transUnit);
        if (comments == null || comments.size() == 0) {
            return null;
        }
        ArrayList<IASTComment> com = ASTCommenter.removeAllPreprocessorComments(transUnit, comments);
        return com;
    }

    private static ArrayList<IASTComment> getCommentsInWorkspace(IASTTranslationUnit tu) {
        IASTComment[] comments = tu.getComments();
        ArrayList<IASTComment> commentsInWorkspace = new ArrayList<IASTComment>();
        if (comments == null || comments.length == 0) {
            return null;
        }
        IASTComment[] iASTCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            if (ASTCommenter.isInWorkspace(comment)) {
                commentsInWorkspace.add(comment);
            }
            ++n2;
        }
        return commentsInWorkspace;
    }

    private static ArrayList<IASTComment> removeAllPreprocessorComments(IASTTranslationUnit tu, ArrayList<IASTComment> comments) {
        String fileName;
        IASTPreprocessorStatement[] preprocessorStatements = tu.getAllPreprocessorStatements();
        TreeMap<Integer, String> treeOfPreProcessorLines = new TreeMap<Integer, String>();
        TreeMap<String, ArrayList<Integer>> ppOffsetForFiles = new TreeMap<String, ArrayList<Integer>>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocessorStatements;
        int n = preprocessorStatements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (ASTCommenter.isInWorkspace(statement)) {
                fileName = statement.getFileLocation().getFileName();
                treeOfPreProcessorLines.put(OffsetHelper.getStartingLineNumber(statement), fileName);
                ArrayList<Integer> offsetList = (ArrayList<Integer>)ppOffsetForFiles.get(fileName);
                if (offsetList == null) {
                    offsetList = new ArrayList<Integer>();
                    ppOffsetForFiles.put(fileName, offsetList);
                }
                offsetList.add(((ASTNode)((Object)statement)).getOffset());
            }
            ++n2;
        }
        ArrayList<IASTComment> commentsInCode = new ArrayList<IASTComment>();
        for (IASTComment comment : comments) {
            int comStartLineNumber = OffsetHelper.getStartingLineNumber(comment);
            fileName = comment.getFileLocation().getFileName();
            if (treeOfPreProcessorLines.containsKey(comStartLineNumber) && ((String)treeOfPreProcessorLines.get(comStartLineNumber)).equals(fileName) || ASTCommenter.commentIsAtTheBeginningBeforePreprocessorStatements(comment, (ArrayList)ppOffsetForFiles.get(fileName), tu)) continue;
            commentsInCode.add(comment);
        }
        return commentsInCode;
    }

    private static boolean commentIsAtTheBeginningBeforePreprocessorStatements(IASTComment comment, ArrayList<Integer> listOfPreProcessorOffset, IASTTranslationUnit tu) {
        if (listOfPreProcessorOffset == null) {
            return false;
        }
        if (comment.getTranslationUnit() == null || comment.getTranslationUnit().getDeclarations().length < 1) {
            return true;
        }
        IASTDeclaration decl = comment.getTranslationUnit().getDeclarations()[0];
        String commentFileName = comment.getFileLocation().getFileName();
        boolean sameFile = decl.getFileLocation().getFileName().equals(commentFileName);
        int commentNodeOffset = ((ASTNode)((Object)comment)).getOffset();
        if (sameFile && decl.getFileLocation().getNodeOffset() < commentNodeOffset) {
            return false;
        }
        Collections.sort(listOfPreProcessorOffset);
        int nextPPOfset = -1;
        for (Integer integer : listOfPreProcessorOffset) {
            if (integer <= commentNodeOffset) continue;
            nextPPOfset = integer;
            PPRangeChecker visti = new PPRangeChecker(true, nextPPOfset, commentNodeOffset);
            tu.accept(visti);
            if (!visti.isPrePPComment) continue;
            return true;
        }
        return false;
    }

    private static boolean isInWorkspace(IASTNode node) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Path nodePath = new Path(node.getContainingFilename());
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().isPrefixOf((IPath)nodePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static NodeCommentMap addCommentsToCommentMap(IASTTranslationUnit rootNode, ArrayList<IASTComment> comments) {
        NodeCommentMap commentMap = new NodeCommentMap();
        CommentHandler commHandler = new CommentHandler(comments);
        IASTDeclaration[] declarations = rootNode.getDeclarations();
        int i = 0;
        while (i < declarations.length) {
            if (ASTCommenter.isInWorkspace(declarations[i])) {
                ASTCommenterVisitor commenter = new ASTCommenterVisitor(commHandler, commentMap);
                declarations[i].accept(commenter);
                if (i + 1 == declarations.length) {
                    commenter.addRemainingComments(declarations[i]);
                }
            }
            ++i;
        }
        return commentMap;
    }

    private static final class PPRangeChecker
    extends ASTVisitor {
        int ppOffset;
        int commentOffset;
        boolean isPrePPComment = true;

        private PPRangeChecker(boolean visitNodes, int nextPPOfset, int commentNodeOffset) {
            super(visitNodes);
            this.ppOffset = nextPPOfset;
            this.commentOffset = commentNodeOffset;
        }

        private int checkOffsets(IASTNode node) {
            int offset = ((ASTNode)node).getOffset();
            int status = 3;
            if (offset > this.commentOffset && offset < this.ppOffset) {
                this.isPrePPComment = false;
                status = 2;
            } else if (offset + ((ASTNode)node).getLength() < this.commentOffset) {
                status = 1;
            } else if (offset > this.ppOffset) {
                status = 2;
            }
            return status;
        }

        public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
            return this.checkOffsets(baseSpecifier);
        }

        public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
            return this.checkOffsets(namespaceDefinition);
        }

        public int visit(ICPPASTTemplateParameter templateParameter) {
            return this.checkOffsets(templateParameter);
        }

        public int visit(IASTArrayModifier arrayModifier) {
            return this.checkOffsets(arrayModifier);
        }

        public int visit(IASTDeclaration declaration) {
            return this.checkOffsets(declaration);
        }

        public int visit(IASTDeclarator declarator) {
            return this.checkOffsets(declarator);
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return this.checkOffsets(declSpec);
        }

        public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            return this.checkOffsets(enumerator);
        }

        public int visit(IASTExpression expression) {
            return this.checkOffsets(expression);
        }

        public int visit(IASTInitializer initializer) {
            return this.checkOffsets(initializer);
        }

        public int visit(IASTName name) {
            return this.checkOffsets(name);
        }

        public int visit(IASTParameterDeclaration parameterDeclaration) {
            return this.checkOffsets(parameterDeclaration);
        }

        public int visit(IASTPointerOperator ptrOperator) {
            return this.checkOffsets(ptrOperator);
        }

        public int visit(IASTStatement statement) {
            return this.checkOffsets(statement);
        }

        public int visit(IASTTranslationUnit tu) {
            return this.checkOffsets(tu);
        }

        public int visit(IASTTypeId typeId) {
            return this.checkOffsets(typeId);
        }
    }
}

