/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBaseClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeHelper {
    private static final String DESTRUCTOR_OVERRIDE_KEY = "~";
    private static final int KIND_DEFAULT_CTOR = 0;
    private static final int KIND_COPY_CTOR = 1;
    private static final int KIND_ASSIGNMENT_OP = 2;
    private static final int KIND_DTOR = 3;
    private static final int KIND_OTHER = 4;

    public static IBinding[] getFriends(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] members;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getFriends();
                }
                IASTNode[] declarations = host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new IBinding[]{new ProblemBinding(node, 7, host.getNameCharArray())};
            }
        }
        ObjectSet<IBinding> resultSet = new ObjectSet<IBinding>(2);
        IASTDeclaration[] iASTDeclarationArray = members = host.getCompositeTypeSpecifier().getMembers();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTDeclSpecifier declSpec;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec.isFriend()) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && dtors.length == 0) {
                        resultSet.put(((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding());
                    } else {
                        IASTDeclarator[] iASTDeclaratorArray = dtors;
                        int n3 = dtors.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTDeclarator dtor = iASTDeclaratorArray[n4];
                            if (dtor != null) {
                                dtor = ASTQueries.findInnermostDeclarator(dtor);
                                resultSet.put(dtor.getName().resolveBinding());
                                ++n4;
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition && (declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier()).isFriend()) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = ASTQueries.findInnermostDeclarator(dtor);
                resultSet.put(dtor.getName().resolveBinding());
            }
            ++n2;
        }
        return resultSet.keyArray(IBinding.class);
    }

    public static boolean isFriend(IBinding binding, ICPPClassType classType) {
        block6: {
            block5: {
                if (!(binding instanceof ICPPClassType)) break block5;
                IType type = (IType)((Object)binding);
                if (type.isSameType(classType)) {
                    return true;
                }
                IBinding[] iBindingArray = classType.getFriends();
                int n = iBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding friend = iBindingArray[n2];
                    if (friend instanceof ICPPClassType && type.isSameType((IType)((Object)friend))) {
                        return true;
                    }
                    ++n2;
                }
                break block6;
            }
            if (!(binding instanceof ICPPFunction)) break block6;
            ICPPFunctionType type = ((ICPPFunction)binding).getType();
            char[] name = binding.getNameCharArray();
            IBinding[] iBindingArray = classType.getFriends();
            int n = iBindingArray.length;
            int n3 = 0;
            while (n3 < n) {
                IBinding friend = iBindingArray[n3];
                if (friend instanceof ICPPFunction && CharArrayUtils.equals(name, friend.getNameCharArray()) && SemanticUtil.isSameOwner(binding.getOwner(), friend.getOwner()) && type.isSameType(((ICPPFunction)friend).getType())) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private static ICPPClassType getBackupDefinition(ICPPInternalClassTypeMixinHost host) {
        ICPPClassType b;
        ICPPClassScope scope = host.getCompositeScope();
        if (scope != null && !((b = scope.getClassType()) instanceof ICPPInternalClassTypeMixinHost)) {
            return b;
        }
        return null;
    }

    public static ICPPBase[] getBases(ICPPInternalClassTypeMixinHost host) {
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getBases();
                }
                return ICPPBase.EMPTY_BASE_ARRAY;
            }
        }
        if ((bases = host.getCompositeTypeSpecifier().getBaseSpecifiers()).length == 0) {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
        ICPPBase[] bindings = new ICPPBase[bases.length];
        int i = 0;
        while (i < bases.length) {
            bindings[i] = new CPPBaseClause(bases[i]);
            ++i;
        }
        return bindings;
    }

    public static ICPPField[] getDeclaredFields(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] decls;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getDeclaredFields();
                }
                return ICPPField.EMPTY_CPPFIELD_ARRAY;
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] iASTDeclarationArray = decls = host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                n3 = dtors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n4];
                    binding = ASTQueries.findInnermostDeclarator(dtor).getName().resolveBinding();
                    if (binding instanceof ICPPField) {
                        result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, binding);
                    }
                    ++n4;
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n5 = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n5.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs;
                    IBinding[] iBindingArray = bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int n6 = bs.length;
                    n3 = 0;
                    while (n3 < n6) {
                        IBinding element = iBindingArray[n3];
                        if (element instanceof ICPPField) {
                            result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, element);
                        }
                        ++n3;
                    }
                } else if (binding instanceof ICPPField) {
                    result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, binding);
                }
            }
            ++n2;
        }
        return (ICPPField[])ArrayUtil.trim(ICPPField.class, result);
    }

    public static ICPPClassType[] getAllBases(ICPPClassType classType) {
        HashSet<ICPPClassType> result = new HashSet<ICPPClassType>();
        result.add(classType);
        ClassTypeHelper.getAllBases(classType, result);
        result.remove(classType);
        return result.toArray(new ICPPClassType[result.size()]);
    }

    private static void getAllBases(ICPPClassType classType, HashSet<ICPPClassType> result) {
        ICPPBase[] bases;
        ICPPBase[] iCPPBaseArray = bases = classType.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType baseClass;
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType && result.add(baseClass = (ICPPClassType)b)) {
                ClassTypeHelper.getAllBases(baseClass, result);
            }
            ++n2;
        }
    }

    public static boolean isSubclass(ICPPClassType subclass, ICPPClassType superclass) {
        ICPPBase[] bases;
        ICPPBase[] iCPPBaseArray = bases = subclass.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                ICPPClassType baseClass = (ICPPClassType)b;
                if (baseClass.isSameType(superclass)) {
                    return true;
                }
                if (ClassTypeHelper.isSubclass(baseClass, superclass)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static ICPPMethod[] getAllDeclaredMethods(ICPPClassType ct) {
        ICPPClassType[] bases;
        Object[] methods = ct.getDeclaredMethods();
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(ct);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            methods = (ICPPMethod[])ArrayUtil.addAll(ICPPMethod.class, methods, base.getDeclaredMethods());
            ++n2;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, methods);
    }

    public static ICPPMethod[] getMethods(ICPPClassType ct) {
        ICPPClassType[] bases;
        ObjectSet<ICPPMethod> set = ClassTypeHelper.getOwnMethods(ct);
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(ct);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            set.addAll((ICPPMethod[])base.getDeclaredMethods());
            IScope compositeScope = base.getCompositeScope();
            if (compositeScope instanceof ICPPClassScope) {
                set.addAll((ICPPMethod[])((ICPPClassScope)compositeScope).getImplicitMethods());
            }
            ++n2;
        }
        return set.keyArray(ICPPMethod.class);
    }

    private static ObjectSet<ICPPMethod> getOwnMethods(ICPPClassType classType) {
        ObjectSet<ICPPMethod> set = new ObjectSet<ICPPMethod>(4);
        set.addAll(classType.getDeclaredMethods());
        IScope scope = classType.getCompositeScope();
        if (scope instanceof ICPPClassScope) {
            set.addAll((ICPPMethod[])((ICPPClassScope)scope).getImplicitMethods());
        }
        return set;
    }

    public static ICPPMethod[] getDeclaredMethods(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] decls;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getDeclaredMethods();
                }
                return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] iASTDeclarationArray = decls = host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            Object[] objectArray;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
                if (!((ICPPASTDeclSpecifier)sdecl.getDeclSpecifier()).isFriend()) {
                    IASTDeclarator[] dtors = sdecl.getDeclarators();
                    objectArray = dtors;
                    n4 = dtors.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IASTDeclarator dtor = objectArray[n3];
                        binding = ASTQueries.findInnermostDeclarator(dtor).getName().resolveBinding();
                        if (binding instanceof ICPPMethod) {
                            result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                        }
                        ++n3;
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
                if (!((ICPPASTDeclSpecifier)fdef.getDeclSpecifier()).isFriend()) {
                    IASTDeclarator dtor = fdef.getDeclarator();
                    binding = (dtor = ASTQueries.findInnermostDeclarator(dtor)).getName().resolveBinding();
                    if (binding instanceof ICPPMethod) {
                        result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                    }
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n5 = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n5.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    objectArray = bs;
                    n4 = bs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object element = objectArray[n3];
                        if (element instanceof ICPPMethod) {
                            result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, element);
                        }
                        ++n3;
                    }
                } else if (binding instanceof ICPPMethod) {
                    result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                }
            }
            ++n2;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, result);
    }

    public static ICPPConstructor[] getConstructors(ICPPInternalClassTypeMixinHost host) {
        ICPPClassScope scope = host.getCompositeScope();
        if (scope == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        return scope.getConstructors();
    }

    public static ICPPClassType[] getNestedClasses(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] decls;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getNestedClasses();
                }
                return ICPPClassType.EMPTY_CLASS_ARRAY;
            }
        }
        Object[] result = null;
        IASTDeclaration[] iASTDeclarationArray = decls = host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IBinding binding = null;
                IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && ((IASTSimpleDeclaration)decl).getDeclarators().length == 0) {
                    binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                }
                if (binding instanceof ICPPClassType) {
                    result = (ICPPClassType[])ArrayUtil.append(ICPPClassType.class, result, binding);
                }
            }
            ++n2;
        }
        return (ICPPClassType[])ArrayUtil.trim(ICPPClassType.class, result);
    }

    public static IField[] getFields(ICPPClassType ct) {
        ICPPClassType[] bases;
        Object[] fields = ct.getDeclaredFields();
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(ct);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            fields = (IField[])ArrayUtil.addAll(IField.class, fields, base.getDeclaredFields());
            ++n2;
        }
        return (IField[])ArrayUtil.trim(IField.class, fields);
    }

    public static IField findField(ICPPClassType ct, String name) {
        IBinding[] bindings = CPPSemantics.findBindings(ct.getCompositeScope(), name, true);
        IField field = null;
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding instanceof IField) {
                if (field == null) {
                    field = (IField)binding;
                } else {
                    IASTNode[] decls = ASTInternal.getDeclarationsOfBinding(ct);
                    IASTNode node = decls != null && decls.length > 0 ? decls[0] : null;
                    return new CPPField.CPPFieldProblem(ct, node, 4, name.toCharArray());
                }
            }
            ++n2;
        }
        return field;
    }

    public static boolean isVirtual(ICPPMethod m) {
        if (m instanceof ICPPConstructor) {
            return false;
        }
        if (m.isVirtual()) {
            return true;
        }
        char[] mname = m.getNameCharArray();
        ICPPClassType mcl = m.getClassOwner();
        if (mcl != null) {
            ICPPMethod[] allMethods;
            ICPPFunctionType mft = m.getType();
            ICPPMethod[] iCPPMethodArray = allMethods = mcl.getMethods();
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (CharArrayUtils.equals(mname, method.getNameCharArray()) && ClassTypeHelper.functionTypesAllowOverride(mft, method.getType()) && method.isVirtual()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean functionTypesAllowOverride(ICPPFunctionType a, ICPPFunctionType b) {
        if (a.isConst() != b.isConst() || a.isVolatile() != b.isVolatile() || a.takesVarArgs() != b.takesVarArgs()) {
            return false;
        }
        IType[] paramsA = a.getParameterTypes();
        IType[] paramsB = b.getParameterTypes();
        if (paramsA.length == 1 && paramsB.length == 0) {
            if (!SemanticUtil.isVoidType(paramsA[0])) {
                return false;
            }
        } else if (paramsB.length == 1 && paramsA.length == 0) {
            if (!SemanticUtil.isVoidType(paramsB[0])) {
                return false;
            }
        } else {
            if (paramsA.length != paramsB.length) {
                return false;
            }
            int i = 0;
            while (i < paramsA.length) {
                if (paramsA[i] == null || !paramsA[i].isSameType(paramsB[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isOverrider(ICPPMethod source, ICPPMethod target) {
        ICPPClassType[] bases;
        if (source instanceof ICPPConstructor || target instanceof ICPPConstructor) {
            return false;
        }
        if (!ClassTypeHelper.isVirtual(target)) {
            return false;
        }
        if (!ClassTypeHelper.functionTypesAllowOverride(source.getType(), target.getType())) {
            return false;
        }
        ICPPClassType sourceClass = source.getClassOwner();
        ICPPClassType targetClass = target.getClassOwner();
        if (sourceClass == null || targetClass == null) {
            return false;
        }
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(sourceClass);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            if (base.isSameType(targetClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ICPPMethod[] findOverridden(ICPPMethod method) {
        ICPPBase[] bases;
        if (method instanceof ICPPConstructor) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        char[] mname = method.getNameCharArray();
        ICPPClassType mcl = method.getClassOwner();
        if (mcl == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
        HashMap<ICPPClassType, Boolean> virtualInClass = new HashMap<ICPPClassType, Boolean>();
        ICPPFunctionType mft = method.getType();
        virtualInClass.put(mcl, method.isVirtual());
        ICPPBase[] iCPPBaseArray = bases = mcl.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                ClassTypeHelper.findOverridden((ICPPClassType)b, mname, mft, virtualInClass, result);
            }
            ++n2;
        }
        Collections.reverse(result);
        return result.toArray(new ICPPMethod[result.size()]);
    }

    private static boolean findOverridden(ICPPClassType cl, char[] mname, ICPPFunctionType mft, HashMap<ICPPClassType, Boolean> virtualInClass, ArrayList<ICPPMethod> result) {
        ICPPBase[] bases;
        Boolean visitedBefore = virtualInClass.get(cl);
        if (visitedBefore != null) {
            return visitedBefore;
        }
        ICPPMethod[] methods = cl.getDeclaredMethods();
        ICPPMethod candidate = null;
        boolean hasOverridden = false;
        ICPPMethod[] iCPPMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (CharArrayUtils.equals(mname, method.getNameCharArray()) && ClassTypeHelper.functionTypesAllowOverride(mft, method.getType())) {
                candidate = method;
                hasOverridden = method.isVirtual();
                break;
            }
            ++n2;
        }
        virtualInClass.put(cl, hasOverridden);
        ICPPBase[] iCPPBaseArray = bases = cl.getBases();
        int n3 = bases.length;
        n = 0;
        while (n < n3) {
            ICPPBase base = iCPPBaseArray[n];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType && ClassTypeHelper.findOverridden((ICPPClassType)b, mname, mft, virtualInClass, result)) {
                hasOverridden = true;
            }
            ++n;
        }
        if (hasOverridden) {
            if (candidate != null) {
                result.add(candidate);
            }
            virtualInClass.put(cl, hasOverridden);
        }
        return hasOverridden;
    }

    public static ICPPMethod[] findOverriders(IIndex index, ICPPMethod method) throws CoreException {
        if (!ClassTypeHelper.isVirtual(method)) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        ICPPClassType mcl = method.getClassOwner();
        if (mcl == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        ICPPClassType[] subclasses = ClassTypeHelper.getSubClasses(index, mcl);
        return ClassTypeHelper.findOverriders(subclasses, method);
    }

    public static ICPPMethod[] findOverriders(ICPPClassType[] subclasses, ICPPMethod method) {
        char[] mname = method.getNameCharArray();
        ICPPFunctionType mft = method.getType();
        ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
        ICPPClassType[] iCPPClassTypeArray = subclasses;
        int n = subclasses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod[] methods;
            ICPPClassType subClass = iCPPClassTypeArray[n2];
            ICPPMethod[] iCPPMethodArray = methods = subClass.getDeclaredMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                ICPPMethod candidate = iCPPMethodArray[n4];
                if (CharArrayUtils.equals(mname, candidate.getNameCharArray()) && ClassTypeHelper.functionTypesAllowOverride(mft, candidate.getType())) {
                    result.add(candidate);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new ICPPMethod[result.size()]);
    }

    private static ICPPClassType[] getSubClasses(IIndex index, ICPPClassType mcl) throws CoreException {
        LinkedList<ICPPBinding> result = new LinkedList<ICPPBinding>();
        HashSet<String> handled = new HashSet<String>();
        ClassTypeHelper.getSubClasses(index, mcl, result, handled);
        result.remove(0);
        return result.toArray(new ICPPClassType[result.size()]);
    }

    private static void getSubClasses(IIndex index, ICPPBinding classOrTypedef, List<ICPPBinding> result, HashSet<String> handled) throws CoreException {
        IIndexName[] names;
        if (!(classOrTypedef instanceof IType)) {
            return;
        }
        String key = ASTTypeUtil.getType((IType)((Object)classOrTypedef), true);
        if (!handled.add(key)) {
            return;
        }
        if (classOrTypedef instanceof ICPPClassType) {
            result.add(classOrTypedef);
        }
        IIndexName[] iIndexNameArray = names = index.findNames(classOrTypedef, 6);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexBinding subClass;
            IIndexName subClassDef;
            IIndexName indexName = iIndexNameArray[n2];
            if (indexName.isBaseSpecifier() && (subClassDef = indexName.getEnclosingDefinition()) != null && (subClass = index.findBinding(subClassDef)) instanceof ICPPBinding) {
                ClassTypeHelper.getSubClasses(index, (ICPPBinding)((Object)subClass), result, handled);
            }
            ++n2;
        }
    }

    public static IType[] getInheritedExceptionSpecification(ICPPMethod implicitMethod) {
        ICPPClassType[] bases;
        ICPPClassType owner = implicitMethod.getClassOwner();
        if (owner == null || owner.getBases().length == 0) {
            return null;
        }
        int kind = ClassTypeHelper.getImplicitMethodKind(owner, implicitMethod);
        if (kind == 4) {
            return null;
        }
        ArrayList<IType> inheritedTypeids = new ArrayList<IType>();
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(owner);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod baseMethod;
            ICPPClassType base = iCPPClassTypeArray[n2];
            if (!(base instanceof ICPPDeferredClassInstance) && (baseMethod = ClassTypeHelper.getMethodInClass(base, kind)) != null) {
                IType[] baseExceptionSpec = baseMethod.getExceptionSpecification();
                if (baseExceptionSpec == null) {
                    return null;
                }
                IType[] iTypeArray = baseMethod.getExceptionSpecification();
                int n3 = iTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType baseTypeId = iTypeArray[n4];
                    inheritedTypeids.add(baseTypeId);
                    ++n4;
                }
            }
            ++n2;
        }
        return inheritedTypeids.toArray(new IType[inheritedTypeids.size()]);
    }

    private static int getImplicitMethodKind(ICPPClassType ct, ICPPMethod method) {
        if (method instanceof ICPPConstructor) {
            ICPPFunctionType type = method.getType();
            IType[] params = type.getParameterTypes();
            if (params.length == 0) {
                return 0;
            }
            if (params.length == 1) {
                IType t = SemanticUtil.getNestedType(params[0], 1);
                if (SemanticUtil.isVoidType(t)) {
                    return 0;
                }
                if (ClassTypeHelper.isRefToConstClass(ct, t)) {
                    return 1;
                }
            }
            return 4;
        }
        if (method.isDestructor()) {
            return 3;
        }
        if (CharArrayUtils.equals(method.getNameCharArray(), OverloadableOperator.ASSIGN.toCharArray())) {
            IType t;
            ICPPFunctionType type = method.getType();
            IType[] params = type.getParameterTypes();
            if (params.length == 1 && ClassTypeHelper.isRefToConstClass(ct, t = params[0])) {
                return 2;
            }
            return 4;
        }
        return 4;
    }

    private static boolean isRefToConstClass(ICPPClassType ct, IType t) {
        while (t instanceof ITypedef) {
            t = ((ITypedef)t).getType();
        }
        if (t instanceof ICPPReferenceType) {
            t = ((ICPPReferenceType)t).getType();
            while (t instanceof ITypedef) {
                t = ((ITypedef)t).getType();
            }
            if (t instanceof IQualifierType) {
                t = ((IQualifierType)t).getType();
                return ct.isSameType(t);
            }
        }
        return false;
    }

    private static ICPPMethod getMethodInClass(ICPPClassType ct, int kind) {
        switch (kind) {
            case 0: 
            case 1: {
                ICPPConstructor[] iCPPConstructorArray = ct.getConstructors();
                int n = iCPPConstructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor ctor = iCPPConstructorArray[n2];
                    if (!ctor.isImplicit() && ClassTypeHelper.getImplicitMethodKind(ct, ctor) == kind) {
                        return ctor;
                    }
                    ++n2;
                }
                return null;
            }
            case 2: {
                ICPPMethod[] iCPPMethodArray = ct.getDeclaredMethods();
                int n = iCPPMethodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ICPPMethod method = iCPPMethodArray[n3];
                    if (!(method instanceof ICPPConstructor) && ClassTypeHelper.getImplicitMethodKind(ct, method) == kind) {
                        return method;
                    }
                    ++n3;
                }
                return null;
            }
            case 3: {
                ICPPMethod[] iCPPMethodArray = ct.getDeclaredMethods();
                int n = iCPPMethodArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ICPPMethod method = iCPPMethodArray[n4];
                    if (method.isDestructor()) {
                        return method;
                    }
                    ++n4;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isAggregateClass(ICPPClassType classTarget) {
        ICPPField[] fields;
        ICPPMethod[] methods;
        if (classTarget.getBases().length > 0) {
            return false;
        }
        ICPPMethod[] iCPPMethodArray = methods = classTarget.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod m = iCPPMethodArray[n2];
            if (m instanceof ICPPConstructor) {
                return false;
            }
            if (m.isVirtual()) {
                return false;
            }
            ++n2;
        }
        ICPPField[] iCPPFieldArray = fields = classTarget.getDeclaredFields();
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            ICPPField field = iCPPFieldArray[n];
            if (field.getVisibility() != 1 && !field.isStatic()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static ICPPMethod[] getPureVirtualMethods(ICPPClassType classType) {
        Collection<Set<ICPPMethod>> result = ClassTypeHelper.collectPureVirtualMethods(classType).values();
        int resultArraySize = 0;
        for (Set<ICPPMethod> set : result) {
            resultArraySize += set.size();
        }
        ICPPMethod[] resultArray = new ICPPMethod[resultArraySize];
        int resultArrayIdx = 0;
        for (Set<ICPPMethod> methodsSet : result) {
            Iterator<ICPPMethod> iterator = methodsSet.iterator();
            while (iterator.hasNext()) {
                ICPPMethod method;
                resultArray[resultArrayIdx] = method = iterator.next();
                ++resultArrayIdx;
            }
        }
        return resultArray;
    }

    private static String getMethodNameForOverrideKey(ICPPMethod method) {
        if (method.isDestructor()) {
            return DESTRUCTOR_OVERRIDE_KEY;
        }
        return method.getName();
    }

    private static Map<String, Set<ICPPMethod>> collectPureVirtualMethods(ICPPClassType classType) {
        HashMap<String, Set<ICPPMethod>> pureVirtualMethods = new HashMap<String, Set<ICPPMethod>>();
        Object[] objectArray = classType.getBases();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = objectArray[n2];
            if (base.getBaseClass() instanceof ICPPClassType) {
                ICPPClassType baseClass = (ICPPClassType)base.getBaseClass();
                Map<String, Set<ICPPMethod>> derivedPureVirtualMethods = ClassTypeHelper.collectPureVirtualMethods(baseClass);
                for (Map.Entry<String, Set<ICPPMethod>> currMethodEntry : derivedPureVirtualMethods.entrySet()) {
                    Set methodsSet = (Set)pureVirtualMethods.get(currMethodEntry.getKey());
                    if (methodsSet == null) {
                        pureVirtualMethods.put(currMethodEntry.getKey(), currMethodEntry.getValue());
                        continue;
                    }
                    methodsSet.addAll((Collection)currMethodEntry.getValue());
                }
            }
            ++n2;
        }
        for (ICPPMethod declaredMethod : ClassTypeHelper.getOwnMethods(classType).toList()) {
            Set methodsSet = (Set)pureVirtualMethods.get(ClassTypeHelper.getMethodNameForOverrideKey(declaredMethod));
            if (methodsSet == null) continue;
            Iterator methodIt = methodsSet.iterator();
            while (methodIt.hasNext()) {
                ICPPMethod method = (ICPPMethod)methodIt.next();
                if (!ClassTypeHelper.functionTypesAllowOverride(declaredMethod.getType(), method.getType())) continue;
                methodIt.remove();
            }
            if (!methodsSet.isEmpty()) continue;
            pureVirtualMethods.remove(ClassTypeHelper.getMethodNameForOverrideKey(declaredMethod));
        }
        objectArray = classType.getDeclaredMethods();
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object method = objectArray[n3];
            if (method.isPureVirtual()) {
                HashSet<Object> methodsSet = (HashSet<Object>)pureVirtualMethods.get(ClassTypeHelper.getMethodNameForOverrideKey((ICPPMethod)method));
                if (methodsSet == null) {
                    methodsSet = new HashSet<Object>();
                    pureVirtualMethods.put(ClassTypeHelper.getMethodNameForOverrideKey((ICPPMethod)method), methodsSet);
                }
                methodsSet.add(method);
            }
            ++n3;
        }
        return pureVirtualMethods;
    }
}

