/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ViewLabelProvider
extends ColumnLabelProvider {
    private static final String FOLDER_ICON = "org.eclipse.e4.descriptor.folder";
    private Map<String, Image> imageMap = new HashMap<String, Image>();
    private IEclipseContext context;
    private final Color dimmedForeground;
    private EModelService modelService;
    private MWindow window;
    private EPartService partService;

    public ViewLabelProvider(IEclipseContext context, EModelService modelService, EPartService partService, MWindow window, Color dimmedForeground) {
        this.context = context;
        this.modelService = modelService;
        this.partService = partService;
        this.window = window;
        this.dimmedForeground = dimmedForeground;
    }

    public void dispose() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof MPartDescriptor) {
            String iconURI = ((MPartDescriptor)element).getIconURI();
            if (iconURI != null && iconURI.length() > 0) {
                Image image = this.imageMap.get(iconURI);
                if (image == null) {
                    ISWTResourceUtilities resUtils = (ISWTResourceUtilities)this.context.get(IResourceUtilities.class.getName());
                    image = ((ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))).createImage();
                    this.imageMap.put(iconURI, image);
                }
                return image;
            }
            return null;
        }
        if (element instanceof String) {
            Image image = this.imageMap.get(FOLDER_ICON);
            if (image == null) {
                ImageDescriptor desc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
                image = desc.createImage();
                this.imageMap.put(FOLDER_ICON, desc.createImage());
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        String label = WorkbenchMessages.ViewLabel_unknown;
        if (element instanceof String) {
            label = (String)element;
        } else if (element instanceof MPartDescriptor) {
            label = ((MPartDescriptor)element).getLocalizedLabel();
        }
        return label;
    }

    public Color getForeground(Object element) {
        MPerspective activePerspective;
        String elementId;
        if (element instanceof MApplicationElement && this.partService.isPartOrPlaceholderInPerspective(elementId = ((MApplicationElement)element).getElementId(), activePerspective = this.modelService.getActivePerspective(this.window))) {
            return this.dimmedForeground;
        }
        return null;
    }
}

