/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class AboutInfo {
    private static final String daAboutFilePath = String.valueOf(PathManager.getWorkbenchPluginPath()) + File.separator + "about.mappings";
    private static final String daVersionFilePath = String.valueOf(PathManager.DA_INSTALL_PATH) + File.separator + "version";
    private static final String sdkVersionFilePath = String.valueOf(PathManager.TIZEN_SDK_INSTALL_PATH) + File.separator + "sdk.version";
    private String sdkBuildVersionInfo = "";
    private String daBuildIDInfo = "";
    private String daVersionInfo = "";
    private String tizenSite = "";
    private String releaseNote = "";
    private static AboutInfo instance = new AboutInfo();

    private AboutInfo() {
        this.updateDABuildInfo();
        this.sdkBuildVersionInfo = this.parseSdkVersionFile();
        this.tizenSite = AnalyzerLabels.TIZEN_SITE_LINK;
        this.releaseNote = AnalyzerLabels.RELEASE_NOTE_LINK;
    }

    public static AboutInfo getInstance() {
        return instance;
    }

    public String getSDKVersion() {
        return this.sdkBuildVersionInfo;
    }

    public String getDABuildID() {
        return this.daBuildIDInfo;
    }

    public String getDAVersion() {
        return this.daVersionInfo;
    }

    public String getTizenSite() {
        return this.tizenSite;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    private String parseBuildVersion(String readData) {
        String[] splitData = readData.split("0=");
        int size = splitData.length;
        if (2 != size) {
            return null;
        }
        return splitData[1];
    }

    private static String parseBuildTime(String readData) {
        String[] splitData = readData.split("1=");
        int size = splitData.length;
        if (2 != size) {
            return null;
        }
        return splitData[1];
    }

    /*
     * Exception decompiling
     */
    private String parseSdkVersionFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateDABuildInfo() {
        block18: {
            BufferedReader in;
            block17: {
                File SDKAboutFile = new File(daAboutFilePath);
                if (!SDKAboutFile.exists()) {
                    Logger.warning((Object)("File does not exist: " + daAboutFilePath));
                    return;
                }
                in = null;
                try {
                    String content;
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(SDKAboutFile), StandardCharsets.UTF_8);
                    in = new BufferedReader(reader);
                    while ((content = in.readLine()) != null) {
                        String buildTime;
                        String buildVersion = this.parseBuildVersion(content);
                        if (buildVersion != null) {
                            this.sdkBuildVersionInfo = buildVersion;
                        }
                        if ((buildTime = AboutInfo.parseBuildTime(content)) == null) continue;
                        this.daBuildIDInfo = buildTime;
                    }
                }
                catch (FileNotFoundException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    break block17;
                }
                catch (IOException e) {
                    try {
                        Logger.exception((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        throw throwable;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    break block17;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
            }
            File DAVersionFile = new File(daVersionFilePath);
            if (!DAVersionFile.exists()) {
                Logger.warning((Object)("File does not exist: " + daAboutFilePath));
                return;
            }
            String daversion = "";
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(DAVersionFile), StandardCharsets.UTF_8);
                in = new BufferedReader(reader);
                while ((daversion = in.readLine()) != null) {
                    this.daVersionInfo = daversion;
                }
            }
            catch (FileNotFoundException e) {
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block18;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block18;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }
}

