/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.util.OSChecker;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.model.AddrSymbolPair;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElfSymbolExtractor {
    private String sourcePath = null;
    private HashMap<Long, String> symbolMap = new HashMap();
    private List<AddrSymbolPair> addrSymbolPairs = new ArrayList<AddrSymbolPair>();
    private static String symTabFormat = "([a-f0-9]{8})[ \t]+[lgu! ][w ][C ][W ][Ii ][dD ]F[ \t]+[a-zA-Z0-9_:.]+[ \t]+[a-f0-9]{8}[ \t]+[a-zA-Z0-9_:.]*[ \t]+([a-zA-Z0-9_:.].+)$";
    private static Pattern symb = Pattern.compile(symTabFormat);

    public boolean makeSymbol(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        this.sourcePath = path;
        if (this.symbolMap != null) {
            this.symbolMap.clear();
        } else {
            this.symbolMap = new HashMap();
        }
        String cmd = String.valueOf(PathManager.TIZEN_SDK_INSTALL_PATH) + File.separator + "tools" + PathManager.getBinaryToolsPath((boolean)Global.getCurrentDeviceInfo().isEmulator()) + "objdump" + (OSChecker.isWindows() ? ".exe" : "") + " -CtT --special-syms --wide " + this.sourcePath;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.parseObjectData(br);
            br.close();
        }
        catch (IOException e) {
            Logger.error((Object)e);
            return false;
        }
        return true;
    }

    void parseObjectData(BufferedReader br) throws IOException {
        String line = br.readLine();
        while (line != null) {
            String hexaddr;
            long addr;
            Matcher m = symb.matcher(line);
            if (m.matches() && (addr = Long.decode("0x" + (hexaddr = m.group(1))).longValue()) > 0L) {
                String name = m.group(2);
                if (name.startsWith("_Z")) {
                    name = SymbolManager.demanglingFunctionName(this.sourcePath, name);
                }
                this.symbolMap.put(addr, name);
                this.addrSymbolPairs.add(new AddrSymbolPair(addr, name));
            }
            line = br.readLine();
        }
    }

    public void setLibPath(String libPath) {
        this.sourcePath = libPath;
    }

    public String getLibPath() {
        return this.sourcePath;
    }

    public void clear() {
        this.sourcePath = null;
        if (this.symbolMap != null) {
            this.symbolMap.clear();
        }
        if (this.addrSymbolPairs != null) {
            this.addrSymbolPairs.clear();
        }
    }

    public List<AddrSymbolPair> getAddrSymbolPairs() {
        return this.addrSymbolPairs;
    }
}

