/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.failed;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiDataDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FailedApiDataMaker {
    private static final String query_withPid = "where %s = %s";
    private static final String query_withTime = "where %s >= %s and %s <= %s";
    private static final String query_withPidAndTime = "where %s = %s and %s >= %s and %s <= %s";
    private static final String query_orderby = " order by %s";
    private DBInserter failedAPI_DBInserter = null;

    public FailedApiDataMaker(DBInserter inserter) {
        this.failedAPI_DBInserter = inserter;
    }

    public void makeData(List<LogData> inputs) {
        ArrayList failedApiDataList = new ArrayList();
        int size = inputs.size();
        int i = 0;
        while (i < size) {
            LogData input = inputs.get(i);
            ProbeCommonData pData = (ProbeCommonData)input;
            if (this.failChecker(pData)) {
                ArrayList<Object> dbFailedData = new ArrayList<Object>();
                dbFailedData.add(pData.getSeq());
                dbFailedData.add(pData.getApiId());
                dbFailedData.add(pData.getPid());
                dbFailedData.add(pData.getTime());
                dbFailedData.add(String.valueOf(pData.getArgs()));
                dbFailedData.add(String.valueOf(pData.getReturn()));
                dbFailedData.add(pData.getErrno());
                dbFailedData.add(pData.getCallerPcAddr());
                dbFailedData.add(String.valueOf(pData.getLibName()));
                dbFailedData.add(pData.getMsgID());
                failedApiDataList.add(dbFailedData);
            }
            ++i;
        }
        if (failedApiDataList.size() > 0) {
            this.failedAPI_DBInserter.pushData(failedApiDataList);
        }
    }

    public void makeData(LogData input) {
        ProbeCommonData pData = (ProbeCommonData)input;
        if (this.failChecker(pData)) {
            ArrayList failedApiDataList = new ArrayList();
            ArrayList<Object> dbFailedData = new ArrayList<Object>();
            dbFailedData.add(pData.getSeq());
            dbFailedData.add(pData.getApiId());
            dbFailedData.add(pData.getPid());
            dbFailedData.add(pData.getTime());
            dbFailedData.add(String.valueOf(pData.getArgs()));
            dbFailedData.add(String.valueOf(pData.getReturn()));
            dbFailedData.add(pData.getErrno());
            dbFailedData.add(pData.getCallerPcAddr());
            dbFailedData.add(String.valueOf(pData.getLibName()));
            dbFailedData.add(pData.getMsgID());
            failedApiDataList.add(dbFailedData);
            this.failedAPI_DBInserter.pushData(failedApiDataList);
        }
    }

    private boolean failChecker(ProbeCommonData log) {
        return !log.isInternal();
    }

    public void clear() {
    }

    public List<List<Object>> getFailedApiDataFromDB(int selectedPid, List<String> whereQueryList) {
        String where = null;
        if (selectedPid != 0) {
            where = String.format(query_withPid, FailedApiDataDBTable.COLUMN.PID.name, String.valueOf(selectedPid));
        }
        if (whereQueryList != null && !whereQueryList.isEmpty()) {
            int i = 0;
            while (i < whereQueryList.size()) {
                where = where == null ? " where " + whereQueryList.get(i) : String.valueOf(where) + " and " + whereQueryList.get(i);
                ++i;
            }
        }
        return this.executeQuery(where);
    }

    public List<List<Object>> getFailedApiDataFromDBForRange(Long startTime, Long endTime, int selectedPid, List<String> whereQueryList) {
        String where = null;
        where = selectedPid != 0 ? String.format(query_withPidAndTime, FailedApiDataDBTable.COLUMN.PID.name, String.valueOf(selectedPid), FailedApiDataDBTable.COLUMN.START_TIME.name, startTime.toString(), FailedApiDataDBTable.COLUMN.START_TIME.name, endTime.toString()) : String.format(query_withTime, FailedApiDataDBTable.COLUMN.START_TIME.name, startTime.toString(), FailedApiDataDBTable.COLUMN.START_TIME.name, endTime.toString());
        if (whereQueryList != null && !whereQueryList.isEmpty()) {
            int i = 0;
            while (i < whereQueryList.size()) {
                where = String.valueOf(where) + " and " + whereQueryList.get(i);
                ++i;
            }
        }
        where = String.valueOf(where) + String.format(query_orderby, FailedApiDataDBTable.COLUMN.START_TIME.name);
        return this.executeQuery(where);
    }

    private List<List<Object>> executeQuery(String whereOption) {
        DBTable table = SummaryDataManager.getInstance().getFailedApiDataDBTable();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(FailedApiDataDBTable.COLUMN.SEQUENCE_NUMBER.name);
        columns.add(FailedApiDataDBTable.COLUMN.API_ID.name);
        columns.add(FailedApiDataDBTable.COLUMN.PID.name);
        columns.add(FailedApiDataDBTable.COLUMN.START_TIME.name);
        columns.add(FailedApiDataDBTable.COLUMN.ARGUMENT.name);
        columns.add(FailedApiDataDBTable.COLUMN.RETURN_VALUE.name);
        columns.add(FailedApiDataDBTable.COLUMN.ERROR_NUMBER.name);
        columns.add(FailedApiDataDBTable.COLUMN.CALLER_PC_ADDRESS.name);
        columns.add(FailedApiDataDBTable.COLUMN.CALLER_LIBRARY_NAME.name);
        columns.add(FailedApiDataDBTable.COLUMN.MESSAGE_ID.name);
        return table.selectData(columns, whereOption, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getLong(1));
                    row.add(rs.getInt(2));
                    row.add(rs.getInt(3));
                    row.add(rs.getLong(4));
                    row.add(rs.getString(5));
                    row.add(rs.getString(6));
                    row.add(rs.getLong(7));
                    row.add(rs.getLong(8));
                    row.add(rs.getString(9));
                    row.add(rs.getInt(10));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }
}

